/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.mongodb.internal.operation.Cursor;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

class CommandBatchCursor<T>
implements AggregateResponseBatchCursor<T> {
    private final TimeoutMode timeoutMode;
    private OperationContext operationContext;
    private Cursor<T> wrapped;

    CommandBatchCursor(TimeoutMode timeoutMode, long maxTimeMs, OperationContext operationContext, Cursor<T> wrapped) {
        this.operationContext = operationContext.withOverride(timeoutContext -> timeoutContext.withMaxTimeOverride(maxTimeMs));
        this.timeoutMode = timeoutMode;
        this.wrapped = wrapped;
    }

    @Override
    public boolean hasNext() {
        this.resetTimeout();
        return this.wrapped.hasNext(this.operationContext);
    }

    @Override
    public List<T> next() {
        this.resetTimeout();
        return this.wrapped.next(this.operationContext);
    }

    @Override
    public int available() {
        return this.wrapped.available();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.wrapped.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public void close() {
        this.operationContext = this.operationContext.withOverride(timeoutContext -> timeoutContext.withNewlyStartedTimeout().withDefaultMaxTime());
        this.wrapped.close(this.operationContext);
    }

    @Override
    @Nullable
    public List<T> tryNext() {
        this.resetTimeout();
        return this.wrapped.tryNext(this.operationContext);
    }

    @Override
    @Nullable
    public ServerCursor getServerCursor() {
        return this.wrapped.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.wrapped.getServerAddress();
    }

    @Override
    @Nullable
    public BsonDocument getPostBatchResumeToken() {
        return this.wrapped.getPostBatchResumeToken();
    }

    @Override
    @Nullable
    public BsonTimestamp getOperationTime() {
        return this.wrapped.getOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.wrapped.isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.wrapped.getMaxWireVersion();
    }

    private void resetTimeout() {
        if (this.timeoutMode == TimeoutMode.ITERATION) {
            this.operationContext = this.operationContext.withNewlyStartedTimeout();
        }
    }

    Cursor<T> getWrapped() {
        return this.wrapped;
    }
}

