/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ClientBulkWriteException;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoServerException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientDeleteResult;
import com.mongodb.client.model.bulk.ClientInsertOneResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.client.model.bulk.ClientUpdateResult;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.MongoNamespaceHelper;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.AsyncSupplier;
import com.mongodb.internal.async.MutableValue;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.client.model.bulk.AbstractClientDeleteModel;
import com.mongodb.internal.client.model.bulk.AbstractClientDeleteOptions;
import com.mongodb.internal.client.model.bulk.AbstractClientNamespacedWriteModel;
import com.mongodb.internal.client.model.bulk.AbstractClientUpdateModel;
import com.mongodb.internal.client.model.bulk.AbstractClientUpdateOptions;
import com.mongodb.internal.client.model.bulk.AcknowledgedSummaryClientBulkWriteResult;
import com.mongodb.internal.client.model.bulk.AcknowledgedVerboseClientBulkWriteResult;
import com.mongodb.internal.client.model.bulk.ClientWriteModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientBulkWriteOptions;
import com.mongodb.internal.client.model.bulk.ConcreteClientDeleteManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientDeleteOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientDeleteResult;
import com.mongodb.internal.client.model.bulk.ConcreteClientInsertOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientInsertOneResult;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedDeleteManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedDeleteOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedInsertOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedReplaceOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedUpdateManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedUpdateOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientReplaceOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientReplaceOneOptions;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateOneOptions;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateResult;
import com.mongodb.internal.client.model.bulk.UnacknowledgedClientBulkWriteResult;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.DualMessageSequences;
import com.mongodb.internal.connection.IdHoldingBsonWriter;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.BulkWriteBatch;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.operation.retry.AttachmentKeys;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.internal.validator.ReplacingDocumentFieldNameValidator;
import com.mongodb.internal.validator.UpdateFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonArray;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.FieldNameValidator;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public final class ClientBulkWriteOperation
implements WriteOperation<ClientBulkWriteResult> {
    private static final ConcreteClientBulkWriteOptions EMPTY_OPTIONS = new ConcreteClientBulkWriteOptions();
    private static final String BULK_WRITE_COMMAND_NAME = "bulkWrite";
    private static final EncoderContext DEFAULT_ENCODER_CONTEXT = EncoderContext.builder().build();
    private static final EncoderContext COLLECTIBLE_DOCUMENT_ENCODER_CONTEXT = EncoderContext.builder().isEncodingCollectibleDocument(true).build();
    private static final int INITIAL_BATCH_MODEL_START_INDEX = 0;
    private static final int SERVER_DEFAULT_CURSOR_BATCH_SIZE = 0;
    private final List<? extends ClientNamespacedWriteModel> models;
    private final ConcreteClientBulkWriteOptions options;
    private final WriteConcern writeConcernSetting;
    private final boolean retryWritesSetting;
    private final CodecRegistry codecRegistry;

    public ClientBulkWriteOperation(List<? extends ClientNamespacedWriteModel> models, @Nullable ClientBulkWriteOptions options, WriteConcern writeConcernSetting, boolean retryWritesSetting, CodecRegistry codecRegistry) {
        this.models = models;
        this.options = options == null ? EMPTY_OPTIONS : (ConcreteClientBulkWriteOptions)options;
        this.writeConcernSetting = writeConcernSetting;
        this.retryWritesSetting = retryWritesSetting;
        this.codecRegistry = codecRegistry;
    }

    @Override
    public String getCommandName() {
        return BULK_WRITE_COMMAND_NAME;
    }

    @Override
    public MongoNamespace getNamespace() {
        return MongoNamespaceHelper.ADMIN_DB_COMMAND_NAMESPACE;
    }

    @Override
    public ClientBulkWriteResult execute(WriteBinding binding, OperationContext operationContext) throws ClientBulkWriteException {
        WriteConcern effectiveWriteConcern = this.validateAndGetEffectiveWriteConcern(operationContext.getSessionContext());
        ResultAccumulator resultAccumulator = new ResultAccumulator();
        MongoException transformedTopLevelError = null;
        try {
            this.executeAllBatches(effectiveWriteConcern, binding, operationContext, resultAccumulator);
        }
        catch (MongoException topLevelError) {
            transformedTopLevelError = CommandOperationHelper.transformWriteException(topLevelError);
        }
        return resultAccumulator.build(transformedTopLevelError, effectiveWriteConcern);
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, OperationContext operationContext, SingleResultCallback<ClientBulkWriteResult> finalCallback) {
        WriteConcern effectiveWriteConcern = this.validateAndGetEffectiveWriteConcern(operationContext.getSessionContext());
        ResultAccumulator resultAccumulator = new ResultAccumulator();
        MutableValue transformedTopLevelError = new MutableValue();
        AsyncRunnable.beginAsync().thenSupply(c -> this.executeAllBatchesAsync(effectiveWriteConcern, binding, operationContext, resultAccumulator, c)).onErrorIf(topLevelError -> topLevelError instanceof MongoException, (topLevelError, c) -> {
            transformedTopLevelError.set(CommandOperationHelper.transformWriteException((MongoException)topLevelError));
            c.complete(c);
        }).thenApply((ignored, c) -> c.complete(resultAccumulator.build((MongoException)transformedTopLevelError.getNullable(), effectiveWriteConcern))).finish(finalCallback);
    }

    private void executeAllBatches(WriteConcern effectiveWriteConcern, WriteBinding binding, OperationContext operationContext, ResultAccumulator resultAccumulator) throws MongoException {
        Integer nextBatchStartModelIndex = 0;
        while ((nextBatchStartModelIndex = this.executeBatch(nextBatchStartModelIndex, effectiveWriteConcern, binding, operationContext, resultAccumulator)) != null) {
        }
    }

    private void executeAllBatchesAsync(WriteConcern effectiveWriteConcern, AsyncWriteBinding binding, OperationContext operationContext, ResultAccumulator resultAccumulator, SingleResultCallback<Void> finalCallback) {
        MutableValue<Integer> nextBatchStartModelIndex = new MutableValue<Integer>(0);
        AsyncRunnable.beginAsync().thenRunDoWhileLoop(iterationCallback -> AsyncRunnable.beginAsync().thenSupply(c -> this.executeBatchAsync((Integer)nextBatchStartModelIndex.get(), effectiveWriteConcern, binding, operationContext, resultAccumulator, c)).thenApply((nextBatchStartModelIdx, c) -> {
            nextBatchStartModelIndex.set((Integer)nextBatchStartModelIdx);
            c.complete(c);
        }).finish(iterationCallback), () -> nextBatchStartModelIndex.getNullable() != null).finish(finalCallback);
    }

    @Nullable
    private Integer executeBatch(int batchStartModelIndex, WriteConcern effectiveWriteConcern, WriteBinding binding, OperationContext operationContext, ResultAccumulator resultAccumulator) {
        List<? extends ClientNamespacedWriteModel> unexecutedModels = this.models.subList(batchStartModelIndex, this.models.size());
        Assertions.assertFalse(unexecutedModels.isEmpty());
        SessionContext sessionContext = operationContext.getSessionContext();
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryWritesSetting, timeoutContext);
        BatchEncoder batchEncoder = new BatchEncoder();
        Supplier<ExhaustiveClientBulkWriteCommandOkResponse> retryingBatchExecutor = SyncOperationHelper.decorateWriteWithRetries(retryState, operationContext, () -> SyncOperationHelper.withSourceAndConnection(binding::getWriteConnectionSource, true, (connectionSource, connection, operationContextWithMinRtt) -> {
            ConnectionDescription connectionDescription = connection.getDescription();
            boolean effectiveRetryWrites = OperationHelper.isRetryableWrite(this.retryWritesSetting, effectiveWriteConcern, connectionDescription, sessionContext);
            retryState.breakAndThrowIfRetryAnd(() -> !effectiveRetryWrites);
            resultAccumulator.onNewServerAddress(connectionDescription.getServerAddress());
            retryState.attach(AttachmentKeys.maxWireVersion(), connectionDescription.getMaxWireVersion(), true).attach(AttachmentKeys.commandDescriptionSupplier(), () -> BULK_WRITE_COMMAND_NAME, false);
            ClientBulkWriteCommand bulkWriteCommand = this.createBulkWriteCommand(retryState, effectiveRetryWrites, effectiveWriteConcern, sessionContext, unexecutedModels, batchEncoder, () -> retryState.attach(AttachmentKeys.retryableCommandFlag(), true, true));
            return this.executeBulkWriteCommandAndExhaustOkResponse(retryState, connectionSource, connection, bulkWriteCommand, effectiveWriteConcern, operationContextWithMinRtt);
        }, operationContext));
        try {
            ExhaustiveClientBulkWriteCommandOkResponse bulkWriteCommandOkResponse = retryingBatchExecutor.get();
            return resultAccumulator.onBulkWriteCommandOkResponseOrNoResponse(batchStartModelIndex, bulkWriteCommandOkResponse, batchEncoder.intoEncodedBatchInfo());
        }
        catch (MongoWriteConcernWithResponseException mongoWriteConcernWithOkResponseException) {
            return resultAccumulator.onBulkWriteCommandOkResponseWithWriteConcernError(batchStartModelIndex, mongoWriteConcernWithOkResponseException, batchEncoder.intoEncodedBatchInfo());
        }
        catch (MongoCommandException bulkWriteCommandException) {
            resultAccumulator.onBulkWriteCommandErrorResponse(bulkWriteCommandException);
            throw bulkWriteCommandException;
        }
        catch (MongoException mongoException) {
            CommandOperationHelper.shouldAttemptToRetryWriteAndAddRetryableLabel(retryState, mongoException);
            resultAccumulator.onBulkWriteCommandErrorWithoutResponse(mongoException);
            throw mongoException;
        }
    }

    private void executeBatchAsync(int batchStartModelIndex, WriteConcern effectiveWriteConcern, AsyncWriteBinding binding, OperationContext operationContext, ResultAccumulator resultAccumulator, SingleResultCallback<Integer> finalCallback) {
        List<? extends ClientNamespacedWriteModel> unexecutedModels = this.models.subList(batchStartModelIndex, this.models.size());
        Assertions.assertFalse(unexecutedModels.isEmpty());
        SessionContext sessionContext = operationContext.getSessionContext();
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryWritesSetting, timeoutContext);
        BatchEncoder batchEncoder = new BatchEncoder();
        AsyncCallbackSupplier retryingBatchExecutor = AsyncOperationHelper.decorateWriteWithRetriesAsync(retryState, operationContext, funcCallback -> AsyncOperationHelper.withAsyncSourceAndConnection(binding::getWriteConnectionSource, true, operationContext, funcCallback, (connectionSource, connection, operationContextWithMinRtt, resultCallback) -> {
            ConnectionDescription connectionDescription = connection.getDescription();
            boolean effectiveRetryWrites = OperationHelper.isRetryableWrite(this.retryWritesSetting, effectiveWriteConcern, connectionDescription, sessionContext);
            retryState.breakAndThrowIfRetryAnd(() -> !effectiveRetryWrites);
            resultAccumulator.onNewServerAddress(connectionDescription.getServerAddress());
            retryState.attach(AttachmentKeys.maxWireVersion(), connectionDescription.getMaxWireVersion(), true).attach(AttachmentKeys.commandDescriptionSupplier(), () -> BULK_WRITE_COMMAND_NAME, false);
            ClientBulkWriteCommand bulkWriteCommand = this.createBulkWriteCommand(retryState, effectiveRetryWrites, effectiveWriteConcern, sessionContext, unexecutedModels, batchEncoder, () -> retryState.attach(AttachmentKeys.retryableCommandFlag(), true, true));
            this.executeBulkWriteCommandAndExhaustOkResponseAsync(retryState, (AsyncConnectionSource)connectionSource, (AsyncConnection)connection, bulkWriteCommand, effectiveWriteConcern, (OperationContext)operationContextWithMinRtt, resultCallback);
        }));
        AsyncRunnable.beginAsync().thenSupply(callback -> retryingBatchExecutor.get(callback)).thenApply((bulkWriteCommandOkResponse, callback) -> callback.complete(resultAccumulator.onBulkWriteCommandOkResponseOrNoResponse(batchStartModelIndex, (ExhaustiveClientBulkWriteCommandOkResponse)bulkWriteCommandOkResponse, batchEncoder.intoEncodedBatchInfo()))).onErrorIf(throwable -> true, (t, callback) -> {
            if (t instanceof MongoWriteConcernWithResponseException) {
                MongoWriteConcernWithResponseException mongoWriteConcernWithOkResponseException = (MongoWriteConcernWithResponseException)t;
                callback.complete(resultAccumulator.onBulkWriteCommandOkResponseWithWriteConcernError(batchStartModelIndex, mongoWriteConcernWithOkResponseException, batchEncoder.intoEncodedBatchInfo()));
            } else if (t instanceof MongoCommandException) {
                MongoCommandException bulkWriteCommandException = (MongoCommandException)t;
                resultAccumulator.onBulkWriteCommandErrorResponse(bulkWriteCommandException);
                callback.completeExceptionally((Throwable)t);
            } else if (t instanceof MongoException) {
                MongoException mongoException = (MongoException)t;
                CommandOperationHelper.shouldAttemptToRetryWriteAndAddRetryableLabel(retryState, mongoException);
                resultAccumulator.onBulkWriteCommandErrorWithoutResponse(mongoException);
                callback.completeExceptionally(mongoException);
            } else {
                callback.completeExceptionally((Throwable)t);
            }
        }).finish(finalCallback);
    }

    @Nullable
    private ExhaustiveClientBulkWriteCommandOkResponse executeBulkWriteCommandAndExhaustOkResponse(RetryState retryState, ConnectionSource connectionSource, Connection connection, ClientBulkWriteCommand bulkWriteCommand, WriteConcern effectiveWriteConcern, OperationContext operationContext) throws MongoWriteConcernWithResponseException {
        BsonDocument bulkWriteCommandOkResponse = connection.command(MongoNamespaceHelper.ADMIN_DB_COMMAND_NAMESPACE.getDatabaseName(), bulkWriteCommand.getCommandDocument(), NoOpFieldNameValidator.INSTANCE, (ReadPreference)null, CommandResultDocumentCodec.create(this.codecRegistry.get(BsonDocument.class), "firstBatch"), operationContext, effectiveWriteConcern.isAcknowledged(), bulkWriteCommand.getOpsAndNsInfo());
        if (bulkWriteCommandOkResponse == null) {
            return null;
        }
        List cursorExhaustBatches = this.doWithRetriesDisabledForCommand(retryState, "getMore", () -> this.exhaustBulkWriteCommandOkResponseCursor(connectionSource, operationContext, connection, bulkWriteCommandOkResponse));
        return ClientBulkWriteOperation.createExhaustiveClientBulkWriteCommandOkResponse(bulkWriteCommandOkResponse, cursorExhaustBatches, connection.getDescription());
    }

    private void executeBulkWriteCommandAndExhaustOkResponseAsync(RetryState retryState, AsyncConnectionSource connectionSource, AsyncConnection connection, ClientBulkWriteCommand bulkWriteCommand, WriteConcern effectiveWriteConcern, OperationContext operationContext, SingleResultCallback<ExhaustiveClientBulkWriteCommandOkResponse> finalCallback) {
        AsyncRunnable.beginAsync().thenSupply(callback -> connection.commandAsync(MongoNamespaceHelper.ADMIN_DB_COMMAND_NAMESPACE.getDatabaseName(), bulkWriteCommand.getCommandDocument(), NoOpFieldNameValidator.INSTANCE, (ReadPreference)null, CommandResultDocumentCodec.create(this.codecRegistry.get(BsonDocument.class), "firstBatch"), operationContext, effectiveWriteConcern.isAcknowledged(), bulkWriteCommand.getOpsAndNsInfo(), callback)).thenApply((bulkWriteCommandOkResponse, callback) -> {
            if (bulkWriteCommandOkResponse == null) {
                callback.complete((ExhaustiveClientBulkWriteCommandOkResponse)null);
                return;
            }
            AsyncRunnable.beginAsync().thenSupply(c -> this.doWithRetriesDisabledForCommandAsync(retryState, "getMore", c1 -> this.exhaustBulkWriteCommandOkResponseCursorAsync(connectionSource, connection, (BsonDocument)bulkWriteCommandOkResponse, operationContext, c1), c)).thenApply((cursorExhaustBatches, c) -> c.complete(ClientBulkWriteOperation.createExhaustiveClientBulkWriteCommandOkResponse(bulkWriteCommandOkResponse, cursorExhaustBatches, connection.getDescription()))).finish(callback);
        }).finish(finalCallback);
    }

    private static ExhaustiveClientBulkWriteCommandOkResponse createExhaustiveClientBulkWriteCommandOkResponse(BsonDocument bulkWriteCommandOkResponse, List<List<BsonDocument>> cursorExhaustBatches, ConnectionDescription connectionDescription) {
        ExhaustiveClientBulkWriteCommandOkResponse exhaustiveBulkWriteCommandOkResponse = new ExhaustiveClientBulkWriteCommandOkResponse(bulkWriteCommandOkResponse, cursorExhaustBatches);
        MongoWriteConcernException writeConcernException = Exceptions.createWriteConcernException(bulkWriteCommandOkResponse, connectionDescription.getServerAddress());
        if (writeConcernException != null) {
            throw new MongoWriteConcernWithResponseException(writeConcernException, exhaustiveBulkWriteCommandOkResponse);
        }
        return exhaustiveBulkWriteCommandOkResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R doWithRetriesDisabledForCommand(RetryState retryState, String commandDescription, Supplier<R> actionWithCommand) {
        Optional<Boolean> originalRetryableCommandFlag = retryState.attachment(AttachmentKeys.retryableCommandFlag());
        Supplier<String> originalCommandDescriptionSupplier = retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).orElseThrow(Assertions::fail);
        try {
            retryState.attach(AttachmentKeys.retryableCommandFlag(), false, true).attach(AttachmentKeys.commandDescriptionSupplier(), () -> commandDescription, false);
            R r = actionWithCommand.get();
            return r;
        }
        finally {
            originalRetryableCommandFlag.ifPresent(value -> retryState.attach(AttachmentKeys.retryableCommandFlag(), value, true));
            retryState.attach(AttachmentKeys.commandDescriptionSupplier(), originalCommandDescriptionSupplier, false);
        }
    }

    private <R> void doWithRetriesDisabledForCommandAsync(RetryState retryState, String commandDescription, AsyncSupplier<R> actionWithCommand, SingleResultCallback<R> finalCallback) {
        Optional<Boolean> originalRetryableCommandFlag = retryState.attachment(AttachmentKeys.retryableCommandFlag());
        Supplier<String> originalCommandDescriptionSupplier = retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).orElseThrow(Assertions::fail);
        AsyncRunnable.beginAsync().thenSupply(c -> {
            retryState.attach(AttachmentKeys.retryableCommandFlag(), false, true).attach(AttachmentKeys.commandDescriptionSupplier(), () -> commandDescription, false);
            actionWithCommand.finish(c);
        }).thenAlwaysRunAndFinish(() -> {
            originalRetryableCommandFlag.ifPresent(value -> retryState.attach(AttachmentKeys.retryableCommandFlag(), value, true));
            retryState.attach(AttachmentKeys.commandDescriptionSupplier(), originalCommandDescriptionSupplier, false);
        }, finalCallback);
    }

    private List<List<BsonDocument>> exhaustBulkWriteCommandOkResponseCursor(ConnectionSource connectionSource, OperationContext operationContext, Connection connection, BsonDocument response) {
        try (CommandBatchCursor cursor = SyncOperationHelper.cursorDocumentToBatchCursor(TimeoutMode.CURSOR_LIFETIME, response, 0, this.codecRegistry.get(BsonDocument.class), this.options.getComment().orElse(null), connectionSource, connection, operationContext);){
            List<List<BsonDocument>> list = cursor.exhaust();
            return list;
        }
    }

    private void exhaustBulkWriteCommandOkResponseCursorAsync(AsyncConnectionSource connectionSource, AsyncConnection connection, BsonDocument bulkWriteCommandOkResponse, OperationContext operationContext, SingleResultCallback<List<List<BsonDocument>>> finalCallback) {
        AsyncBatchCursor cursor = AsyncOperationHelper.cursorDocumentToAsyncBatchCursor(TimeoutMode.CURSOR_LIFETIME, bulkWriteCommandOkResponse, 0, this.codecRegistry.get(BsonDocument.class), this.options.getComment().orElse(null), connectionSource, connection, operationContext);
        AsyncRunnable.beginAsync().thenSupply(callback -> cursor.exhaust(callback)).thenAlwaysRunAndFinish(() -> cursor.close(), finalCallback);
    }

    private ClientBulkWriteCommand createBulkWriteCommand(RetryState retryState, boolean effectiveRetryWrites, WriteConcern effectiveWriteConcern, SessionContext sessionContext, List<? extends ClientNamespacedWriteModel> unexecutedModels, BatchEncoder batchEncoder, Runnable retriesEnabler) {
        BsonDocument commandDocument = new BsonDocument(BULK_WRITE_COMMAND_NAME, (BsonValue)new BsonInt32(1)).append("errorsOnly", (BsonValue)BsonBoolean.valueOf((!this.options.isVerboseResults() ? 1 : 0) != 0)).append("ordered", (BsonValue)BsonBoolean.valueOf((boolean)this.options.isOrdered()));
        this.options.isBypassDocumentValidation().ifPresent(value -> commandDocument.append("bypassDocumentValidation", (BsonValue)BsonBoolean.valueOf((boolean)value)));
        this.options.getComment().ifPresent(value -> commandDocument.append("comment", value));
        this.options.getLet().ifPresent(let -> commandDocument.append("let", (BsonValue)let.toBsonDocument(BsonDocument.class, this.codecRegistry)));
        CommandOperationHelper.commandWriteConcern(effectiveWriteConcern, sessionContext).ifPresent(value -> commandDocument.append("writeConcern", (BsonValue)value.asDocument()));
        return new ClientBulkWriteCommand(commandDocument, new ClientBulkWriteCommand.OpsAndNsInfo(effectiveRetryWrites, unexecutedModels, batchEncoder, this.options, () -> {
            retriesEnabler.run();
            return retryState.isFirstAttempt() ? sessionContext.advanceTransactionNumber() : sessionContext.getTransactionNumber();
        }));
    }

    private WriteConcern validateAndGetEffectiveWriteConcern(SessionContext sessionContext) {
        WriteConcern effectiveWriteConcern = CommandOperationHelper.validateAndGetEffectiveWriteConcern(this.writeConcernSetting, sessionContext);
        if (!effectiveWriteConcern.isAcknowledged()) {
            if (this.options.isVerboseResults()) {
                throw new MongoClientException("Cannot request unacknowledged write concern and verbose results");
            }
            if (this.options.isOrdered()) {
                throw new MongoClientException("Cannot request unacknowledged write concern and ordered writes");
            }
        }
        return effectiveWriteConcern;
    }

    private <T> void encodeUsingRegistry(BsonWriter writer, T value) {
        this.encodeUsingRegistry(writer, value, DEFAULT_ENCODER_CONTEXT);
    }

    private <T> void encodeUsingRegistry(BsonWriter writer, T value, EncoderContext encoderContext) {
        Codec encoder = this.codecRegistry.get(value.getClass());
        encoder.encode(writer, value, encoderContext);
    }

    private static AbstractClientNamespacedWriteModel getNamespacedModel(List<? extends ClientNamespacedWriteModel> models, int index) {
        return (AbstractClientNamespacedWriteModel)((Object)models.get(index));
    }

    private final class ResultAccumulator {
        @Nullable
        private ServerAddress serverAddress = null;
        private final ArrayList<BatchResult> batchResults = new ArrayList();

        ResultAccumulator() {
        }

        ClientBulkWriteResult build(@Nullable MongoException topLevelError, WriteConcern effectiveWriteConcern) throws MongoException {
            boolean verboseResultsSetting = ClientBulkWriteOperation.this.options.isVerboseResults();
            boolean batchResultsHaveResponses = false;
            boolean batchResultsHaveInfoAboutSuccessfulIndividualOperations = false;
            long insertedCount = 0L;
            long upsertedCount = 0L;
            long matchedCount = 0L;
            long modifiedCount = 0L;
            long deletedCount = 0L;
            HashMap<Integer, ClientInsertOneResult> insertResults = verboseResultsSetting ? new HashMap<Integer, ClientInsertOneResult>() : Collections.emptyMap();
            HashMap<Integer, ClientUpdateResult> updateResults = verboseResultsSetting ? new HashMap<Integer, ClientUpdateResult>() : Collections.emptyMap();
            HashMap<Integer, ClientDeleteResult> deleteResults = verboseResultsSetting ? new HashMap<Integer, ClientDeleteResult>() : Collections.emptyMap();
            ArrayList<WriteConcernError> writeConcernErrors = new ArrayList<WriteConcernError>();
            HashMap<Integer, WriteError> writeErrors = new HashMap<Integer, WriteError>();
            for (BatchResult batchResult : this.batchResults) {
                if (!batchResult.hasResponse()) continue;
                batchResultsHaveResponses = true;
                MongoWriteConcernException writeConcernException = batchResult.getWriteConcernException();
                if (writeConcernException != null) {
                    writeConcernErrors.add(writeConcernException.getWriteConcernError());
                }
                int batchStartModelIndex = batchResult.getBatchStartModelIndex();
                ExhaustiveClientBulkWriteCommandOkResponse response = batchResult.getResponse();
                boolean orderedSetting = ClientBulkWriteOperation.this.options.isOrdered();
                int nErrors = response.getNErrors();
                batchResultsHaveInfoAboutSuccessfulIndividualOperations = batchResultsHaveInfoAboutSuccessfulIndividualOperations || orderedSetting && nErrors == 0 || !orderedSetting && nErrors < batchResult.getBatchModelsCount();
                insertedCount += (long)response.getNInserted();
                upsertedCount += (long)response.getNUpserted();
                matchedCount += (long)response.getNMatched();
                modifiedCount += (long)response.getNModified();
                deletedCount += (long)response.getNDeleted();
                Map<Integer, BsonValue> insertModelDocumentIds = batchResult.getInsertModelDocumentIds();
                for (BsonDocument individualOperationResponse : response.getCursorExhaust()) {
                    boolean individualOperationSuccessful;
                    boolean bl = individualOperationSuccessful = individualOperationResponse.getNumber((Object)"ok").intValue() == 1;
                    if (individualOperationSuccessful && !verboseResultsSetting) continue;
                    int individualOperationIndexInBatch = individualOperationResponse.getInt32((Object)"idx").getValue();
                    int writeModelIndex = batchStartModelIndex + individualOperationIndexInBatch;
                    if (individualOperationSuccessful) {
                        this.collectSuccessfulIndividualOperationResult(individualOperationResponse, writeModelIndex, individualOperationIndexInBatch, insertModelDocumentIds, insertResults, updateResults, deleteResults);
                        continue;
                    }
                    batchResultsHaveInfoAboutSuccessfulIndividualOperations = batchResultsHaveInfoAboutSuccessfulIndividualOperations || orderedSetting && individualOperationIndexInBatch > 0;
                    WriteError individualOperationWriteError = new WriteError(individualOperationResponse.getInt32((Object)"code").getValue(), individualOperationResponse.getString((Object)"errmsg").getValue(), individualOperationResponse.getDocument((Object)"errInfo", new BsonDocument()));
                    writeErrors.put(writeModelIndex, individualOperationWriteError);
                }
            }
            if (topLevelError == null && writeConcernErrors.isEmpty() && writeErrors.isEmpty()) {
                if (effectiveWriteConcern.isAcknowledged()) {
                    AcknowledgedSummaryClientBulkWriteResult summaryResult = new AcknowledgedSummaryClientBulkWriteResult(insertedCount, upsertedCount, matchedCount, modifiedCount, deletedCount);
                    return verboseResultsSetting ? new AcknowledgedVerboseClientBulkWriteResult(summaryResult, insertResults, updateResults, deleteResults) : summaryResult;
                }
                return UnacknowledgedClientBulkWriteResult.INSTANCE;
            }
            if (batchResultsHaveResponses) {
                AcknowledgedSummaryClientBulkWriteResult partialSummaryResult = batchResultsHaveInfoAboutSuccessfulIndividualOperations ? new AcknowledgedSummaryClientBulkWriteResult(insertedCount, upsertedCount, matchedCount, modifiedCount, deletedCount) : null;
                throw new ClientBulkWriteException(topLevelError, writeConcernErrors, writeErrors, verboseResultsSetting && partialSummaryResult != null ? new AcknowledgedVerboseClientBulkWriteResult(partialSummaryResult, insertResults, updateResults, deleteResults) : partialSummaryResult, Assertions.assertNotNull(this.serverAddress));
            }
            throw Assertions.assertNotNull(topLevelError);
        }

        private void collectSuccessfulIndividualOperationResult(BsonDocument individualOperationResponse, int writeModelIndex, int individualOperationIndexInBatch, Map<Integer, BsonValue> insertModelDocumentIds, Map<Integer, ClientInsertOneResult> insertResults, Map<Integer, ClientUpdateResult> updateResults, Map<Integer, ClientDeleteResult> deleteResults) {
            AbstractClientNamespacedWriteModel writeModel = ClientBulkWriteOperation.getNamespacedModel(ClientBulkWriteOperation.this.models, writeModelIndex);
            if (writeModel instanceof ConcreteClientNamespacedInsertOneModel) {
                insertResults.put(writeModelIndex, new ConcreteClientInsertOneResult(insertModelDocumentIds.get(individualOperationIndexInBatch)));
            } else if (writeModel instanceof ConcreteClientNamespacedUpdateOneModel || writeModel instanceof ConcreteClientNamespacedUpdateManyModel || writeModel instanceof ConcreteClientNamespacedReplaceOneModel) {
                BsonDocument upsertedIdDocument = individualOperationResponse.getDocument((Object)"upserted", null);
                updateResults.put(writeModelIndex, new ConcreteClientUpdateResult(individualOperationResponse.getInt32((Object)"n").getValue(), individualOperationResponse.getInt32((Object)"nModified", new BsonInt32(0)).getValue(), upsertedIdDocument == null ? null : upsertedIdDocument.get((Object)"_id")));
            } else if (writeModel instanceof ConcreteClientNamespacedDeleteOneModel || writeModel instanceof ConcreteClientNamespacedDeleteManyModel) {
                deleteResults.put(writeModelIndex, new ConcreteClientDeleteResult(individualOperationResponse.getInt32((Object)"n").getValue()));
            } else {
                Assertions.fail(writeModel.getClass().toString());
            }
        }

        void onNewServerAddress(ServerAddress serverAddress) {
            this.serverAddress = serverAddress;
        }

        @Nullable
        Integer onBulkWriteCommandOkResponseOrNoResponse(int batchStartModelIndex, @Nullable ExhaustiveClientBulkWriteCommandOkResponse response, BatchEncoder.EncodedBatchInfo encodedBatchInfo) {
            return this.onBulkWriteCommandOkResponseOrNoResponse(batchStartModelIndex, response, null, encodedBatchInfo);
        }

        @Nullable
        Integer onBulkWriteCommandOkResponseWithWriteConcernError(int batchStartModelIndex, MongoWriteConcernWithResponseException exception, BatchEncoder.EncodedBatchInfo encodedBatchInfo) {
            MongoWriteConcernException writeConcernException = (MongoWriteConcernException)exception.getCause();
            this.onNewServerAddress(writeConcernException.getServerAddress());
            ExhaustiveClientBulkWriteCommandOkResponse response = (ExhaustiveClientBulkWriteCommandOkResponse)exception.getResponse();
            return this.onBulkWriteCommandOkResponseOrNoResponse(batchStartModelIndex, response, writeConcernException, encodedBatchInfo);
        }

        @Nullable
        private Integer onBulkWriteCommandOkResponseOrNoResponse(int batchStartModelIndex, @Nullable ExhaustiveClientBulkWriteCommandOkResponse response, @Nullable MongoWriteConcernException writeConcernException, BatchEncoder.EncodedBatchInfo encodedBatchInfo) {
            BatchResult batchResult = response == null ? BatchResult.noResponse(batchStartModelIndex, encodedBatchInfo) : BatchResult.okResponse(batchStartModelIndex, encodedBatchInfo, response, writeConcernException);
            this.batchResults.add(batchResult);
            int potentialNextBatchStartModelIndex = batchStartModelIndex + batchResult.getBatchModelsCount();
            return response == null || response.operationMayContinue(ClientBulkWriteOperation.this.options) ? (potentialNextBatchStartModelIndex == ClientBulkWriteOperation.this.models.size() ? null : Integer.valueOf(potentialNextBatchStartModelIndex)) : null;
        }

        void onBulkWriteCommandErrorResponse(MongoCommandException exception) {
            this.onNewServerAddress(exception.getServerAddress());
        }

        void onBulkWriteCommandErrorWithoutResponse(MongoException exception) {
            Exceptions.serverAddressFromException(exception).ifPresent(this::onNewServerAddress);
        }
    }

    public final class BatchEncoder {
        private EncodedBatchInfo encodedBatchInfo = new EncodedBatchInfo();

        EncodedBatchInfo intoEncodedBatchInfo() {
            EncodedBatchInfo result = Assertions.assertNotNull(this.encodedBatchInfo);
            this.encodedBatchInfo = null;
            Assertions.assertTrue(result.getModelsCount() > 0);
            return result;
        }

        void reset() {
            Assertions.assertNotNull(this.encodedBatchInfo).modelsCount = 0;
        }

        void reset(int modelIndexInBatch) {
            Assertions.assertNotNull(this.encodedBatchInfo).modelsCount -= 1;
            this.encodedBatchInfo.insertModelDocumentIds.remove(modelIndexInBatch);
        }

        void encodeWriteModel(BsonBinaryWriter writer, ClientWriteModel model, int modelIndexInBatch, int namespaceIndexInBatch) {
            Assertions.assertNotNull(this.encodedBatchInfo).modelsCount++;
            writer.writeStartDocument();
            if (model instanceof ConcreteClientInsertOneModel) {
                writer.writeInt32("insert", namespaceIndexInBatch);
                this.encodeWriteModelInternals(writer, (ConcreteClientInsertOneModel)model, modelIndexInBatch);
            } else if (model instanceof ConcreteClientUpdateOneModel) {
                writer.writeInt32("update", namespaceIndexInBatch);
                writer.writeBoolean("multi", false);
                this.encodeWriteModelInternals((BsonWriter)writer, (ConcreteClientUpdateOneModel)model);
            } else if (model instanceof ConcreteClientUpdateManyModel) {
                writer.writeInt32("update", namespaceIndexInBatch);
                writer.writeBoolean("multi", true);
                this.encodeWriteModelInternals((BsonWriter)writer, (ConcreteClientUpdateManyModel)model);
            } else if (model instanceof ConcreteClientReplaceOneModel) {
                writer.writeInt32("update", namespaceIndexInBatch);
                this.encodeWriteModelInternals(writer, (ConcreteClientReplaceOneModel)model);
            } else if (model instanceof ConcreteClientDeleteOneModel) {
                writer.writeInt32("delete", namespaceIndexInBatch);
                writer.writeBoolean("multi", false);
                this.encodeWriteModelInternals((BsonWriter)writer, (ConcreteClientDeleteOneModel)model);
            } else if (model instanceof ConcreteClientDeleteManyModel) {
                writer.writeInt32("delete", namespaceIndexInBatch);
                writer.writeBoolean("multi", true);
                this.encodeWriteModelInternals((BsonWriter)writer, (ConcreteClientDeleteManyModel)model);
            } else {
                throw Assertions.fail(model.getClass().toString());
            }
            writer.writeEndDocument();
        }

        private void encodeWriteModelInternals(BsonBinaryWriter writer, ConcreteClientInsertOneModel model, int modelIndexInBatch) {
            writer.writeName("document");
            Object document = model.getDocument();
            Assertions.assertNotNull(this.encodedBatchInfo).insertModelDocumentIds.compute(modelIndexInBatch, (k, knownModelDocumentId) -> {
                IdHoldingBsonWriter documentIdHoldingBsonWriter = new IdHoldingBsonWriter((BsonWriter)writer, knownModelDocumentId instanceof BsonObjectId ? knownModelDocumentId.asObjectId() : null);
                ClientBulkWriteOperation.this.encodeUsingRegistry(documentIdHoldingBsonWriter, document, COLLECTIBLE_DOCUMENT_ENCODER_CONTEXT);
                return documentIdHoldingBsonWriter.getId();
            });
        }

        private void encodeWriteModelInternals(BsonWriter writer, ConcreteClientUpdateOneModel model) {
            this.encodeWriteModelInternals(writer, (AbstractClientUpdateModel<?>)model);
            ((ConcreteClientUpdateOneOptions)model.getOptions()).getSort().ifPresent(value -> {
                writer.writeName("sort");
                ClientBulkWriteOperation.this.encodeUsingRegistry(writer, value);
            });
        }

        private void encodeWriteModelInternals(BsonWriter writer, AbstractClientUpdateModel<?> model) {
            writer.writeName("filter");
            ClientBulkWriteOperation.this.encodeUsingRegistry(writer, model.getFilter());
            model.getUpdate().ifPresent(value -> {
                writer.writeName("updateMods");
                ClientBulkWriteOperation.this.encodeUsingRegistry(writer, value);
            });
            model.getUpdatePipeline().ifPresent(value -> {
                writer.writeStartArray("updateMods");
                value.forEach(pipelineStage -> ClientBulkWriteOperation.this.encodeUsingRegistry(writer, pipelineStage));
                writer.writeEndArray();
            });
            Object options = model.getOptions();
            ((AbstractClientUpdateOptions)options).getArrayFilters().ifPresent(value -> {
                writer.writeStartArray("arrayFilters");
                value.forEach(filter -> ClientBulkWriteOperation.this.encodeUsingRegistry(writer, filter));
                writer.writeEndArray();
            });
            ((AbstractClientUpdateOptions)options).getCollation().ifPresent(value -> {
                writer.writeName("collation");
                ClientBulkWriteOperation.this.encodeUsingRegistry(writer, value.asDocument());
            });
            ((AbstractClientUpdateOptions)options).getHint().ifPresent(hint -> {
                writer.writeName("hint");
                ClientBulkWriteOperation.this.encodeUsingRegistry(writer, hint);
            });
            ((AbstractClientUpdateOptions)options).getHintString().ifPresent(value -> writer.writeString("hint", value));
            ((AbstractClientUpdateOptions)options).isUpsert().ifPresent(value -> writer.writeBoolean("upsert", value.booleanValue()));
        }

        private void encodeWriteModelInternals(BsonBinaryWriter writer, ConcreteClientReplaceOneModel model) {
            writer.writeBoolean("multi", false);
            writer.writeName("filter");
            ClientBulkWriteOperation.this.encodeUsingRegistry((BsonWriter)writer, model.getFilter());
            writer.writeName("updateMods");
            ClientBulkWriteOperation.this.encodeUsingRegistry((BsonWriter)writer, model.getReplacement(), COLLECTIBLE_DOCUMENT_ENCODER_CONTEXT);
            ConcreteClientReplaceOneOptions options = model.getOptions();
            options.getCollation().ifPresent(value -> {
                writer.writeName("collation");
                ClientBulkWriteOperation.this.encodeUsingRegistry((BsonWriter)writer, value.asDocument());
            });
            options.getHint().ifPresent(value -> {
                writer.writeName("hint");
                ClientBulkWriteOperation.this.encodeUsingRegistry((BsonWriter)writer, value);
            });
            options.getHintString().ifPresent(value -> writer.writeString("hint", value));
            options.isUpsert().ifPresent(value -> writer.writeBoolean("upsert", value.booleanValue()));
            options.getSort().ifPresent(value -> {
                writer.writeName("sort");
                ClientBulkWriteOperation.this.encodeUsingRegistry((BsonWriter)writer, value);
            });
        }

        private void encodeWriteModelInternals(BsonWriter writer, AbstractClientDeleteModel<?> model) {
            writer.writeName("filter");
            ClientBulkWriteOperation.this.encodeUsingRegistry(writer, model.getFilter());
            Object options = model.getOptions();
            ((AbstractClientDeleteOptions)options).getCollation().ifPresent(value -> {
                writer.writeName("collation");
                ClientBulkWriteOperation.this.encodeUsingRegistry(writer, value.asDocument());
            });
            ((AbstractClientDeleteOptions)options).getHint().ifPresent(value -> {
                writer.writeName("hint");
                ClientBulkWriteOperation.this.encodeUsingRegistry(writer, value);
            });
            ((AbstractClientDeleteOptions)options).getHintString().ifPresent(value -> writer.writeString("hint", value));
        }

        final class EncodedBatchInfo {
            private final HashMap<Integer, BsonValue> insertModelDocumentIds = new HashMap();
            private int modelsCount = 0;

            private EncodedBatchInfo() {
            }

            Map<Integer, BsonValue> getInsertModelDocumentIds() {
                return this.insertModelDocumentIds;
            }

            int getModelsCount() {
                return this.modelsCount;
            }
        }
    }

    private static final class ExhaustiveClientBulkWriteCommandOkResponse {
        private final int nErrors;
        private final int nInserted;
        private final int nUpserted;
        private final int nMatched;
        private final int nModified;
        private final int nDeleted;
        private final List<BsonDocument> cursorExhaust;

        ExhaustiveClientBulkWriteCommandOkResponse(BsonDocument bulkWriteCommandOkResponse, List<List<BsonDocument>> cursorExhaustBatches) {
            this.nErrors = bulkWriteCommandOkResponse.getInt32((Object)"nErrors").getValue();
            this.nInserted = bulkWriteCommandOkResponse.getInt32((Object)"nInserted").getValue();
            this.nUpserted = bulkWriteCommandOkResponse.getInt32((Object)"nUpserted").getValue();
            this.nMatched = bulkWriteCommandOkResponse.getInt32((Object)"nMatched").getValue();
            this.nModified = bulkWriteCommandOkResponse.getInt32((Object)"nModified").getValue();
            this.nDeleted = bulkWriteCommandOkResponse.getInt32((Object)"nDeleted").getValue();
            this.cursorExhaust = cursorExhaustBatches.isEmpty() ? Collections.emptyList() : (cursorExhaustBatches.size() == 1 ? cursorExhaustBatches.get(0) : cursorExhaustBatches.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }

        boolean operationMayContinue(ConcreteClientBulkWriteOptions options) {
            return this.nErrors == 0 || !options.isOrdered();
        }

        int getNErrors() {
            return this.nErrors;
        }

        int getNInserted() {
            return this.nInserted;
        }

        int getNUpserted() {
            return this.nUpserted;
        }

        int getNMatched() {
            return this.nMatched;
        }

        int getNModified() {
            return this.nModified;
        }

        int getNDeleted() {
            return this.nDeleted;
        }

        List<BsonDocument> getCursorExhaust() {
            return this.cursorExhaust;
        }
    }

    public static final class ClientBulkWriteCommand {
        private final BsonDocument commandDocument;
        private final OpsAndNsInfo opsAndNsInfo;

        ClientBulkWriteCommand(BsonDocument commandDocument, OpsAndNsInfo opsAndNsInfo) {
            this.commandDocument = commandDocument;
            this.opsAndNsInfo = opsAndNsInfo;
        }

        BsonDocument getCommandDocument() {
            return this.commandDocument;
        }

        OpsAndNsInfo getOpsAndNsInfo() {
            return this.opsAndNsInfo;
        }

        public static final class OpsAndNsInfo
        extends DualMessageSequences {
            private final boolean effectiveRetryWrites;
            private final List<? extends ClientNamespacedWriteModel> models;
            private final BatchEncoder batchEncoder;
            private final ConcreteClientBulkWriteOptions options;
            private final Supplier<Long> doIfCommandIsRetryableAndAdvanceGetTxnNumber;

            public OpsAndNsInfo(boolean effectiveRetryWrites, List<? extends ClientNamespacedWriteModel> models, BatchEncoder batchEncoder, ConcreteClientBulkWriteOptions options, Supplier<Long> doIfCommandIsRetryableAndAdvanceGetTxnNumber) {
                super("ops", new OpsFieldNameValidator(models), "nsInfo", NoOpFieldNameValidator.INSTANCE);
                this.effectiveRetryWrites = effectiveRetryWrites;
                this.models = models;
                this.batchEncoder = batchEncoder;
                this.options = options;
                this.doIfCommandIsRetryableAndAdvanceGetTxnNumber = doIfCommandIsRetryableAndAdvanceGetTxnNumber;
            }

            @Override
            public DualMessageSequences.EncodeDocumentsResult encodeDocuments(DualMessageSequences.WritersProviderAndLimitsChecker writersProviderAndLimitsChecker) {
                this.batchEncoder.reset();
                LinkedHashMap<MongoNamespace, Integer> indexedNamespaces = new LinkedHashMap<MongoNamespace, Integer>();
                DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult writeResult = DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.OK_LIMIT_NOT_REACHED;
                boolean commandIsRetryable = this.effectiveRetryWrites;
                int maxModelIndexInBatch = -1;
                for (int modelIndexInBatch = 0; modelIndexInBatch < this.models.size() && writeResult == DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.OK_LIMIT_NOT_REACHED; ++modelIndexInBatch) {
                    boolean writeNewNamespace;
                    int indexedNamespacesSizeBeforeCompute;
                    MongoNamespace namespace;
                    int namespaceIndexInBatch;
                    int finalModelIndexInBatch;
                    AbstractClientNamespacedWriteModel namespacedModel = ClientBulkWriteOperation.getNamespacedModel(this.models, modelIndexInBatch);
                    writeResult = writersProviderAndLimitsChecker.tryWrite((arg_0, arg_1) -> this.lambda$encodeDocuments$1(namespacedModel, finalModelIndexInBatch = modelIndexInBatch, namespaceIndexInBatch = indexedNamespaces.computeIfAbsent(namespace = namespacedModel.getNamespace(), arg_0 -> OpsAndNsInfo.lambda$encodeDocuments$0(indexedNamespacesSizeBeforeCompute = indexedNamespaces.size(), arg_0)).intValue(), writeNewNamespace = indexedNamespaces.size() != indexedNamespacesSizeBeforeCompute, namespace, arg_0, arg_1));
                    if (writeResult == DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.FAIL_LIMIT_EXCEEDED) {
                        this.batchEncoder.reset(finalModelIndexInBatch);
                        continue;
                    }
                    maxModelIndexInBatch = finalModelIndexInBatch;
                    if (!commandIsRetryable || !OpsAndNsInfo.doesNotSupportRetries(namespacedModel)) continue;
                    commandIsRetryable = false;
                    BulkWriteBatch.logWriteModelDoesNotSupportRetries();
                }
                return new DualMessageSequences.EncodeDocumentsResult(this.options.isOrdered() && maxModelIndexInBatch < this.models.size() - 1, commandIsRetryable ? Collections.singletonList(new BsonElement("txnNumber", (BsonValue)new BsonInt64(this.doIfCommandIsRetryableAndAdvanceGetTxnNumber.get().longValue()))) : Collections.emptyList());
            }

            private static boolean doesNotSupportRetries(AbstractClientNamespacedWriteModel model) {
                return model instanceof ConcreteClientNamespacedUpdateManyModel || model instanceof ConcreteClientNamespacedDeleteManyModel;
            }

            private /* synthetic */ int lambda$encodeDocuments$1(AbstractClientNamespacedWriteModel namespacedModel, int finalModelIndexInBatch, int namespaceIndexInBatch, boolean writeNewNamespace, MongoNamespace namespace, BsonBinaryWriter opsWriter, BsonBinaryWriter nsInfoWriter) {
                this.batchEncoder.encodeWriteModel(opsWriter, namespacedModel.getModel(), finalModelIndexInBatch, namespaceIndexInBatch);
                if (writeNewNamespace) {
                    nsInfoWriter.writeStartDocument();
                    nsInfoWriter.writeString("ns", namespace.getFullName());
                    nsInfoWriter.writeEndDocument();
                }
                return finalModelIndexInBatch + 1;
            }

            private static /* synthetic */ Integer lambda$encodeDocuments$0(int indexedNamespacesSizeBeforeCompute, MongoNamespace k) {
                return indexedNamespacesSizeBeforeCompute;
            }

            private static final class OpsFieldNameValidator
            implements FieldNameValidator {
                private static final Set<String> OPERATION_DISCRIMINATOR_FIELD_NAMES = Stream.of("insert", "update", "delete").collect(Collectors.toSet());
                private final List<? extends ClientNamespacedWriteModel> models;
                private final ReplacingUpdateModsFieldValidator replacingValidator;
                private final UpdatingUpdateModsFieldValidator updatingValidator;
                private int currentIndividualOperationIndex;

                OpsFieldNameValidator(List<? extends ClientNamespacedWriteModel> models) {
                    this.models = models;
                    this.replacingValidator = new ReplacingUpdateModsFieldValidator();
                    this.updatingValidator = new UpdatingUpdateModsFieldValidator();
                    this.currentIndividualOperationIndex = -1;
                }

                public boolean validate(String fieldName) {
                    if (OPERATION_DISCRIMINATOR_FIELD_NAMES.contains(fieldName)) {
                        ++this.currentIndividualOperationIndex;
                    }
                    return true;
                }

                public FieldNameValidator getValidatorForField(String fieldName) {
                    if (fieldName.equals("updateMods")) {
                        return this.currentIndividualOperationIsReplace() ? this.replacingValidator.reset() : this.updatingValidator.reset();
                    }
                    return NoOpFieldNameValidator.INSTANCE;
                }

                private boolean currentIndividualOperationIsReplace() {
                    return ClientBulkWriteOperation.getNamespacedModel(this.models, this.currentIndividualOperationIndex) instanceof ConcreteClientNamespacedReplaceOneModel;
                }

                private static final class ReplacingUpdateModsFieldValidator
                implements FieldNameValidator {
                    private boolean firstFieldSinceLastReset = true;

                    ReplacingUpdateModsFieldValidator() {
                    }

                    public boolean validate(String fieldName) {
                        if (this.firstFieldSinceLastReset) {
                            this.firstFieldSinceLastReset = false;
                            return ReplacingDocumentFieldNameValidator.INSTANCE.validate(fieldName);
                        }
                        return true;
                    }

                    public String getValidationErrorMessage(String fieldName) {
                        return ReplacingDocumentFieldNameValidator.INSTANCE.getValidationErrorMessage(fieldName);
                    }

                    public FieldNameValidator getValidatorForField(String fieldName) {
                        return NoOpFieldNameValidator.INSTANCE;
                    }

                    ReplacingUpdateModsFieldValidator reset() {
                        this.firstFieldSinceLastReset = true;
                        return this;
                    }
                }

                private static final class UpdatingUpdateModsFieldValidator
                implements FieldNameValidator {
                    private final UpdateFieldNameValidator delegate = new UpdateFieldNameValidator();
                    private boolean firstFieldSinceLastReset = true;

                    UpdatingUpdateModsFieldValidator() {
                    }

                    public boolean validate(String fieldName) {
                        if (this.firstFieldSinceLastReset) {
                            this.firstFieldSinceLastReset = false;
                            return this.delegate.validate(fieldName);
                        }
                        return true;
                    }

                    public String getValidationErrorMessage(String fieldName) {
                        return this.delegate.getValidationErrorMessage(fieldName);
                    }

                    public FieldNameValidator getValidatorForField(String fieldName) {
                        return NoOpFieldNameValidator.INSTANCE;
                    }

                    public void start() {
                        this.delegate.start();
                    }

                    public void end() {
                        this.delegate.end();
                    }

                    UpdatingUpdateModsFieldValidator reset() {
                        this.delegate.reset();
                        this.firstFieldSinceLastReset = true;
                        return this;
                    }
                }
            }
        }
    }

    public static final class Exceptions {
        public static Optional<ServerAddress> serverAddressFromException(@Nullable MongoException exception) {
            ServerAddress serverAddress = null;
            if (exception instanceof MongoServerException) {
                serverAddress = ((MongoServerException)exception).getServerAddress();
            } else if (exception instanceof MongoSocketException) {
                serverAddress = ((MongoSocketException)exception).getServerAddress();
            }
            return Optional.ofNullable(serverAddress);
        }

        @Nullable
        private static MongoWriteConcernException createWriteConcernException(BsonDocument response, ServerAddress serverAddress) {
            String writeConcernErrorFieldName = "writeConcernError";
            if (!response.containsKey((Object)"writeConcernError")) {
                return null;
            }
            BsonDocument writeConcernErrorDocument = response.getDocument((Object)"writeConcernError");
            WriteConcernError writeConcernError = WriteConcernHelper.createWriteConcernError(writeConcernErrorDocument);
            Set<String> errorLabels = response.getArray((Object)"errorLabels", new BsonArray()).stream().map(i -> i.asString().getValue()).collect(Collectors.toSet());
            return new MongoWriteConcernException(writeConcernError, null, serverAddress, errorLabels);
        }
    }

    static final class BatchResult {
        private final int batchStartModelIndex;
        private final BatchEncoder.EncodedBatchInfo encodedBatchInfo;
        @Nullable
        private final ExhaustiveClientBulkWriteCommandOkResponse response;
        @Nullable
        private final MongoWriteConcernException writeConcernException;

        static BatchResult okResponse(int batchStartModelIndex, BatchEncoder.EncodedBatchInfo encodedBatchInfo, ExhaustiveClientBulkWriteCommandOkResponse response, @Nullable MongoWriteConcernException writeConcernException) {
            return new BatchResult(batchStartModelIndex, encodedBatchInfo, Assertions.assertNotNull(response), writeConcernException);
        }

        static BatchResult noResponse(int batchStartModelIndex, BatchEncoder.EncodedBatchInfo encodedBatchInfo) {
            return new BatchResult(batchStartModelIndex, encodedBatchInfo, null, null);
        }

        private BatchResult(int batchStartModelIndex, BatchEncoder.EncodedBatchInfo encodedBatchInfo, @Nullable ExhaustiveClientBulkWriteCommandOkResponse response, @Nullable MongoWriteConcernException writeConcernException) {
            this.batchStartModelIndex = batchStartModelIndex;
            this.encodedBatchInfo = encodedBatchInfo;
            this.response = response;
            this.writeConcernException = writeConcernException;
        }

        int getBatchStartModelIndex() {
            return this.batchStartModelIndex;
        }

        int getBatchModelsCount() {
            return this.encodedBatchInfo.getModelsCount();
        }

        boolean hasResponse() {
            return this.response != null;
        }

        ExhaustiveClientBulkWriteCommandOkResponse getResponse() {
            return Assertions.assertNotNull(this.response);
        }

        @Nullable
        MongoWriteConcernException getWriteConcernException() {
            Assertions.assertTrue(this.hasResponse());
            return this.writeConcernException;
        }

        Map<Integer, BsonValue> getInsertModelDocumentIds() {
            Assertions.assertTrue(this.hasResponse());
            return this.encodedBatchInfo.getInsertModelDocumentIds();
        }
    }
}

