/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncCursor;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

public class AsyncCommandBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private final TimeoutMode timeoutMode;
    private OperationContext operationContext;
    private AsyncCursor<T> wrapped;

    AsyncCommandBatchCursor(TimeoutMode timeoutMode, long maxTimeMs, OperationContext operationContext, AsyncCursor<T> wrapped) {
        this.operationContext = operationContext.withOverride(timeoutContext -> timeoutContext.withMaxTimeOverride(maxTimeMs));
        this.timeoutMode = timeoutMode;
        this.wrapped = wrapped;
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        this.resetTimeout();
        this.wrapped.next(this.operationContext, callback);
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.wrapped.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    @Override
    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    @Override
    public void close() {
        this.wrapped.close(this.operationContext.withOverride(timeoutContext -> timeoutContext.withNewlyStartedTimeout().withDefaultMaxTime()));
    }

    @Override
    @Nullable
    public BsonDocument getPostBatchResumeToken() {
        return this.wrapped.getPostBatchResumeToken();
    }

    @Override
    @Nullable
    public BsonTimestamp getOperationTime() {
        return this.wrapped.getOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.wrapped.isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.wrapped.getMaxWireVersion();
    }

    private void resetTimeout() {
        if (this.timeoutMode == TimeoutMode.ITERATION) {
            this.operationContext = this.operationContext.withNewlyStartedTimeout();
        }
    }

    AsyncCursor<T> getWrapped() {
        return this.wrapped;
    }
}

