/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncCursor;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.ChangeStreamBatchCursor;
import com.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import com.mongodb.internal.operation.ChangeStreamOperation;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.RawBsonDocument;

final class AsyncChangeStreamBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private final AsyncReadBinding binding;
    private final OperationContext initialOperationContext;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private volatile BsonDocument resumeToken;
    private final AtomicReference<AsyncCursor<RawBsonDocument>> wrapped;
    private final AtomicBoolean isClosed;

    AsyncChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, AsyncCursor<RawBsonDocument> wrapped, AsyncReadBinding binding, OperationContext operationContext, @Nullable BsonDocument resumeToken, int maxWireVersion) {
        this.changeStreamOperation = changeStreamOperation;
        this.wrapped = new AtomicReference<AsyncCursor<RawBsonDocument>>(Assertions.assertNotNull(wrapped));
        this.binding = binding;
        binding.retain();
        this.initialOperationContext = operationContext.withOverride(TimeoutContext::withMaxTimeAsMaxAwaitTimeOverride);
        this.resumeToken = resumeToken;
        this.maxWireVersion = maxWireVersion;
        this.isClosed = new AtomicBoolean();
    }

    @NonNull
    AsyncCursor<RawBsonDocument> getWrapped() {
        return Assertions.assertNotNull(this.wrapped.get());
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        this.resumeableOperation(AsyncCursor::next, callback, this.initialOperationContext.withNewlyStartedTimeout(), false);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.nullifyAndCloseWrapped(this.initialOperationContext.withNewlyStartedTimeout());
            }
            finally {
                this.binding.release();
            }
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.getWrapped().setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.getWrapped().getBatchSize();
    }

    @Override
    public boolean isClosed() {
        if (this.isClosed.get()) {
            return true;
        }
        if (this.wrappedClosedItself()) {
            this.close();
            return true;
        }
        return false;
    }

    private boolean wrappedClosedItself() {
        AsyncCursor<RawBsonDocument> observedWrapped = this.wrapped.get();
        return observedWrapped != null && observedWrapped.isClosed();
    }

    private void nullifyAndCloseWrapped(OperationContext operationContext) {
        AsyncCursor observedWrapped = this.wrapped.getAndSet(null);
        if (observedWrapped != null) {
            observedWrapped.close(operationContext);
        }
    }

    private void setWrappedOrCloseIt(AsyncCursor<RawBsonDocument> newValue, OperationContext operationContext) {
        if (this.isClosed()) {
            Assertions.assertNull(this.wrapped.get());
            newValue.close(operationContext);
        } else {
            Assertions.assertNull(this.wrapped.getAndSet(newValue));
            if (this.isClosed()) {
                this.nullifyAndCloseWrapped(operationContext);
            }
        }
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.getWrapped().getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.getWrapped().isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(AsyncCursor<RawBsonDocument> cursor) {
        BsonDocument resumeToken = cursor.getPostBatchResumeToken();
        if (resumeToken != null) {
            this.resumeToken = resumeToken;
        }
    }

    private void resumeableOperation(AsyncBlock asyncBlock, SingleResultCallback<List<T>> callback, OperationContext operationContext, boolean tryNext) {
        SingleResultCallback<List<Object>> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        if (this.isClosed()) {
            errHandlingCallback.onResult(null, new MongoException(String.format("%s called after the cursor was closed.", tryNext ? "tryNext()" : "next()")));
            return;
        }
        AsyncCursor<RawBsonDocument> wrappedCursor = this.getWrapped();
        asyncBlock.apply(wrappedCursor, operationContext, (result, t) -> {
            if (t == null) {
                try {
                    List<T> convertedResults;
                    try {
                        convertedResults = ChangeStreamBatchCursor.convertAndProduceLastId(Assertions.assertNotNull(result), this.changeStreamOperation.getDecoder(), lastId -> {
                            this.resumeToken = lastId;
                        });
                    }
                    finally {
                        this.cachePostBatchResumeToken(wrappedCursor);
                    }
                    errHandlingCallback.onResult(convertedResults, null);
                }
                catch (Exception e) {
                    errHandlingCallback.onResult(null, e);
                }
            } else {
                this.cachePostBatchResumeToken(wrappedCursor);
                if (ChangeStreamBatchCursorHelper.isResumableError(t, this.maxWireVersion)) {
                    this.nullifyAndCloseWrapped(operationContext);
                    this.retryOperation(asyncBlock, errHandlingCallback, operationContext, tryNext);
                } else {
                    errHandlingCallback.onResult(null, t);
                }
            }
        });
    }

    private void retryOperation(AsyncBlock asyncBlock, SingleResultCallback<List<T>> callback, OperationContext operationContext, boolean tryNext) {
        AsyncOperationHelper.withAsyncReadConnectionSource(this.binding, operationContext, (source, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                this.changeStreamOperation.setChangeStreamOptionsForResume(this.resumeToken, Assertions.assertNotNull(source).getServerDescription().getMaxWireVersion());
                this.changeStreamOperation.executeAsync((AsyncReadBinding)new AsyncSourceAwareReadBinding(source, this.binding), operationContext, (asyncBatchCursor, t1) -> {
                    if (t1 != null) {
                        callback.onResult(null, t1);
                    } else {
                        try {
                            this.setWrappedOrCloseIt(Assertions.assertNotNull((AsyncChangeStreamBatchCursor)asyncBatchCursor).getWrapped(), operationContext);
                        }
                        finally {
                            try {
                                source.release();
                                this.binding.release();
                            }
                            finally {
                                this.resumeableOperation(asyncBlock, callback, operationContext, tryNext);
                            }
                        }
                    }
                });
            }
        });
    }

    private static interface AsyncBlock {
        public void apply(AsyncCursor<RawBsonDocument> var1, OperationContext var2, SingleResultCallback<List<RawBsonDocument>> var3);
    }

    private static class AsyncSourceAwareReadBinding
    implements AsyncReadBinding {
        private final AsyncConnectionSource source;
        private final AsyncReadBinding binding;

        AsyncSourceAwareReadBinding(AsyncConnectionSource source, AsyncReadBinding binding) {
            this.source = source;
            this.binding = binding;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.binding.getReadPreference();
        }

        @Override
        public void getReadConnectionSource(OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
            this.source.retain();
            callback.onResult(this.source, null);
        }

        @Override
        public void getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
            throw Assertions.fail();
        }

        @Override
        public AsyncReadBinding retain() {
            return this.binding.retain();
        }

        @Override
        public int release() {
            return this.binding.release();
        }

        @Override
        public int getCount() {
            return this.binding.getCount();
        }
    }
}

