/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.observability.micrometer;

import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.UnixServerAddress;
import com.mongodb.connection.ConnectionId;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.observability.micrometer.MicrometerTracer;
import com.mongodb.internal.observability.micrometer.MongodbObservation;
import com.mongodb.internal.observability.micrometer.Span;
import com.mongodb.internal.observability.micrometer.TraceContext;
import com.mongodb.internal.observability.micrometer.Tracer;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import com.mongodb.observability.ObservabilitySettings;
import com.mongodb.observability.micrometer.MicrometerObservabilitySettings;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.ObservationRegistry;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.bson.BsonDocument;

public class TracingManager {
    public static final TracingManager NO_OP = new TracingManager(null);
    private final Tracer tracer;
    private final boolean enableCommandPayload;
    public static final String ENV_OBSERVABILITY_ENABLED = "OBSERVABILITY_MONGODB_ENABLED";
    public static final String ENV_OBSERVABILITY_QUERY_TEXT_MAX_LENGTH = "OBSERVABILITY_MONGODB_QUERY_TEXT_MAX_LENGTH";

    public TracingManager(@Nullable ObservabilitySettings observabilitySettings) {
        if (observabilitySettings == null) {
            this.tracer = Tracer.NO_OP;
            this.enableCommandPayload = false;
        } else {
            if (!(observabilitySettings instanceof MicrometerObservabilitySettings)) {
                throw new IllegalArgumentException("Only Micrometer based observability is currently supported");
            }
            MicrometerObservabilitySettings settings = (MicrometerObservabilitySettings)observabilitySettings;
            String envOtelInstrumentationEnabled = System.getenv(ENV_OBSERVABILITY_ENABLED);
            boolean enableTracing = true;
            if (envOtelInstrumentationEnabled != null) {
                enableTracing = Boolean.parseBoolean(envOtelInstrumentationEnabled);
            }
            ObservationRegistry observationRegistry = settings.getObservationRegistry();
            this.tracer = enableTracing && observationRegistry != null ? new MicrometerTracer(observationRegistry, settings.isEnableCommandPayloadTracing(), settings.getMaxQueryTextLength()) : Tracer.NO_OP;
            this.enableCommandPayload = this.tracer.includeCommandPayload();
        }
    }

    public Span addSpan(String name, @Nullable TraceContext parentContext) {
        return this.tracer.nextSpan(name, parentContext, null);
    }

    public Span addSpan(String name, @Nullable TraceContext parentContext, MongoNamespace namespace) {
        return this.tracer.nextSpan(name, parentContext, namespace);
    }

    public Span addTransactionSpan() {
        Span span = this.tracer.nextSpan("transaction", null, null);
        span.tagLowCardinality(MongodbObservation.LowCardinalityKeyNames.SYSTEM.withValue("mongodb"));
        return span;
    }

    public boolean isEnabled() {
        return this.tracer.isEnabled();
    }

    public boolean isCommandPayloadEnabled() {
        return this.enableCommandPayload;
    }

    @Nullable
    public Span createTracingSpan(CommandMessage message, OperationContext operationContext, Supplier<BsonDocument> commandDocumentSupplier, Predicate<String> isSensitiveCommand, Supplier<ServerAddress> serverAddressSupplier, Supplier<ConnectionId> connectionIdSupplier) {
        String namespace;
        if (!this.isEnabled()) {
            return null;
        }
        BsonDocument command = commandDocumentSupplier.get();
        String commandName = command.getFirstKey();
        if (isSensitiveCommand.test(commandName)) {
            return null;
        }
        Span operationSpan = operationContext.getTracingSpan();
        Span span = this.addSpan(commandName, operationSpan != null ? operationSpan.context() : null);
        if (command.containsKey((Object)"getMore")) {
            long cursorId = command.getInt64((Object)"getMore").longValue();
            span.tagLowCardinality(MongodbObservation.LowCardinalityKeyNames.CURSOR_ID.withValue(String.valueOf(cursorId)));
            if (operationSpan != null) {
                operationSpan.tagLowCardinality(MongodbObservation.LowCardinalityKeyNames.CURSOR_ID.withValue(String.valueOf(cursorId)));
            }
        }
        String collection = "";
        if (operationSpan != null) {
            MongoNamespace parentNamespace = operationSpan.getNamespace();
            if (parentNamespace != null) {
                namespace = parentNamespace.getDatabaseName();
                collection = "$cmd".equalsIgnoreCase(parentNamespace.getCollectionName()) ? "" : parentNamespace.getCollectionName();
            } else {
                namespace = message.getDatabase();
            }
        } else {
            namespace = message.getDatabase();
        }
        String summary = commandName + " " + namespace + (collection.isEmpty() ? "" : "." + collection);
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{MongodbObservation.LowCardinalityKeyNames.SYSTEM.withValue("mongodb"), MongodbObservation.LowCardinalityKeyNames.NAMESPACE.withValue(namespace), MongodbObservation.LowCardinalityKeyNames.QUERY_SUMMARY.withValue(summary), MongodbObservation.LowCardinalityKeyNames.COMMAND_NAME.withValue(commandName)});
        if (!collection.isEmpty()) {
            keyValues = keyValues.and(new KeyValue[]{MongodbObservation.LowCardinalityKeyNames.COLLECTION.withValue(collection)});
        }
        span.tagLowCardinality(keyValues);
        ServerAddress serverAddress = serverAddressSupplier.get();
        ConnectionId connectionId = connectionIdSupplier.get();
        span.tagLowCardinality(KeyValues.of((KeyValue[])new KeyValue[]{MongodbObservation.LowCardinalityKeyNames.SERVER_ADDRESS.withValue(serverAddress.getHost()), MongodbObservation.LowCardinalityKeyNames.SERVER_PORT.withValue(String.valueOf(serverAddress.getPort())), MongodbObservation.LowCardinalityKeyNames.CLIENT_CONNECTION_ID.withValue(String.valueOf(connectionId.getLocalValue())), MongodbObservation.LowCardinalityKeyNames.SERVER_CONNECTION_ID.withValue(String.valueOf(connectionId.getServerValue())), MongodbObservation.LowCardinalityKeyNames.NETWORK_TRANSPORT.withValue(serverAddress instanceof UnixServerAddress ? "unix" : "tcp")}));
        SessionContext sessionContext = operationContext.getSessionContext();
        if (sessionContext.hasSession() && !sessionContext.isImplicitSession()) {
            span.tagLowCardinality(KeyValues.of((KeyValue[])new KeyValue[]{MongodbObservation.LowCardinalityKeyNames.TRANSACTION_NUMBER.withValue(String.valueOf(sessionContext.getTransactionNumber())), MongodbObservation.LowCardinalityKeyNames.SESSION_ID.withValue(String.valueOf(sessionContext.getSessionId().get((Object)sessionContext.getSessionId().getFirstKey()).asBinary().asUuid()))}));
        }
        return span;
    }
}

