/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.observability.micrometer;

import com.mongodb.MongoNamespace;
import com.mongodb.internal.observability.micrometer.MongodbObservation;
import com.mongodb.internal.observability.micrometer.Span;
import com.mongodb.internal.observability.micrometer.TraceContext;
import com.mongodb.internal.observability.micrometer.Tracer;
import com.mongodb.lang.Nullable;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.transport.Kind;
import io.micrometer.observation.transport.SenderContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

public class MicrometerTracer
implements Tracer {
    private final ObservationRegistry observationRegistry;
    private final boolean allowCommandPayload;
    private final int textMaxLength;
    private static final String QUERY_TEXT_LENGTH_CONTEXT_KEY = "QUERY_TEXT_MAX_LENGTH";

    public MicrometerTracer(ObservationRegistry observationRegistry) {
        this(observationRegistry, false, 0);
    }

    public MicrometerTracer(ObservationRegistry observationRegistry, boolean allowCommandPayload, int textMaxLength) {
        this.allowCommandPayload = allowCommandPayload;
        this.observationRegistry = observationRegistry;
        this.textMaxLength = Optional.ofNullable(System.getenv("OBSERVABILITY_MONGODB_QUERY_TEXT_MAX_LENGTH")).map(Integer::parseInt).orElse(textMaxLength);
    }

    @Override
    public Span nextSpan(String name, @Nullable TraceContext parent, @Nullable MongoNamespace namespace) {
        Observation parentObservation;
        Observation observation = this.getObservation(name);
        if (parent instanceof MicrometerTraceContext && (parentObservation = ((MicrometerTraceContext)parent).observation) != null) {
            observation.parentObservation(parentObservation);
        }
        return new MicrometerSpan(observation.start(), namespace);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean includeCommandPayload() {
        return this.allowCommandPayload;
    }

    private Observation getObservation(String name) {
        Observation observation = MongodbObservation.MONGODB_OBSERVATION.observation(this.observationRegistry, () -> new SenderContext((carrier, key, value) -> {}, Kind.CLIENT)).contextualName(name);
        observation.getContext().put((Object)QUERY_TEXT_LENGTH_CONTEXT_KEY, (Object)this.textMaxLength);
        return observation;
    }

    private static class MicrometerTraceContext
    implements TraceContext {
        private final Observation observation;

        MicrometerTraceContext(@Nullable Observation observation) {
            this.observation = observation;
        }
    }

    private static class MicrometerSpan
    implements Span {
        private final Observation observation;
        @Nullable
        private final MongoNamespace namespace;
        private final int queryTextLength;

        MicrometerSpan(Observation observation, @Nullable MongoNamespace namespace) {
            this.namespace = namespace;
            this.observation = observation;
            this.queryTextLength = Optional.ofNullable(observation.getContext().get((Object)MicrometerTracer.QUERY_TEXT_LENGTH_CONTEXT_KEY)).filter(Integer.class::isInstance).map(Integer.class::cast).orElse(Integer.MAX_VALUE);
        }

        @Override
        public void tagLowCardinality(KeyValue keyValue) {
            this.observation.lowCardinalityKeyValue(keyValue);
        }

        @Override
        public void tagLowCardinality(KeyValues keyValues) {
            this.observation.lowCardinalityKeyValues(keyValues);
        }

        @Override
        public void tagHighCardinality(String keyName, BsonDocument value) {
            this.observation.highCardinalityKeyValue(keyName, this.queryTextLength < Integer.MAX_VALUE ? this.getTruncatedBsonDocument(value) : value.toString());
        }

        @Override
        public void event(String event) {
            this.observation.event(() -> event);
        }

        @Override
        public void error(Throwable throwable) {
            this.observation.lowCardinalityKeyValues(KeyValues.of((KeyValue[])new KeyValue[]{MongodbObservation.LowCardinalityKeyNames.EXCEPTION_MESSAGE.withValue(throwable.getMessage()), MongodbObservation.LowCardinalityKeyNames.EXCEPTION_TYPE.withValue(throwable.getClass().getName()), MongodbObservation.LowCardinalityKeyNames.EXCEPTION_STACKTRACE.withValue(this.getStackTraceAsString(throwable))}));
            this.observation.error(throwable);
        }

        @Override
        public void end() {
            this.observation.stop();
        }

        @Override
        public TraceContext context() {
            return new MicrometerTraceContext(this.observation);
        }

        @Override
        @Nullable
        public MongoNamespace getNamespace() {
            return this.namespace;
        }

        private String getStackTraceAsString(Throwable throwable) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            return sw.toString();
        }

        private String getTruncatedBsonDocument(BsonDocument commandDocument) {
            StringWriter writer = new StringWriter();
            try (BsonReader bsonReader = commandDocument.asBsonReader();){
                JsonWriter jsonWriter = new JsonWriter((Writer)writer, JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).maxLength(this.queryTextLength).build());
                jsonWriter.pipe(bsonReader);
                if (jsonWriter.isTruncated()) {
                    writer.append(" ...");
                }
                String string = writer.toString();
                return string;
            }
        }
    }
}

