/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoDriverInformation;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.client.DriverInformation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ConcreteMongoDriverInformation
extends MongoDriverInformation {
    public static final DriverInformation INITIAL_DRIVER_INFORMATION = new DriverInformation("mongo-java-driver", "5.7.0-beta0", String.format("Java/%s/%s", System.getProperty("java.vendor", "unknown-vendor"), System.getProperty("java.runtime.version", "unknown-version")));
    private final List<DriverInformation> driverInformationList;

    public ConcreteMongoDriverInformation(List<DriverInformation> driverInformation) {
        this.driverInformationList = Assertions.notNull("driverInformation", driverInformation);
    }

    @Override
    public List<String> getDriverNames() {
        return this.getDriverField(DriverInformation::getDriverName);
    }

    @Override
    public List<String> getDriverVersions() {
        return this.getDriverField(DriverInformation::getDriverVersion);
    }

    @Override
    public List<String> getDriverPlatforms() {
        return this.getDriverField(DriverInformation::getDriverPlatform);
    }

    public List<DriverInformation> getDriverInformationList() {
        return this.driverInformationList;
    }

    private List<String> getDriverField(Function<DriverInformation, String> fieldSupplier) {
        return Collections.unmodifiableList(this.driverInformationList.stream().map(fieldSupplier).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

