/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.binding;

import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.Server;
import com.mongodb.internal.connection.ServerTuple;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.selector.ReadPreferenceWithFallbackServerSelector;
import com.mongodb.internal.selector.ServerAddressSelector;
import com.mongodb.internal.selector.WritableServerSelector;

public class ClusterBinding
extends AbstractReferenceCounted
implements ClusterAwareReadWriteBinding {
    private final Cluster cluster;
    private final ReadPreference readPreference;

    public ClusterBinding(Cluster cluster, ReadPreference readPreference) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
    }

    @Override
    public ReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public ConnectionSource getReadConnectionSource(OperationContext operationContext) {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new ReadPreferenceServerSelector(this.readPreference), operationContext), this.readPreference);
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, OperationContext operationContext) {
        if (this.cluster.getSettings().getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            return this.getReadConnectionSource(operationContext);
        }
        ReadPreferenceWithFallbackServerSelector readPreferenceWithFallbackServerSelector = new ReadPreferenceWithFallbackServerSelector(this.readPreference, minWireVersion, fallbackReadPreference);
        ServerTuple serverTuple = this.cluster.selectServer(readPreferenceWithFallbackServerSelector, operationContext);
        return new ClusterBindingConnectionSource(serverTuple, readPreferenceWithFallbackServerSelector.getAppliedReadPreference());
    }

    @Override
    public ConnectionSource getWriteConnectionSource(OperationContext operationContext) {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new WritableServerSelector(), operationContext), this.readPreference);
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress, OperationContext operationContext) {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new ServerAddressSelector(serverAddress), operationContext), this.readPreference);
    }

    private final class ClusterBindingConnectionSource
    extends AbstractReferenceCounted
    implements ConnectionSource {
        private final Server server;
        private final ServerDescription serverDescription;
        private final ReadPreference appliedReadPreference;

        private ClusterBindingConnectionSource(ServerTuple serverTuple, ReadPreference appliedReadPreference) {
            this.server = serverTuple.getServer();
            this.serverDescription = serverTuple.getServerDescription();
            this.appliedReadPreference = appliedReadPreference;
            ClusterBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.appliedReadPreference;
        }

        @Override
        public Connection getConnection(OperationContext operationContext) {
            return this.server.getConnection(operationContext.withConnectionEstablishmentSessionContext());
        }

        @Override
        public ConnectionSource retain() {
            super.retain();
            ClusterBinding.this.retain();
            return this;
        }

        @Override
        public int release() {
            int count = super.release();
            ClusterBinding.this.release();
            return count;
        }
    }
}

