/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal;

import com.mongodb.MongoClientException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.time.StartTime;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import com.mongodb.session.ClientSession;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;

public class TimeoutContext {
    private static final int NO_ROUND_TRIP_TIME_MS = 0;
    private final TimeoutSettings timeoutSettings;
    @Nullable
    private final Timeout timeout;
    @Nullable
    private final MaxTimeSupplier maxTimeSupplier;
    private final boolean isMaintenanceContext;
    private final long minRoundTripTimeMS;

    public static MongoOperationTimeoutException createMongoRoundTripTimeoutException() {
        return TimeoutContext.createMongoTimeoutException("Remaining timeoutMS is less than or equal to the server's minimum round trip time.");
    }

    public static MongoOperationTimeoutException createMongoTimeoutException(String message) {
        return new MongoOperationTimeoutException(message);
    }

    public static <T> T throwMongoTimeoutException(String message) {
        throw new MongoOperationTimeoutException(message);
    }

    public static <T> T throwMongoTimeoutException() {
        throw new MongoOperationTimeoutException("The operation exceeded the timeout limit.");
    }

    public static MongoOperationTimeoutException createMongoTimeoutException(Throwable cause) {
        return TimeoutContext.createMongoTimeoutException("Operation exceeded the timeout limit: " + cause.getMessage(), cause);
    }

    public static MongoOperationTimeoutException createMongoTimeoutException(String message, @Nullable Throwable cause) {
        if (cause instanceof MongoOperationTimeoutException) {
            return (MongoOperationTimeoutException)cause;
        }
        return new MongoOperationTimeoutException(message, cause);
    }

    public static TimeoutContext createMaintenanceTimeoutContext(TimeoutSettings timeoutSettings) {
        return new TimeoutContext(true, timeoutSettings, TimeoutContext.startTimeout(timeoutSettings.getTimeoutMS()));
    }

    public static TimeoutContext createTimeoutContext(ClientSession session, TimeoutSettings timeoutSettings) {
        TimeoutContext sessionTimeoutContext = session.getTimeoutContext();
        if (sessionTimeoutContext != null) {
            TimeoutSettings sessionTimeoutSettings = sessionTimeoutContext.timeoutSettings;
            if (timeoutSettings.getGenerationId() > sessionTimeoutSettings.getGenerationId()) {
                throw new MongoClientException("Cannot change the timeoutMS during a transaction.");
            }
            if (sessionTimeoutSettings.getTimeoutMS() == null) {
                if (timeoutSettings.getMaxTimeMS() != 0L) {
                    sessionTimeoutSettings = sessionTimeoutSettings.withMaxTimeMS(timeoutSettings.getMaxTimeMS());
                }
                if (timeoutSettings.getMaxAwaitTimeMS() != 0L) {
                    sessionTimeoutSettings = sessionTimeoutSettings.withMaxAwaitTimeMS(timeoutSettings.getMaxAwaitTimeMS());
                }
                if (timeoutSettings.getMaxCommitTimeMS() != null) {
                    sessionTimeoutSettings = sessionTimeoutSettings.withMaxCommitMS(timeoutSettings.getMaxCommitTimeMS());
                }
                return new TimeoutContext(sessionTimeoutSettings);
            }
            return sessionTimeoutContext;
        }
        return new TimeoutContext(timeoutSettings);
    }

    public TimeoutContext(TimeoutSettings timeoutSettings) {
        this(false, timeoutSettings, TimeoutContext.startTimeout(timeoutSettings.getTimeoutMS()));
    }

    private TimeoutContext(TimeoutSettings timeoutSettings, @Nullable Timeout timeout) {
        this(false, timeoutSettings, timeout);
    }

    private TimeoutContext(boolean isMaintenanceContext, TimeoutSettings timeoutSettings, @Nullable Timeout timeout) {
        this(isMaintenanceContext, 0L, timeoutSettings, null, timeout);
    }

    private TimeoutContext(boolean isMaintenanceContext, long minRoundTripTimeMS, TimeoutSettings timeoutSettings, @Nullable MaxTimeSupplier maxTimeSupplier) {
        this(isMaintenanceContext, minRoundTripTimeMS, timeoutSettings, maxTimeSupplier, TimeoutContext.startTimeout(timeoutSettings.getTimeoutMS()));
    }

    private TimeoutContext(boolean isMaintenanceContext, long minRoundTripTimeMS, TimeoutSettings timeoutSettings, @Nullable MaxTimeSupplier maxTimeSupplier, @Nullable Timeout timeout) {
        this.isMaintenanceContext = isMaintenanceContext;
        this.timeoutSettings = timeoutSettings;
        this.minRoundTripTimeMS = minRoundTripTimeMS;
        this.maxTimeSupplier = maxTimeSupplier;
        this.timeout = timeout;
    }

    public boolean hasTimeoutMS() {
        return this.timeoutSettings.getTimeoutMS() != null;
    }

    public void onExpired(Runnable onExpired) {
        Timeout.nullAsInfinite(this.timeout).onExpired(onExpired);
    }

    @Nullable
    public Timeout timeoutIncludingRoundTrip() {
        return this.timeout == null ? null : this.timeout.shortenBy(this.minRoundTripTimeMS, TimeUnit.MILLISECONDS);
    }

    public long timeoutOrAlternative(long alternativeTimeoutMS) {
        if (this.timeout == null) {
            return alternativeTimeoutMS;
        }
        return this.timeout.call(TimeUnit.MILLISECONDS, () -> 0L, ms -> ms, () -> (Long)TimeoutContext.throwMongoTimeoutException("The operation exceeded the timeout limit."));
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    @Nullable
    public Timeout getTimeout() {
        return this.timeout;
    }

    public long getMaxAwaitTimeMS() {
        return this.timeoutSettings.getMaxAwaitTimeMS();
    }

    public long getMaxCommitTimeMS() {
        Long maxCommitTimeMS = this.timeoutSettings.getMaxCommitTimeMS();
        return this.timeoutOrAlternative(maxCommitTimeMS != null ? maxCommitTimeMS : 0L);
    }

    public long getReadTimeoutMS() {
        return this.timeoutOrAlternative(this.timeoutSettings.getReadTimeoutMS());
    }

    public long getWriteTimeoutMS() {
        return this.timeoutOrAlternative(0L);
    }

    public int getConnectTimeoutMs() {
        long connectTimeoutMS = this.getTimeoutSettings().getConnectTimeoutMS();
        if (this.isMaintenanceContext) {
            return (int)connectTimeoutMS;
        }
        return Math.toIntExact(Timeout.nullAsInfinite(this.timeout).call(TimeUnit.MILLISECONDS, () -> connectTimeoutMS, ms -> connectTimeoutMS == 0L ? ms : Math.min(ms, connectTimeoutMS), () -> (Long)TimeoutContext.throwMongoTimeoutException("The operation exceeded the timeout limit.")));
    }

    public TimeoutContext withMaxTimeAsMaxAwaitTimeOverride() {
        return new TimeoutContext(this.isMaintenanceContext, this.minRoundTripTimeMS, this.timeoutSettings, this.timeoutSettings::getMaxAwaitTimeMS, this.timeout);
    }

    public TimeoutContext withMaxTimeOverride(long maxTimeMS) {
        return new TimeoutContext(this.isMaintenanceContext, this.minRoundTripTimeMS, this.timeoutSettings, () -> maxTimeMS, this.timeout);
    }

    public TimeoutContext withDefaultMaxTime() {
        return new TimeoutContext(this.isMaintenanceContext, this.minRoundTripTimeMS, this.timeoutSettings, null, this.timeout);
    }

    public TimeoutContext withDisabledMaxTime() {
        return new TimeoutContext(this.isMaintenanceContext, this.minRoundTripTimeMS, this.timeoutSettings, () -> 0L, this.timeout);
    }

    public TimeoutContext withMaxTimeAsMaxCommitTime() {
        return new TimeoutContext(this.isMaintenanceContext, this.minRoundTripTimeMS, this.timeoutSettings, () -> this.getMaxCommitTimeMS(), this.timeout);
    }

    public TimeoutContext withMinRoundTripTime(long minRoundTripTimeMS) {
        return new TimeoutContext(this.isMaintenanceContext, minRoundTripTimeMS, this.timeoutSettings, this.maxTimeSupplier, this.timeout);
    }

    public TimeoutContext withNewlyStartedMaintenanceTimeout() {
        if (!this.isMaintenanceContext) {
            return this;
        }
        return new TimeoutContext(true, this.minRoundTripTimeMS, this.timeoutSettings, this.maxTimeSupplier);
    }

    public TimeoutContext withComputedServerSelectionTimeout() {
        if (this.hasTimeoutMS()) {
            Timeout serverSelectionTimeout = StartTime.now().timeoutAfterOrInfiniteIfNegative(this.getTimeoutSettings().getServerSelectionTimeoutMS(), TimeUnit.MILLISECONDS);
            if (this.isMaintenanceContext) {
                return new TimeoutContext(false, this.timeoutSettings, serverSelectionTimeout);
            }
            return new TimeoutContext(false, this.timeoutSettings, Timeout.earliest(serverSelectionTimeout, this.timeout));
        }
        return this;
    }

    public TimeoutContext withMinRoundTripTimeMS(long minRoundTripTimeMS) {
        Assertions.isTrue("'minRoundTripTimeMS' must be a positive number", minRoundTripTimeMS >= 0L);
        return new TimeoutContext(this.isMaintenanceContext, minRoundTripTimeMS, this.timeoutSettings, this.maxTimeSupplier, this.timeout);
    }

    public TimeoutContext withNewlyStartedTimeout() {
        return new TimeoutContext(this.isMaintenanceContext, this.minRoundTripTimeMS, this.timeoutSettings, this.maxTimeSupplier);
    }

    public TimeoutContext withAdditionalReadTimeout(int additionalReadTimeout) {
        Assertions.assertNull(this.timeout);
        if (this.timeoutSettings.getReadTimeoutMS() == 0L) {
            return this;
        }
        long newReadTimeout = this.getReadTimeoutMS() + (long)additionalReadTimeout;
        return new TimeoutContext(this.timeoutSettings.withReadTimeoutMS(newReadTimeout > 0L ? newReadTimeout : Long.MAX_VALUE));
    }

    public TimeoutContext copyTimeoutContext() {
        return new TimeoutContext(this.getTimeoutSettings(), this.getTimeout());
    }

    public String toString() {
        return "TimeoutContext{isMaintenanceContext=" + this.isMaintenanceContext + ", timeoutSettings=" + this.timeoutSettings + ", timeout=" + this.timeout + ", minRoundTripTimeMS=" + this.minRoundTripTimeMS + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeoutContext that = (TimeoutContext)o;
        return this.isMaintenanceContext == that.isMaintenanceContext && this.minRoundTripTimeMS == that.minRoundTripTimeMS && Objects.equals(this.timeoutSettings, that.timeoutSettings) && Objects.equals(this.timeout, that.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.isMaintenanceContext, this.timeoutSettings, this.timeout, this.minRoundTripTimeMS);
    }

    @Nullable
    public static Timeout startTimeout(@Nullable Long timeoutMS) {
        if (timeoutMS != null) {
            return Timeout.expiresIn(timeoutMS, TimeUnit.MILLISECONDS, Timeout.ZeroSemantics.ZERO_DURATION_MEANS_INFINITE);
        }
        return null;
    }

    public Timeout computeServerSelectionTimeout() {
        if (this.hasTimeoutMS()) {
            return Assertions.assertNotNull(this.timeout);
        }
        return StartTime.now().timeoutAfterOrInfiniteIfNegative(this.getTimeoutSettings().getServerSelectionTimeoutMS(), TimeUnit.MILLISECONDS);
    }

    public Timeout startMaxWaitTimeout(StartTime checkoutStart) {
        if (this.hasTimeoutMS()) {
            return Assertions.assertNotNull(this.timeout);
        }
        long ms = this.getTimeoutSettings().getMaxWaitTimeMS();
        return checkoutStart.timeoutAfterOrInfiniteIfNegative(ms, TimeUnit.MILLISECONDS);
    }

    public void runMaxTimeMS(LongConsumer onRemaining) {
        if (this.maxTimeSupplier != null) {
            long maxTimeMS = this.maxTimeSupplier.get();
            if (maxTimeMS > 0L) {
                this.runMinTimeout(onRemaining, maxTimeMS);
            }
            return;
        }
        if (this.timeout == null) {
            TimeoutContext.runWithFixedTimeout(this.timeoutSettings.getMaxTimeMS(), onRemaining);
            return;
        }
        Assertions.assertNotNull(this.timeoutIncludingRoundTrip()).run(TimeUnit.MILLISECONDS, () -> {}, onRemaining, () -> {
            throw TimeoutContext.createMongoRoundTripTimeoutException();
        });
    }

    private void runMinTimeout(LongConsumer onRemaining, long fixedMs) {
        Timeout timeout = this.timeoutIncludingRoundTrip();
        if (timeout != null) {
            timeout.run(TimeUnit.MILLISECONDS, () -> onRemaining.accept(fixedMs), renamingMs -> onRemaining.accept(Math.min(renamingMs, fixedMs)), () -> TimeoutContext.throwMongoTimeoutException("The operation exceeded the timeout limit."));
        } else {
            onRemaining.accept(fixedMs);
        }
    }

    private static void runWithFixedTimeout(long ms, LongConsumer onRemaining) {
        if (ms != 0L) {
            onRemaining.accept(ms);
        }
    }

    public static interface MaxTimeSupplier {
        public long get();
    }
}

