/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.TextVectorSearchQuery;
import com.mongodb.internal.client.model.search.AbstractVectorSearchQuery;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;

final class TextVectorSearchQueryImpl
extends AbstractVectorSearchQuery
implements TextVectorSearchQuery {
    private final String text;
    @Nullable
    private final String model;

    TextVectorSearchQueryImpl(String text, @Nullable String model) {
        this.text = Assertions.notNull("text", text);
        this.model = model;
    }

    @Override
    public TextVectorSearchQuery model(String modelName) {
        return new TextVectorSearchQueryImpl(this.text, Assertions.notNull("modelName", modelName));
    }

    @Override
    @Nullable
    public String getModel() {
        return this.model;
    }

    public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
        return new Document("text", (Object)this.text).toBsonDocument(documentClass, codecRegistry);
    }

    public String toString() {
        return "TextVectorSearchQuery{text='" + this.text + '\'' + ", model=" + (this.model != null ? "'" + this.model + '\'' : "null") + '}';
    }
}

