/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.client.DriverInformation;
import com.mongodb.internal.connection.ConcreteMongoDriverInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Sealed
public abstract class MongoDriverInformation {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoDriverInformation mongoDriverInformation) {
        return new Builder((ConcreteMongoDriverInformation)mongoDriverInformation);
    }

    public abstract List<String> getDriverNames();

    public abstract List<String> getDriverVersions();

    public abstract List<String> getDriverPlatforms();

    @NotThreadSafe
    public static final class Builder {
        private final ConcreteMongoDriverInformation mongoDriverInformation;
        private String driverName;
        private String driverVersion;
        private String driverPlatform;

        public Builder driverName(String driverName) {
            this.driverName = Assertions.notNull("driverName", driverName);
            return this;
        }

        public Builder driverVersion(String driverVersion) {
            this.driverVersion = Assertions.notNull("driverVersion", driverVersion);
            return this;
        }

        public Builder driverPlatform(String driverPlatform) {
            this.driverPlatform = Assertions.notNull("driverPlatform", driverPlatform);
            return this;
        }

        public MongoDriverInformation build() {
            DriverInformation driverInformation = new DriverInformation(this.driverName, this.driverVersion, this.driverPlatform);
            if (this.mongoDriverInformation.getDriverInformationList().contains(driverInformation)) {
                return this.mongoDriverInformation;
            }
            ArrayList<DriverInformation> driverInformationList = new ArrayList<DriverInformation>(this.mongoDriverInformation.getDriverInformationList());
            driverInformationList.add(driverInformation);
            return new ConcreteMongoDriverInformation(Collections.unmodifiableList(driverInformationList));
        }

        private Builder() {
            this.mongoDriverInformation = new ConcreteMongoDriverInformation(Collections.emptyList());
        }

        private Builder(ConcreteMongoDriverInformation driverInformation) {
            this.mongoDriverInformation = Assertions.notNull("driverInformation", driverInformation);
        }
    }
}

