/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.observability.micrometer;

import com.mongodb.MongoConfigurationException;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import com.mongodb.observability.ObservabilitySettings;
import io.micrometer.observation.ObservationRegistry;
import java.util.Objects;

@Immutable
@Alpha(value={Reason.CLIENT})
public final class MicrometerObservabilitySettings
extends ObservabilitySettings {
    private static final boolean OBSERVATION_REGISTRY_AVAILABLE;
    @Nullable
    private final ObservationRegistry observationRegistry;
    private final int maxQueryTextLength;
    private final boolean enableCommandPayloadTracing;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MicrometerObservabilitySettings settings) {
        return new Builder(settings);
    }

    @Nullable
    public ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    public boolean isEnableCommandPayloadTracing() {
        return this.enableCommandPayloadTracing;
    }

    public int getMaxQueryTextLength() {
        return this.maxQueryTextLength;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MicrometerObservabilitySettings that = (MicrometerObservabilitySettings)o;
        return this.enableCommandPayloadTracing == that.enableCommandPayloadTracing && Objects.equals(this.observationRegistry, that.observationRegistry);
    }

    public int hashCode() {
        return Objects.hash(this.observationRegistry, this.enableCommandPayloadTracing);
    }

    private MicrometerObservabilitySettings(@Nullable ObservationRegistry observationRegistry, boolean enableCommandPayloadTracing, int maxQueryTextLength) {
        this.observationRegistry = observationRegistry;
        this.enableCommandPayloadTracing = enableCommandPayloadTracing;
        this.maxQueryTextLength = maxQueryTextLength;
    }

    static {
        boolean isAvailable = false;
        try {
            Class.forName("io.micrometer.observation.ObservationRegistry");
            isAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        OBSERVATION_REGISTRY_AVAILABLE = isAvailable;
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private ObservationRegistry observationRegistry;
        private boolean enableCommandPayloadTracing;
        private int maxQueryTextLength = Integer.MAX_VALUE;

        private Builder() {
            if (!OBSERVATION_REGISTRY_AVAILABLE) {
                throw new MongoConfigurationException("The 'io.micrometer.observation' dependency is required for MicrometerObservabilitySettings.");
            }
        }

        private Builder(MicrometerObservabilitySettings settings) {
            this.observationRegistry = settings.observationRegistry;
            this.enableCommandPayloadTracing = settings.enableCommandPayloadTracing;
            this.maxQueryTextLength = settings.maxQueryTextLength;
        }

        public Builder applySettings(MicrometerObservabilitySettings settings) {
            Assertions.notNull("settings", settings);
            this.observationRegistry = settings.observationRegistry;
            this.enableCommandPayloadTracing = settings.enableCommandPayloadTracing;
            this.maxQueryTextLength = settings.maxQueryTextLength;
            return this;
        }

        @Alpha(value={Reason.CLIENT})
        public Builder observationRegistry(@Nullable ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        @Alpha(value={Reason.CLIENT})
        public Builder enableCommandPayloadTracing(boolean enableCommandPayload) {
            this.enableCommandPayloadTracing = enableCommandPayload;
            return this;
        }

        @Alpha(value={Reason.CLIENT})
        public Builder maxQueryTextLength(int maxQueryTextLength) {
            this.maxQueryTextLength = maxQueryTextLength;
            return this;
        }

        public MicrometerObservabilitySettings build() {
            return new MicrometerObservabilitySettings(this.observationRegistry, this.enableCommandPayloadTracing, this.maxQueryTextLength);
        }
    }
}

