/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.Function;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;

public abstract class TransactionOperation
implements WriteOperation<Void> {
    private final WriteConcern writeConcern;

    TransactionOperation(WriteConcern writeConcern) {
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(WriteBinding binding, OperationContext operationContext) {
        Assertions.isTrue("in transaction", operationContext.getSessionContext().hasActiveTransaction());
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        return SyncOperationHelper.executeRetryableWrite(binding, operationContext, "admin", null, NoOpFieldNameValidator.INSTANCE, new BsonDocumentCodec(), this.getCommandCreator(), SyncOperationHelper.writeConcernErrorTransformer(timeoutContext), this.getRetryCommandModifier(timeoutContext));
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, OperationContext operationContext, SingleResultCallback<Void> callback) {
        Assertions.isTrue("in transaction", operationContext.getSessionContext().hasActiveTransaction());
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        AsyncOperationHelper.executeRetryableWriteAsync(binding, operationContext, "admin", null, NoOpFieldNameValidator.INSTANCE, new BsonDocumentCodec(), this.getCommandCreator(), AsyncOperationHelper.writeConcernErrorTransformerAsync(timeoutContext), this.getRetryCommandModifier(timeoutContext), ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = new BsonDocument(this.getCommandName(), (BsonValue)new BsonInt32(1));
            if (!this.writeConcern.isServerDefault()) {
                command.put("writeConcern", (BsonValue)this.writeConcern.asDocument());
            }
            return command;
        };
    }

    protected abstract Function<BsonDocument, BsonDocument> getRetryCommandModifier(TimeoutContext var1);
}

