/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.ExplainCommandOperation;
import com.mongodb.internal.operation.ExplainHelper;
import com.mongodb.internal.operation.MapReduceAsyncBatchCursor;
import com.mongodb.internal.operation.MapReduceBatchCursor;
import com.mongodb.internal.operation.MapReduceHelper;
import com.mongodb.internal.operation.MapReduceInlineResultsAsyncCursor;
import com.mongodb.internal.operation.MapReduceInlineResultsCursor;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperationMapReduceCursor;
import com.mongodb.internal.operation.ReadOperationSimple;
import com.mongodb.internal.operation.SingleBatchCursor;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonJavaScript;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class MapReduceWithInlineResultsOperation<T>
implements ReadOperationMapReduceCursor<T> {
    private static final String COMMAND_NAME = "mapReduce";
    private final MongoNamespace namespace;
    private final BsonJavaScript mapFunction;
    private final BsonJavaScript reduceFunction;
    private final Decoder<T> decoder;
    private BsonJavaScript finalizeFunction;
    private BsonDocument scope;
    private BsonDocument filter;
    private BsonDocument sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose;
    private Collation collation;

    public MapReduceWithInlineResultsOperation(MongoNamespace namespace, BsonJavaScript mapFunction, BsonJavaScript reduceFunction, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.mapFunction = Assertions.notNull("mapFunction", mapFunction);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonJavaScript getMapFunction() {
        return this.mapFunction;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public MapReduceWithInlineResultsOperation<T> finalizeFunction(BsonJavaScript finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public MapReduceWithInlineResultsOperation<T> scope(@Nullable BsonDocument scope) {
        this.scope = scope;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public MapReduceWithInlineResultsOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public MapReduceWithInlineResultsOperation<T> sort(@Nullable BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public MapReduceWithInlineResultsOperation<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean isJsMode() {
        return this.jsMode;
    }

    public MapReduceWithInlineResultsOperation<T> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MapReduceWithInlineResultsOperation<T> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public MapReduceWithInlineResultsOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public MapReduceBatchCursor<T> execute(ReadBinding binding, OperationContext operationContext) {
        return SyncOperationHelper.executeRetryableRead(binding, operationContext, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "results"), this.transformer(), false);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, OperationContext operationContext, SingleResultCallback<MapReduceAsyncBatchCursor<T>> callback) {
        SingleResultCallback<MapReduceAsyncBatchCursor<T>> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        AsyncOperationHelper.executeRetryableReadAsync(binding, operationContext, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "results"), this.asyncTransformer(), false, errHandlingCallback);
    }

    public ReadOperationSimple<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new ExplainCommandOperation<BsonDocument>(this.namespace.getDatabaseName(), this.getCommandName(), (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = this.getCommandCreator().create(operationContext, serverDescription, connectionDescription);
            CommandHelper.applyMaxTimeMS(operationContext.getTimeoutContext(), command);
            return ExplainHelper.asExplainCommand(command, explainVerbosity);
        }, (Decoder<BsonDocument>)new BsonDocumentCodec());
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, MapReduceBatchCursor<T>> transformer() {
        return (result, source, connection, operationContext) -> new MapReduceInlineResultsCursor(new SingleBatchCursor(BsonDocumentWrapperHelper.toList(result, "results"), 0, connection.getDescription().getServerAddress()), MapReduceHelper.createStatistics(result));
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, MapReduceAsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection, operationContext) -> new MapReduceInlineResultsAsyncCursor(new AsyncSingleBatchCursor(BsonDocumentWrapperHelper.toList(result, "results"), 0), MapReduceHelper.createStatistics(result));
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument commandDocument = new BsonDocument(this.getCommandName(), (BsonValue)new BsonString(this.namespace.getCollectionName())).append("map", (BsonValue)this.getMapFunction()).append("reduce", (BsonValue)this.getReduceFunction()).append("out", (BsonValue)new BsonDocument("inline", (BsonValue)new BsonInt32(1)));
            DocumentHelper.putIfNotNull(commandDocument, "query", (BsonValue)this.getFilter());
            DocumentHelper.putIfNotNull(commandDocument, "sort", (BsonValue)this.getSort());
            DocumentHelper.putIfNotNull(commandDocument, "finalize", (BsonValue)this.getFinalizeFunction());
            DocumentHelper.putIfNotNull(commandDocument, "scope", (BsonValue)this.getScope());
            DocumentHelper.putIfTrue(commandDocument, "verbose", this.isVerbose());
            OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), connectionDescription.getMaxWireVersion(), commandDocument);
            DocumentHelper.putIfNotZero(commandDocument, "limit", this.getLimit());
            DocumentHelper.putIfTrue(commandDocument, "jsMode", this.isJsMode());
            if (this.collation != null) {
                commandDocument.put("collation", (BsonValue)this.collation.asDocument());
            }
            return commandDocument;
        };
    }
}

