/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class DropIndexOperation
implements WriteOperation<Void> {
    private static final String COMMAND_NAME = "dropIndexes";
    private final MongoNamespace namespace;
    private final String indexName;
    private final BsonDocument indexKeys;
    private final WriteConcern writeConcern;

    public DropIndexOperation(MongoNamespace namespace, String indexName, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.indexName = Assertions.notNull("indexName", indexName);
        this.indexKeys = null;
        this.writeConcern = writeConcern;
    }

    public DropIndexOperation(MongoNamespace namespace, BsonDocument indexKeys, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.indexKeys = Assertions.notNull("indexKeys", indexKeys);
        this.indexName = null;
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Void execute(WriteBinding binding, OperationContext operationContext) {
        try {
            SyncOperationHelper.executeCommand(binding, operationContext, this.namespace.getDatabaseName(), this.getCommandCreator(), SyncOperationHelper.writeConcernErrorTransformer(operationContext.getTimeoutContext()));
        }
        catch (MongoCommandException e) {
            CommandOperationHelper.rethrowIfNotNamespaceError(e);
        }
        return null;
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, OperationContext operationContext, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.executeCommandAsync(binding, operationContext, this.namespace.getDatabaseName(), this.getCommandCreator(), AsyncOperationHelper.writeConcernErrorTransformerAsync(operationContext.getTimeoutContext()), (result, t) -> {
            if (t != null && !CommandOperationHelper.isNamespaceError(t)) {
                callback.onResult(null, t);
            } else {
                callback.onResult(null, null);
            }
        });
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = new BsonDocument(this.getCommandName(), (BsonValue)new BsonString(this.namespace.getCollectionName()));
            if (this.indexName != null) {
                command.put("index", (BsonValue)new BsonString(this.indexName));
            } else {
                command.put("index", (BsonValue)this.indexKeys);
            }
            WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, command);
            return command;
        };
    }
}

