/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AggregateOperation;
import com.mongodb.internal.operation.ReadOperationSimple;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class CountDocumentsOperation
implements ReadOperationSimple<Long> {
    private static final String COMMAND_NAME = "aggregate";
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private BsonDocument filter;
    private BsonValue hint;
    private BsonValue comment;
    private long skip;
    private long limit;
    private Collation collation;

    public CountDocumentsOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    @Nullable
    public BsonDocument getFilter() {
        return this.filter;
    }

    public CountDocumentsOperation filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public CountDocumentsOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public BsonValue getHint() {
        return this.hint;
    }

    public CountDocumentsOperation hint(@Nullable BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CountDocumentsOperation limit(long limit) {
        this.limit = limit;
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public CountDocumentsOperation skip(long skip) {
        this.skip = skip;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public CountDocumentsOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public CountDocumentsOperation comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Long execute(ReadBinding binding, OperationContext operationContext) {
        try (Object cursor = this.getAggregateOperation().execute(binding, operationContext);){
            Long l = cursor.hasNext() ? this.getCountFromAggregateResults((List<BsonDocument>)cursor.next()) : 0L;
            return l;
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, OperationContext operationContext, SingleResultCallback<Long> callback) {
        this.getAggregateOperation().executeAsync(binding, operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                result.next((result1, t1) -> {
                    if (t1 != null) {
                        callback.onResult(null, t1);
                    } else {
                        callback.onResult(this.getCountFromAggregateResults((List<BsonDocument>)result1), null);
                    }
                });
            }
        });
    }

    private AggregateOperation<BsonDocument> getAggregateOperation() {
        return new AggregateOperation<BsonDocument>(this.namespace, this.getPipeline(), DECODER).retryReads(this.retryReads).collation(this.collation).comment(this.comment).hint(this.hint);
    }

    private List<BsonDocument> getPipeline() {
        ArrayList<BsonDocument> pipeline = new ArrayList<BsonDocument>();
        pipeline.add(new BsonDocument("$match", (BsonValue)(this.filter != null ? this.filter : new BsonDocument())));
        if (this.skip > 0L) {
            pipeline.add(new BsonDocument("$skip", (BsonValue)new BsonInt64(this.skip)));
        }
        if (this.limit > 0L) {
            pipeline.add(new BsonDocument("$limit", (BsonValue)new BsonInt64(this.limit)));
        }
        pipeline.add(new BsonDocument("$group", (BsonValue)new BsonDocument("_id", (BsonValue)new BsonInt32(1)).append("n", (BsonValue)new BsonDocument("$sum", (BsonValue)new BsonInt32(1)))));
        return pipeline;
    }

    private Long getCountFromAggregateResults(@Nullable List<BsonDocument> results) {
        if (results == null || results.isEmpty()) {
            return 0L;
        }
        return results.get(0).getNumber((Object)"n").longValue();
    }
}

