/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.ReadOperationSimple;
import com.mongodb.internal.operation.SyncOperationHelper;
import org.bson.BsonDocument;
import org.bson.codecs.Decoder;

public class CommandReadOperation<T>
implements ReadOperationSimple<T> {
    private final String commandName;
    private final String databaseName;
    private final CommandOperationHelper.CommandCreator commandCreator;
    private final Decoder<T> decoder;

    public CommandReadOperation(String databaseName, BsonDocument command, Decoder<T> decoder) {
        this(databaseName, command.getFirstKey(), (operationContext, serverDescription, connectionDescription) -> command, decoder);
    }

    public CommandReadOperation(String databaseName, String commandName, CommandOperationHelper.CommandCreator commandCreator, Decoder<T> decoder) {
        this.commandName = Assertions.notNull("commandName", commandName);
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.commandCreator = Assertions.notNull("commandCreator", commandCreator);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public MongoNamespace getNamespace() {
        return new MongoNamespace(this.databaseName, "$cmd");
    }

    @Override
    public T execute(ReadBinding binding, OperationContext operationContext) {
        return SyncOperationHelper.executeRetryableRead(binding, operationContext, this.databaseName, this.commandCreator, this.decoder, CommandReadOperation.transformer(), false);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, OperationContext operationContext, SingleResultCallback<T> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, operationContext, this.databaseName, this.commandCreator, this.decoder, CommandReadOperation.asyncTransformer(), false, callback);
    }

    private static <T> SyncOperationHelper.CommandReadTransformer<T, T> transformer() {
        return (result, source, connection, operationContext) -> result;
    }

    private static <T> AsyncOperationHelper.CommandReadTransformerAsync<T, T> asyncTransformer() {
        return (result, source, connection, operationContext) -> result;
    }
}

