/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.CommandBatchCursorHelper;
import com.mongodb.internal.operation.CommandCursorResult;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.Cursor;
import com.mongodb.internal.operation.CursorResourceManager;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

class CommandCursor<T>
implements Cursor<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    @Nullable
    private final BsonValue comment;
    private final int maxWireVersion;
    private final boolean firstBatchEmpty;
    private final ResourceManager resourceManager;
    private int batchSize;
    private CommandCursorResult<T> commandCursorResult;
    @Nullable
    private List<T> nextBatch;

    CommandCursor(BsonDocument commandCursorDocument, int batchSize, Decoder<T> decoder, @Nullable BsonValue comment, ConnectionSource connectionSource, Connection connection) {
        ConnectionDescription connectionDescription = connection.getDescription();
        this.commandCursorResult = this.toCommandCursorResult(connectionDescription.getServerAddress(), "firstBatch", commandCursorDocument);
        this.namespace = this.commandCursorResult.getNamespace();
        this.batchSize = batchSize;
        this.decoder = decoder;
        this.comment = comment;
        this.maxWireVersion = connectionDescription.getMaxWireVersion();
        this.firstBatchEmpty = this.commandCursorResult.getResults().isEmpty();
        Connection connectionToPin = connectionSource.getServerDescription().getType() == ServerType.LOAD_BALANCER ? connection : null;
        this.resourceManager = new ResourceManager(this.namespace, connectionSource, connectionToPin, this.commandCursorResult.getServerCursor());
    }

    @Override
    public boolean hasNext(OperationContext operationContext) {
        return Assertions.assertNotNull(this.resourceManager.execute("Cursor has been closed", () -> this.doHasNext(operationContext), operationContext));
    }

    private boolean doHasNext(OperationContext operationContext) {
        if (this.nextBatch != null) {
            return true;
        }
        while (this.resourceManager.getServerCursor() != null) {
            this.getMore(operationContext);
            if (!this.resourceManager.operable()) {
                throw new IllegalStateException("Cursor has been closed");
            }
            if (this.nextBatch == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> next(OperationContext operationContext) {
        return Assertions.assertNotNull(this.resourceManager.execute("Iterator has been closed", () -> this.doNext(operationContext), operationContext));
    }

    @Override
    public int available() {
        return !this.resourceManager.operable() || this.nextBatch == null ? 0 : this.nextBatch.size();
    }

    @Nullable
    private List<T> doNext(OperationContext operationContext) {
        if (!this.doHasNext(operationContext)) {
            throw new NoSuchElementException();
        }
        List<T> retVal = this.nextBatch;
        this.nextBatch = null;
        this.commandCursorResult = CommandCursorResult.withEmptyResults(this.commandCursorResult);
        return retVal;
    }

    boolean isClosed() {
        return !this.resourceManager.operable();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void close(OperationContext operationContext) {
        this.resourceManager.close(operationContext);
    }

    @Override
    @Nullable
    public List<T> tryNext(OperationContext operationContext) {
        return this.resourceManager.execute("Cursor has been closed", () -> {
            if (!this.tryHasNext(operationContext)) {
                return null;
            }
            return this.doNext(operationContext);
        }, operationContext);
    }

    private boolean tryHasNext(OperationContext operationContext) {
        if (this.nextBatch != null) {
            return true;
        }
        if (this.resourceManager.getServerCursor() != null) {
            this.getMore(operationContext);
        }
        return this.nextBatch != null;
    }

    @Override
    @Nullable
    public ServerCursor getServerCursor() {
        if (!this.resourceManager.operable()) {
            throw new IllegalStateException("Iterator has been closed");
        }
        return this.resourceManager.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        if (!this.resourceManager.operable()) {
            throw new IllegalStateException("Iterator has been closed");
        }
        return this.commandCursorResult.getServerAddress();
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.commandCursorResult.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.commandCursorResult.getOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.firstBatchEmpty;
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void getMore(OperationContext operationContext) {
        ServerCursor serverCursor = Assertions.assertNotNull(this.resourceManager.getServerCursor());
        this.resourceManager.executeWithConnection(connection -> {
            ServerCursor nextServerCursor;
            try {
                this.commandCursorResult = this.toCommandCursorResult(connection.getDescription().getServerAddress(), "nextBatch", Assertions.assertNotNull(connection.command(this.namespace.getDatabaseName(), CommandBatchCursorHelper.getMoreCommandDocument(serverCursor.getId(), connection.getDescription(), this.namespace, this.batchSize, this.comment), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), CommandResultDocumentCodec.create(this.decoder, "nextBatch"), operationContext)));
                nextServerCursor = this.commandCursorResult.getServerCursor();
            }
            catch (MongoCommandException e) {
                throw CommandBatchCursorHelper.translateCommandException(e, serverCursor);
            }
            this.resourceManager.setServerCursor(nextServerCursor);
        }, operationContext);
    }

    private CommandCursorResult<T> toCommandCursorResult(ServerAddress serverAddress, String fieldNameContainingBatch, BsonDocument commandCursorDocument) {
        CommandCursorResult commandCursorResult = new CommandCursorResult(serverAddress, fieldNameContainingBatch, commandCursorDocument);
        CommandBatchCursorHelper.logCommandCursorResult(commandCursorResult);
        this.nextBatch = commandCursorResult.getResults().isEmpty() ? null : commandCursorResult.getResults();
        return commandCursorResult;
    }

    @ThreadSafe
    private final class ResourceManager
    extends CursorResourceManager<ConnectionSource, Connection> {
        ResourceManager(MongoNamespace namespace, @Nullable ConnectionSource connectionSource, @Nullable Connection connectionToPin, ServerCursor serverCursor) {
            super(namespace, connectionSource, connectionToPin, serverCursor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        <R> R execute(String exceptionMessageIfClosed, Supplier<R> operation, OperationContext operationContext) throws IllegalStateException {
            if (!this.tryStartOperation()) {
                throw new IllegalStateException(exceptionMessageIfClosed);
            }
            try {
                R r = operation.get();
                return r;
            }
            finally {
                this.endOperation(operationContext);
            }
        }

        @Override
        void markAsPinned(Connection connectionToPin, Connection.PinningMode pinningMode) {
            connectionToPin.markAsPinned(pinningMode);
        }

        @Override
        void doClose(OperationContext operationContext) {
            this.releaseResources(operationContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseResources(OperationContext operationContext) {
            block8: {
                try {
                    if (this.isSkipReleasingServerResourcesOnClose()) {
                        this.unsetServerCursor();
                    }
                    if (super.getServerCursor() == null) break block8;
                    Connection connection = this.getConnection(operationContext);
                    try {
                        this.releaseServerResources(connection, operationContext);
                    }
                    finally {
                        connection.release();
                    }
                }
                catch (MongoException mongoException) {
                }
                finally {
                    this.unsetServerCursor();
                    this.releaseClientResources();
                }
            }
        }

        void executeWithConnection(Consumer<Connection> action, OperationContext operationContext) {
            Connection connection = this.getConnection(operationContext);
            try {
                action.accept(connection);
            }
            catch (MongoSocketException e) {
                this.onCorruptedConnection(connection, e);
                throw e;
            }
            catch (MongoOperationTimeoutException e) {
                Throwable cause = e.getCause();
                if (cause instanceof MongoSocketException) {
                    this.onCorruptedConnection(connection, (MongoSocketException)cause);
                }
                throw e;
            }
            finally {
                connection.release();
            }
        }

        private Connection getConnection(OperationContext operationContext) {
            Assertions.assertTrue(this.getState() != CursorResourceManager.State.IDLE);
            Connection pinnedConnection = (Connection)this.getPinnedConnection();
            if (pinnedConnection == null) {
                return Assertions.assertNotNull((ConnectionSource)this.getConnectionSource()).getConnection(operationContext);
            }
            return pinnedConnection.retain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseServerResources(Connection connection, OperationContext operationContext) {
            try {
                ServerCursor localServerCursor = super.getServerCursor();
                if (localServerCursor != null) {
                    this.killServerCursor(this.getNamespace(), localServerCursor, connection, operationContext);
                }
            }
            finally {
                this.unsetServerCursor();
            }
        }

        private void killServerCursor(MongoNamespace namespace, ServerCursor localServerCursor, Connection localConnection, OperationContext operationContext) {
            localConnection.command(namespace.getDatabaseName(), CommandBatchCursorHelper.getKillCursorsCommand(namespace, localServerCursor), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), new BsonDocumentCodec(), operationContext);
        }
    }
}

