/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoChangeStreamException;
import com.mongodb.MongoException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import com.mongodb.internal.operation.ChangeStreamOperation;
import com.mongodb.internal.operation.Cursor;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.RawBsonDocument;
import org.bson.codecs.Decoder;

final class ChangeStreamBatchCursor<T>
implements AggregateResponseBatchCursor<T> {
    private ReadBinding binding;
    private final OperationContext initialOperationContext;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private Cursor<RawBsonDocument> wrapped;
    private BsonDocument resumeToken;
    private final AtomicBoolean closed;
    private boolean lastOperationTimedOut;

    ChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, Cursor<RawBsonDocument> wrapped, ReadBinding binding, OperationContext operationContext, @Nullable BsonDocument resumeToken, int maxWireVersion) {
        this.changeStreamOperation = changeStreamOperation;
        this.binding = binding.retain();
        this.initialOperationContext = operationContext.withOverride(TimeoutContext::withMaxTimeAsMaxAwaitTimeOverride);
        this.wrapped = wrapped;
        this.resumeToken = resumeToken;
        this.maxWireVersion = maxWireVersion;
        this.closed = new AtomicBoolean();
        this.lastOperationTimedOut = false;
    }

    Cursor<RawBsonDocument> getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean hasNext() {
        return this.resumeableOperation((cursor, operationContext) -> {
            try {
                Boolean bl = cursor.hasNext((OperationContext)operationContext);
                return bl;
            }
            finally {
                this.cachePostBatchResumeToken((Cursor<RawBsonDocument>)cursor);
            }
        });
    }

    @Override
    public List<T> next() {
        return this.resumeableOperation((cursor, operationContext) -> {
            try {
                List<T> list = ChangeStreamBatchCursor.convertAndProduceLastId(cursor.next((OperationContext)operationContext), this.changeStreamOperation.getDecoder(), lastId -> {
                    this.resumeToken = lastId;
                });
                return list;
            }
            finally {
                this.cachePostBatchResumeToken((Cursor<RawBsonDocument>)cursor);
            }
        });
    }

    @Override
    public int available() {
        return this.wrapped.available();
    }

    @Override
    public List<T> tryNext() {
        return this.resumeableOperation((cursor, operationContext) -> {
            try {
                List<RawBsonDocument> tryNext = cursor.tryNext((OperationContext)operationContext);
                List<T> list = tryNext == null ? null : ChangeStreamBatchCursor.convertAndProduceLastId(tryNext, this.changeStreamOperation.getDecoder(), lastId -> {
                    this.resumeToken = lastId;
                });
                return list;
            }
            finally {
                this.cachePostBatchResumeToken((Cursor<RawBsonDocument>)cursor);
            }
        });
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.wrapped.close(this.initialOperationContext);
            this.binding.release();
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.wrapped.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    @Override
    public ServerCursor getServerCursor() {
        return this.wrapped.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.wrapped.getServerAddress();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.wrapped.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.wrapped.isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(Cursor<RawBsonDocument> cursor) {
        if (cursor.getPostBatchResumeToken() != null) {
            this.resumeToken = cursor.getPostBatchResumeToken();
        }
    }

    static <T> List<T> convertAndProduceLastId(List<RawBsonDocument> rawDocuments, Decoder<T> decoder, Consumer<BsonDocument> lastIdConsumer) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (RawBsonDocument rawDocument : Assertions.assertNotNull(rawDocuments)) {
            if (!rawDocument.containsKey((Object)"_id")) {
                throw new MongoChangeStreamException("Cannot provide resume functionality when the resume token is missing.");
            }
            results.add(rawDocument.decode(decoder));
        }
        if (!rawDocuments.isEmpty()) {
            lastIdConsumer.accept(rawDocuments.get(rawDocuments.size() - 1).getDocument((Object)"_id"));
        }
        return results;
    }

    <R> R resumeableOperation(BiFunction<Cursor<RawBsonDocument>, OperationContext, R> function) {
        OperationContext operationContextWithNewlyStartedTimeout = this.initialOperationContext.withNewlyStartedTimeout();
        try {
            R result = this.execute(function, operationContextWithNewlyStartedTimeout);
            this.lastOperationTimedOut = false;
            return result;
        }
        catch (Throwable exception) {
            this.lastOperationTimedOut = ChangeStreamBatchCursor.isTimeoutException(exception);
            throw exception;
        }
    }

    private <R> R execute(BiFunction<Cursor<RawBsonDocument>, OperationContext, R> function, OperationContext operationContext) {
        boolean shouldBeResumed = this.hasPreviousNextTimedOut();
        while (true) {
            if (shouldBeResumed) {
                this.resumeChangeStream(operationContext);
            }
            try {
                return function.apply(this.wrapped, operationContext);
            }
            catch (Throwable t) {
                if (!ChangeStreamBatchCursorHelper.isResumableError(t, this.maxWireVersion)) {
                    throw MongoException.fromThrowableNonNull(t);
                }
                shouldBeResumed = true;
                continue;
            }
            break;
        }
    }

    private void resumeChangeStream(OperationContext operationContext) {
        OperationContext operationContextWithDefaultMaxTime = operationContext.withTimeoutContext(operationContext.getTimeoutContext().withDefaultMaxTime());
        this.wrapped.close(operationContextWithDefaultMaxTime);
        SyncOperationHelper.withReadConnectionSource(this.binding, operationContext, (source, operationContextWithMinRtt) -> {
            this.changeStreamOperation.setChangeStreamOptionsForResume(this.resumeToken, source.getServerDescription().getMaxWireVersion());
            return null;
        });
        this.wrapped = ((ChangeStreamBatchCursor)this.changeStreamOperation.execute(this.binding, operationContextWithDefaultMaxTime)).getWrapped();
        this.binding.release();
    }

    private boolean hasPreviousNextTimedOut() {
        return this.lastOperationTimedOut && !this.closed.get();
    }

    private static boolean isTimeoutException(Throwable exception) {
        return exception instanceof MongoOperationTimeoutException;
    }
}

