/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;

abstract class AbstractWriteSearchIndexOperation
implements WriteOperation<Void> {
    private final MongoNamespace namespace;

    AbstractWriteSearchIndexOperation(MongoNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public Void execute(WriteBinding binding, OperationContext operationContext) {
        return SyncOperationHelper.withConnection(binding, operationContext, (connection, operationContextWithMinRtt) -> {
            try {
                SyncOperationHelper.executeCommand(binding, operationContextWithMinRtt, this.namespace.getDatabaseName(), this.buildCommand(), connection, SyncOperationHelper.writeConcernErrorTransformer(operationContextWithMinRtt.getTimeoutContext()));
            }
            catch (MongoCommandException mongoCommandException) {
                this.swallowOrThrow(mongoCommandException);
            }
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, OperationContext operationContext, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.withAsyncSourceAndConnection(binding::getWriteConnectionSource, false, operationContext, callback, (connectionSource, connection, operationContextWithMinRtt, cb) -> AsyncOperationHelper.executeCommandAsync(binding, operationContextWithMinRtt, this.namespace.getDatabaseName(), this.buildCommand(), connection, AsyncOperationHelper.writeConcernErrorTransformerAsync(operationContextWithMinRtt.getTimeoutContext()), (result, commandExecutionError) -> {
            try {
                this.swallowOrThrow(commandExecutionError);
                cb.onResult(result, null);
            }
            catch (Throwable mongoCommandException) {
                cb.onResult(null, mongoCommandException);
            }
        }));
    }

    <E extends Throwable> void swallowOrThrow(@Nullable E mongoExecutionException) throws E {
        if (mongoExecutionException != null) {
            throw mongoExecutionException;
        }
    }

    abstract BsonDocument buildCommand();

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }
}

