/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.observability.micrometer;

import com.mongodb.internal.observability.micrometer.Span;
import com.mongodb.internal.observability.micrometer.TraceContext;
import com.mongodb.internal.observability.micrometer.TracingManager;
import com.mongodb.lang.Nullable;

public class TransactionSpan {
    private boolean isConvenientTransaction = false;
    private final Span span;
    @Nullable
    private Throwable reportedError;

    public TransactionSpan(TracingManager tracingManager) {
        this.span = tracingManager.addTransactionSpan();
    }

    public void handleTransactionSpanError(Throwable e) {
        if (this.isConvenientTransaction) {
            this.span.event(e.toString());
            this.reportedError = e;
        } else {
            this.span.error(e);
        }
        if (!this.isConvenientTransaction) {
            this.span.end();
        }
    }

    public void finalizeTransactionSpan(String status) {
        this.span.event(status);
        if (!this.isConvenientTransaction) {
            this.span.end();
        }
        this.reportedError = null;
    }

    public void spanFinalizing(boolean cleanupTransactionContext) {
        if (this.reportedError != null) {
            this.span.error(this.reportedError);
        }
        this.span.end();
        this.reportedError = null;
        if (cleanupTransactionContext) {
            this.isConvenientTransaction = false;
        }
    }

    public void setIsConvenientTransaction() {
        this.isConvenientTransaction = true;
    }

    public TraceContext getContext() {
        return this.span.context();
    }
}

