/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.binding;

import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ServerTuple;
import com.mongodb.internal.selector.ServerAddressSelector;

public class SingleServerBinding
extends AbstractReferenceCounted
implements ReadWriteBinding {
    private final Cluster cluster;
    private final ServerAddress serverAddress;

    public SingleServerBinding(Cluster cluster, ServerAddress serverAddress) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
    }

    @Override
    public ConnectionSource getWriteConnectionSource(OperationContext operationContext) {
        ServerTuple serverTuple = this.cluster.selectServer(new ServerAddressSelector(this.serverAddress), operationContext);
        return new SingleServerBindingConnectionSource(serverTuple);
    }

    @Override
    public ReadPreference getReadPreference() {
        return ReadPreference.primary();
    }

    @Override
    public ConnectionSource getReadConnectionSource(OperationContext operationContext) {
        ServerTuple serverTuple = this.cluster.selectServer(new ServerAddressSelector(this.serverAddress), operationContext);
        return new SingleServerBindingConnectionSource(serverTuple);
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, OperationContext operationContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SingleServerBinding retain() {
        super.retain();
        return this;
    }

    private final class SingleServerBindingConnectionSource
    extends AbstractReferenceCounted
    implements ConnectionSource {
        private final ServerDescription serverDescription;

        private SingleServerBindingConnectionSource(ServerTuple serverTuple) {
            SingleServerBinding.this.retain();
            this.serverDescription = serverTuple.getServerDescription();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public ReadPreference getReadPreference() {
            return ReadPreference.primary();
        }

        @Override
        public Connection getConnection(OperationContext operationContext) {
            return SingleServerBinding.this.cluster.selectServer(new ServerAddressSelector(SingleServerBinding.this.serverAddress), operationContext).getServer().getConnection(operationContext);
        }

        @Override
        public ConnectionSource retain() {
            super.retain();
            return this;
        }

        @Override
        public int release() {
            int count = super.release();
            if (count == 0) {
                SingleServerBinding.this.release();
            }
            return count;
        }
    }
}

