/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.binding;

import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.Server;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.selector.ReadPreferenceWithFallbackServerSelector;
import com.mongodb.internal.selector.ServerAddressSelector;
import com.mongodb.internal.selector.WritableServerSelector;
import com.mongodb.selector.ServerSelector;

public class AsyncClusterBinding
extends AbstractReferenceCounted
implements AsyncClusterAwareReadWriteBinding {
    private final Cluster cluster;
    private final ReadPreference readPreference;

    public AsyncClusterBinding(Cluster cluster, ReadPreference readPreference) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
    }

    @Override
    public AsyncClusterAwareReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public void getReadConnectionSource(OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.getAsyncClusterBindingConnectionSource(new ReadPreferenceServerSelector(this.readPreference), operationContext, callback);
    }

    @Override
    public void getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.cluster.getSettings().getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            this.getReadConnectionSource(operationContext, callback);
        } else {
            ReadPreferenceWithFallbackServerSelector readPreferenceWithFallbackServerSelector = new ReadPreferenceWithFallbackServerSelector(this.readPreference, minWireVersion, fallbackReadPreference);
            this.cluster.selectServerAsync(readPreferenceWithFallbackServerSelector, operationContext, (result, t) -> {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new AsyncClusterBindingConnectionSource(result.getServer(), result.getServerDescription(), readPreferenceWithFallbackServerSelector.getAppliedReadPreference()), null);
                }
            });
        }
    }

    @Override
    public void getWriteConnectionSource(OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.getAsyncClusterBindingConnectionSource(new WritableServerSelector(), operationContext, callback);
    }

    @Override
    public void getConnectionSource(ServerAddress serverAddress, OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.getAsyncClusterBindingConnectionSource(new ServerAddressSelector(serverAddress), operationContext, callback);
    }

    private void getAsyncClusterBindingConnectionSource(ServerSelector serverSelector, OperationContext operationContext, SingleResultCallback<AsyncConnectionSource> callback) {
        this.cluster.selectServerAsync(serverSelector, operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(new AsyncClusterBindingConnectionSource(result.getServer(), result.getServerDescription(), this.readPreference), null);
            }
        });
    }

    private final class AsyncClusterBindingConnectionSource
    extends AbstractReferenceCounted
    implements AsyncConnectionSource {
        private final Server server;
        private final ServerDescription serverDescription;
        private final ReadPreference appliedReadPreference;

        private AsyncClusterBindingConnectionSource(Server server, ServerDescription serverDescription, ReadPreference appliedReadPreference) {
            this.server = server;
            this.serverDescription = serverDescription;
            this.appliedReadPreference = appliedReadPreference;
            AsyncClusterBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.appliedReadPreference;
        }

        @Override
        public void getConnection(OperationContext operationContext, SingleResultCallback<AsyncConnection> callback) {
            this.server.getConnectionAsync(operationContext.withConnectionEstablishmentSessionContext(), callback);
        }

        @Override
        public AsyncConnectionSource retain() {
            super.retain();
            AsyncClusterBinding.this.retain();
            return this;
        }

        @Override
        public int release() {
            int count = super.release();
            AsyncClusterBinding.this.release();
            return count;
        }
    }
}

