/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.LoopState;
import com.mongodb.lang.Nullable;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;

@NotThreadSafe
public final class RetryState {
    public static final int RETRIES = 1;
    public static final int INFINITE_ATTEMPTS = Integer.MAX_VALUE;
    private final LoopState loopState;
    private final int attempts;
    private final boolean retryUntilTimeoutThrowsException;
    @Nullable
    private Throwable previouslyChosenException;

    public static RetryState withRetryableState(int retries, boolean retryUntilTimeoutThrowsException) {
        Assertions.assertTrue(retries > 0);
        return new RetryState(retries, retryUntilTimeoutThrowsException);
    }

    public static RetryState withNonRetryableState() {
        return new RetryState(0, false);
    }

    public RetryState(TimeoutContext timeoutContext) {
        this(Integer.MAX_VALUE, timeoutContext.hasTimeoutMS());
    }

    private RetryState(int retries, boolean retryUntilTimeoutThrowsException) {
        Assertions.assertTrue(retries >= 0);
        this.loopState = new LoopState();
        this.attempts = retries == Integer.MAX_VALUE ? Integer.MAX_VALUE : retries + 1;
        this.retryUntilTimeoutThrowsException = retryUntilTimeoutThrowsException;
    }

    void advanceOrThrow(RuntimeException attemptException, BinaryOperator<Throwable> onAttemptFailureOperator, BiPredicate<RetryState, Throwable> retryPredicate) throws RuntimeException {
        try {
            this.doAdvanceOrThrow(attemptException, onAttemptFailureOperator, retryPredicate, true);
        }
        catch (Error | RuntimeException unchecked) {
            throw unchecked;
        }
        catch (Throwable checked) {
            throw new AssertionError((Object)checked);
        }
    }

    void advanceOrThrow(Throwable attemptException, BinaryOperator<Throwable> onAttemptFailureOperator, BiPredicate<RetryState, Throwable> retryPredicate) throws Throwable {
        this.doAdvanceOrThrow(attemptException, onAttemptFailureOperator, retryPredicate, false);
    }

    private void doAdvanceOrThrow(Throwable attemptException, BinaryOperator<Throwable> onAttemptFailureOperator, BiPredicate<RetryState, Throwable> retryPredicate, boolean onlyRuntimeExceptions) throws Throwable {
        Assertions.assertTrue(this.attempt() < this.attempts);
        Assertions.assertNotNull(attemptException);
        if (onlyRuntimeExceptions) {
            Assertions.assertTrue(RetryState.isRuntime(attemptException));
        }
        Assertions.assertTrue(!this.isFirstAttempt() || this.previouslyChosenException == null);
        Throwable newlyChosenException = RetryState.callOnAttemptFailureOperator(this.previouslyChosenException, attemptException, onlyRuntimeExceptions, onAttemptFailureOperator);
        if (this.isLastAttempt() || attemptException instanceof MongoOperationTimeoutException) {
            this.previouslyChosenException = newlyChosenException;
            if (this.retryUntilTimeoutThrowsException && !this.loopState.isLastIteration()) {
                this.previouslyChosenException = TimeoutContext.createMongoTimeoutException("Retry attempt exceeded the timeout limit.", this.previouslyChosenException);
            }
            throw this.previouslyChosenException;
        }
        boolean retry = this.shouldRetry(this, attemptException, newlyChosenException, onlyRuntimeExceptions, retryPredicate);
        this.previouslyChosenException = newlyChosenException;
        if (!retry) {
            throw this.previouslyChosenException;
        }
        Assertions.assertTrue(this.loopState.advance());
    }

    private static Throwable callOnAttemptFailureOperator(@Nullable Throwable previouslyChosenException, Throwable attemptException, boolean onlyRuntimeExceptions, BinaryOperator<Throwable> onAttemptFailureOperator) {
        Throwable result;
        if (onlyRuntimeExceptions && previouslyChosenException != null) {
            Assertions.assertTrue(RetryState.isRuntime(previouslyChosenException));
        }
        try {
            result = Assertions.assertNotNull((Throwable)onAttemptFailureOperator.apply(previouslyChosenException, attemptException));
            if (onlyRuntimeExceptions) {
                Assertions.assertTrue(RetryState.isRuntime(result));
            }
        }
        catch (Throwable onAttemptFailureOperatorException) {
            if (onlyRuntimeExceptions && !RetryState.isRuntime(onAttemptFailureOperatorException)) {
                throw onAttemptFailureOperatorException;
            }
            if (previouslyChosenException != null) {
                onAttemptFailureOperatorException.addSuppressed(previouslyChosenException);
            }
            onAttemptFailureOperatorException.addSuppressed(attemptException);
            throw onAttemptFailureOperatorException;
        }
        return result;
    }

    private boolean shouldRetry(RetryState readOnlyRetryState, Throwable attemptException, Throwable newlyChosenException, boolean onlyRuntimeExceptions, BiPredicate<RetryState, Throwable> retryPredicate) {
        try {
            return retryPredicate.test(readOnlyRetryState, attemptException);
        }
        catch (Throwable retryPredicateException) {
            if (onlyRuntimeExceptions && !RetryState.isRuntime(retryPredicateException)) {
                throw retryPredicateException;
            }
            retryPredicateException.addSuppressed(newlyChosenException);
            throw retryPredicateException;
        }
    }

    private static boolean isRuntime(@Nullable Throwable exception) {
        return exception instanceof RuntimeException;
    }

    public void breakAndThrowIfRetryAnd(Supplier<Boolean> predicate) throws RuntimeException {
        Assertions.assertFalse(this.loopState.isLastIteration());
        if (!this.isFirstAttempt()) {
            Assertions.assertNotNull(this.previouslyChosenException);
            Assertions.assertTrue(this.previouslyChosenException instanceof RuntimeException);
            RuntimeException localException = (RuntimeException)this.previouslyChosenException;
            try {
                if (predicate.get().booleanValue()) {
                    this.loopState.markAsLastIteration();
                }
            }
            catch (Exception predicateException) {
                predicateException.addSuppressed(localException);
                throw predicateException;
            }
            if (this.loopState.isLastIteration()) {
                throw localException;
            }
        }
    }

    public boolean breakAndCompleteIfRetryAnd(Supplier<Boolean> predicate, SingleResultCallback<?> callback) {
        try {
            this.breakAndThrowIfRetryAnd(predicate);
            return false;
        }
        catch (Throwable t) {
            callback.onResult(null, t);
            return true;
        }
    }

    public void markAsLastAttempt() {
        this.loopState.markAsLastIteration();
    }

    public boolean isFirstAttempt() {
        return this.loopState.isFirstIteration();
    }

    public boolean isLastAttempt() {
        if (this.loopState.isLastIteration()) {
            return true;
        }
        if (this.retryUntilTimeoutThrowsException) {
            return false;
        }
        return this.attempt() == this.attempts - 1;
    }

    public int attempt() {
        return this.loopState.iteration();
    }

    public int attempts() {
        return this.attempts == Integer.MAX_VALUE ? 0 : this.attempts;
    }

    public Optional<Throwable> exception() {
        Assertions.assertTrue(this.previouslyChosenException == null || !this.isFirstAttempt());
        return Optional.ofNullable(this.previouslyChosenException);
    }

    public <V> RetryState attach(LoopState.AttachmentKey<V> key, V value, boolean autoRemove) {
        this.loopState.attach(key, value, autoRemove);
        return this;
    }

    public <V> Optional<V> attachment(LoopState.AttachmentKey<V> key) {
        return this.loopState.attachment(key);
    }

    public String toString() {
        return "RetryState{loopState=" + this.loopState + ", attempts=" + (this.attempts == Integer.MAX_VALUE ? "infinite" : Integer.valueOf(this.attempts)) + ", exception=" + this.previouslyChosenException + '}';
    }
}

