/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.mql.BranchesTerminal;
import com.mongodb.client.model.mql.MqlArray;
import com.mongodb.client.model.mql.MqlBoolean;
import com.mongodb.client.model.mql.MqlDate;
import com.mongodb.client.model.mql.MqlDocument;
import com.mongodb.client.model.mql.MqlExpression;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlMap;
import com.mongodb.client.model.mql.MqlNumber;
import com.mongodb.client.model.mql.MqlString;
import com.mongodb.client.model.mql.MqlValue;
import com.mongodb.client.model.mql.SwitchCase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

@Beta(value={Reason.CLIENT})
public final class BranchesIntermediary<T extends MqlValue, R extends MqlValue>
extends BranchesTerminal<T, R> {
    BranchesIntermediary(List<Function<T, SwitchCase<R>>> branches) {
        super(branches, null);
    }

    private BranchesIntermediary<T, R> with(Function<T, SwitchCase<R>> switchCase) {
        ArrayList v = new ArrayList(this.getBranches());
        v.add(switchCase);
        return new BranchesIntermediary(v);
    }

    private static <T extends MqlValue> MqlExpression<?> mqlEx(T value) {
        return (MqlExpression)value;
    }

    public BranchesIntermediary<T, R> is(Function<? super T, MqlBoolean> predicate, Function<? super T, ? extends R> mapping) {
        Assertions.notNull("predicate", predicate);
        Assertions.notNull("mapping", mapping);
        return this.with(value -> new SwitchCase<MqlValue>((MqlBoolean)predicate.apply(value), (MqlValue)mapping.apply(value)));
    }

    public BranchesIntermediary<T, R> eq(T v, Function<? super T, ? extends R> mapping) {
        Assertions.notNull("v", v);
        Assertions.notNull("mapping", mapping);
        return this.is(value -> value.eq((MqlValue)v), mapping);
    }

    public BranchesIntermediary<T, R> lt(T v, Function<? super T, ? extends R> mapping) {
        Assertions.notNull("v", v);
        Assertions.notNull("mapping", mapping);
        return this.is(value -> value.lt((MqlValue)v), mapping);
    }

    public BranchesIntermediary<T, R> lte(T v, Function<? super T, ? extends R> mapping) {
        Assertions.notNull("v", v);
        Assertions.notNull("mapping", mapping);
        return this.is(value -> value.lte((MqlValue)v), mapping);
    }

    public BranchesIntermediary<T, R> isBoolean(Function<? super MqlBoolean, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> BranchesIntermediary.mqlEx(v).isBoolean(), v -> (MqlValue)mapping.apply((MqlBoolean)v));
    }

    public BranchesIntermediary<T, R> isNumber(Function<? super MqlNumber, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> BranchesIntermediary.mqlEx(v).isNumber(), v -> (MqlValue)mapping.apply((MqlNumber)v));
    }

    public BranchesIntermediary<T, R> isInteger(Function<? super MqlInteger, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> BranchesIntermediary.mqlEx(v).isInteger(), v -> (MqlValue)mapping.apply((MqlInteger)v));
    }

    public BranchesIntermediary<T, R> isString(Function<? super MqlString, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> BranchesIntermediary.mqlEx(v).isString(), v -> (MqlValue)mapping.apply((MqlString)v));
    }

    public BranchesIntermediary<T, R> isDate(Function<? super MqlDate, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> BranchesIntermediary.mqlEx(v).isDate(), v -> (MqlValue)mapping.apply((MqlDate)v));
    }

    public <Q extends MqlValue> BranchesIntermediary<T, R> isArray(Function<? super MqlArray<Q>, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> BranchesIntermediary.mqlEx(v).isArray(), v -> (MqlValue)mapping.apply((MqlArray)v));
    }

    public BranchesIntermediary<T, R> isDocument(Function<? super MqlDocument, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> BranchesIntermediary.mqlEx(v).isDocumentOrMap(), v -> (MqlValue)mapping.apply((MqlDocument)v));
    }

    public <Q extends MqlValue> BranchesIntermediary<T, R> isMap(Function<? super MqlMap<Q>, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> BranchesIntermediary.mqlEx(v).isDocumentOrMap(), v -> (MqlValue)mapping.apply((MqlMap)v));
    }

    public BranchesIntermediary<T, R> isNull(Function<? super MqlValue, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> BranchesIntermediary.mqlEx(v).isNull(), v -> (MqlValue)mapping.apply((MqlValue)v));
    }

    public BranchesTerminal<T, R> defaults(Function<? super T, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.withDefault(value -> (MqlValue)mapping.apply(value));
    }
}

