/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.SearchIndexModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.AggregateToCollectionOperation;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.MapReduceBatchCursor;
import com.mongodb.internal.operation.MapReduceStatistics;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class SyncOperations<TDocument> {
    private final Operations<TDocument> operations;
    private final TimeoutSettings timeoutSettings;

    public SyncOperations(Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, boolean retryReads, TimeoutSettings timeoutSettings) {
        this(null, documentClass, readPreference, codecRegistry, ReadConcern.DEFAULT, WriteConcern.ACKNOWLEDGED, true, retryReads, timeoutSettings);
    }

    public SyncOperations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, boolean retryReads, TimeoutSettings timeoutSettings) {
        this(namespace, documentClass, readPreference, codecRegistry, ReadConcern.DEFAULT, WriteConcern.ACKNOWLEDGED, true, retryReads, timeoutSettings);
    }

    public SyncOperations(@Nullable MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, TimeoutSettings timeoutSettings) {
        WriteConcern writeConcernToUse = writeConcern;
        if (timeoutSettings.getTimeoutMS() != null) {
            writeConcernToUse = Assertions.assertNotNull(WriteConcernHelper.cloneWithoutTimeout(writeConcern));
        }
        this.operations = new Operations<TDocument>(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcernToUse, retryWrites, retryReads);
        this.timeoutSettings = timeoutSettings;
    }

    public TimeoutSettings createTimeoutSettings(long maxTimeMS) {
        return this.timeoutSettings.withMaxTimeMS(maxTimeMS);
    }

    public TimeoutSettings createTimeoutSettings(long maxTimeMS, long maxAwaitTimeMS) {
        return this.timeoutSettings.withMaxTimeAndMaxAwaitTimeMS(maxTimeMS, maxAwaitTimeMS);
    }

    public TimeoutSettings createTimeoutSettings(CountOptions options) {
        return this.createTimeoutSettings(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(EstimatedDocumentCountOptions options) {
        return this.createTimeoutSettings(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOptions options) {
        return this.timeoutSettings.withMaxTimeAndMaxAwaitTimeMS(options.getMaxTime(TimeUnit.MILLISECONDS), options.getMaxAwaitTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOneAndDeleteOptions options) {
        return this.createTimeoutSettings(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOneAndReplaceOptions options) {
        return this.createTimeoutSettings(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOneAndUpdateOptions options) {
        return this.timeoutSettings.withMaxTimeMS(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(CreateIndexOptions options) {
        return this.timeoutSettings.withMaxTimeMS(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(DropIndexOptions options) {
        return this.timeoutSettings.withMaxTimeMS(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public ReadOperation<Long> countDocuments(Bson filter, CountOptions options) {
        return this.operations.countDocuments(filter, options);
    }

    public ReadOperation<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.operations.estimatedDocumentCount(options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> findFirst(Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.findFirst(filter, resultClass, options);
    }

    public <TResult> ExplainableReadOperation<BatchCursor<TResult>> find(Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(filter, resultClass, options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> find(MongoNamespace findNamespace, Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(findNamespace, filter, resultClass, options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> distinct(String fieldName, Bson filter, Class<TResult> resultClass, Collation collation, BsonValue comment) {
        return this.operations.distinct(fieldName, filter, resultClass, collation, comment);
    }

    public <TResult> ExplainableReadOperation<BatchCursor<TResult>> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass, @Nullable TimeoutMode timeoutMode, @Nullable Integer batchSize, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, Boolean allowDiskUse, AggregationLevel aggregationLevel) {
        return this.operations.aggregate(pipeline, resultClass, timeoutMode, batchSize, collation, hint, hintString, comment, variables, allowDiskUse, aggregationLevel);
    }

    public AggregateToCollectionOperation aggregateToCollection(List<? extends Bson> pipeline, @Nullable TimeoutMode timeoutMode, Boolean allowDiskUse, Boolean bypassDocumentValidation, Collation collation, @Nullable Bson hint, @Nullable String hintString, BsonValue comment, Bson variables, AggregationLevel aggregationLevel) {
        return this.operations.aggregateToCollection(pipeline, timeoutMode, allowDiskUse, bypassDocumentValidation, collation, hint, hintString, comment, variables, aggregationLevel);
    }

    public WriteOperation<MapReduceStatistics> mapReduceToCollection(String databaseName, String collectionName, String mapFunction, String reduceFunction, String finalizeFunction, Bson filter, int limit, boolean jsMode, Bson scope, Bson sort, boolean verbose, MapReduceAction action, Boolean bypassDocumentValidation, Collation collation) {
        return this.operations.mapReduceToCollection(databaseName, collectionName, mapFunction, reduceFunction, finalizeFunction, filter, limit, jsMode, scope, sort, verbose, action, bypassDocumentValidation, collation);
    }

    public <TResult> ReadOperation<MapReduceBatchCursor<TResult>> mapReduce(String mapFunction, String reduceFunction, String finalizeFunction, Class<TResult> resultClass, Bson filter, int limit, boolean jsMode, Bson scope, Bson sort, boolean verbose, Collation collation) {
        return this.operations.mapReduce(mapFunction, reduceFunction, finalizeFunction, resultClass, filter, limit, jsMode, scope, sort, verbose, collation);
    }

    public WriteOperation<TDocument> findOneAndDelete(Bson filter, FindOneAndDeleteOptions options) {
        return this.operations.findOneAndDelete(filter, options);
    }

    public WriteOperation<TDocument> findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return this.operations.findOneAndReplace(filter, replacement, options);
    }

    public WriteOperation<TDocument> findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter, update, options);
    }

    public WriteOperation<TDocument> findOneAndUpdate(Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter, update, options);
    }

    public WriteOperation<BulkWriteResult> insertOne(TDocument document, InsertOneOptions options) {
        return this.operations.insertOne(document, options);
    }

    public WriteOperation<BulkWriteResult> replaceOne(Bson filter, TDocument replacement, ReplaceOptions options) {
        return this.operations.replaceOne(filter, replacement, options);
    }

    public WriteOperation<BulkWriteResult> deleteOne(Bson filter, DeleteOptions options) {
        return this.operations.deleteOne(filter, options);
    }

    public WriteOperation<BulkWriteResult> deleteMany(Bson filter, DeleteOptions options) {
        return this.operations.deleteMany(filter, options);
    }

    public WriteOperation<BulkWriteResult> updateOne(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateOne(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateMany(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateMany(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> insertMany(List<? extends TDocument> documents, InsertManyOptions options) {
        return this.operations.insertMany(documents, options);
    }

    public WriteOperation<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.operations.bulkWrite(requests, options);
    }

    public <TResult> ReadOperation<TResult> commandRead(Bson command, Class<TResult> resultClass) {
        return this.operations.commandRead(command, resultClass);
    }

    public WriteOperation<Void> dropDatabase() {
        return this.operations.dropDatabase();
    }

    public WriteOperation<Void> createCollection(String collectionName, CreateCollectionOptions createCollectionOptions, @Nullable AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.createCollection(collectionName, createCollectionOptions, autoEncryptionSettings);
    }

    public WriteOperation<Void> dropCollection(DropCollectionOptions dropCollectionOptions, @Nullable AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.dropCollection(dropCollectionOptions, autoEncryptionSettings);
    }

    public WriteOperation<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.operations.renameCollection(newCollectionNamespace, options);
    }

    public WriteOperation<Void> createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        return this.operations.createView(viewName, viewOn, pipeline, createViewOptions);
    }

    public WriteOperation<Void> createIndexes(List<IndexModel> indexes, CreateIndexOptions options) {
        return this.operations.createIndexes(indexes, options);
    }

    public WriteOperation<Void> createSearchIndexes(List<SearchIndexModel> indexes) {
        return this.operations.createSearchIndexes(indexes);
    }

    public WriteOperation<Void> updateSearchIndex(String indexName, Bson definition) {
        return this.operations.updateSearchIndex(indexName, definition);
    }

    public WriteOperation<Void> dropSearchIndex(String indexName) {
        return this.operations.dropSearchIndex(indexName);
    }

    public <TResult> ExplainableReadOperation<BatchCursor<TResult>> listSearchIndexes(Class<TResult> resultClass, @Nullable String indexName, @Nullable Integer batchSize, @Nullable Collation collation, @Nullable BsonValue comment, @Nullable Boolean allowDiskUse) {
        return this.operations.listSearchIndexes(resultClass, indexName, batchSize, collation, comment, allowDiskUse);
    }

    public WriteOperation<Void> dropIndex(String indexName, DropIndexOptions options) {
        return this.operations.dropIndex(indexName, options);
    }

    public WriteOperation<Void> dropIndex(Bson keys, DropIndexOptions options) {
        return this.operations.dropIndex(keys, options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listCollections(String databaseName, Class<TResult> resultClass, Bson filter, boolean collectionNamesOnly, boolean authorizedCollections, @Nullable Integer batchSize, BsonValue comment, @Nullable TimeoutMode timeoutMode) {
        return this.operations.listCollections(databaseName, resultClass, filter, collectionNamesOnly, authorizedCollections, batchSize, comment, timeoutMode);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listDatabases(Class<TResult> resultClass, Bson filter, Boolean nameOnly, Boolean authorizedDatabases, BsonValue comment) {
        return this.operations.listDatabases(resultClass, filter, nameOnly, authorizedDatabases, comment);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listIndexes(Class<TResult> resultClass, @Nullable Integer batchSize, BsonValue comment, @Nullable TimeoutMode timeoutMode) {
        return this.operations.listIndexes(resultClass, batchSize, comment, timeoutMode);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> changeStream(FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<? extends Bson> pipeline, Decoder<TResult> decoder, ChangeStreamLevel changeStreamLevel, @Nullable Integer batchSize, Collation collation, BsonValue comment, BsonDocument resumeToken, BsonTimestamp startAtOperationTime, BsonDocument startAfter, boolean showExpandedEvents) {
        return this.operations.changeStream(fullDocument, fullDocumentBeforeChange, pipeline, decoder, changeStreamLevel, batchSize, collation, comment, resumeToken, startAtOperationTime, startAfter, showExpandedEvents);
    }
}

