/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.AggregateOperationImpl;
import com.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.mongodb.internal.operation.AsyncChangeStreamBatchCursor;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ChangeStreamBatchCursor;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.Decoder;
import org.bson.codecs.RawBsonDocumentCodec;

public class ChangeStreamOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final RawBsonDocumentCodec RAW_BSON_DOCUMENT_CODEC = new RawBsonDocumentCodec();
    private final AggregateOperationImpl<RawBsonDocument> wrapped;
    private final FullDocument fullDocument;
    private final FullDocumentBeforeChange fullDocumentBeforeChange;
    private final Decoder<T> decoder;
    private final ChangeStreamLevel changeStreamLevel;
    private BsonDocument resumeAfter;
    private BsonDocument startAfter;
    private BsonTimestamp startAtOperationTime;
    private boolean showExpandedEvents;

    public ChangeStreamOperation(MongoNamespace namespace, FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this(namespace, fullDocument, fullDocumentBeforeChange, pipeline, decoder, ChangeStreamLevel.COLLECTION);
    }

    public ChangeStreamOperation(MongoNamespace namespace, FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<BsonDocument> pipeline, Decoder<T> decoder, ChangeStreamLevel changeStreamLevel) {
        this.wrapped = new AggregateOperationImpl(namespace, pipeline, RAW_BSON_DOCUMENT_CODEC, this.getAggregateTarget(), this.getPipelineCreator());
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        this.fullDocumentBeforeChange = Assertions.notNull("fullDocumentBeforeChange", fullDocumentBeforeChange);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.changeStreamLevel = Assertions.notNull("changeStreamLevel", changeStreamLevel);
    }

    public MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public FullDocument getFullDocument() {
        return this.fullDocument;
    }

    public BsonDocument getResumeAfter() {
        return this.resumeAfter;
    }

    public ChangeStreamOperation<T> resumeAfter(BsonDocument resumeAfter) {
        this.resumeAfter = resumeAfter;
        return this;
    }

    public BsonDocument getStartAfter() {
        return this.startAfter;
    }

    public ChangeStreamOperation<T> startAfter(BsonDocument startAfter) {
        this.startAfter = startAfter;
        return this;
    }

    public List<BsonDocument> getPipeline() {
        return this.wrapped.getPipeline();
    }

    public Integer getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    public ChangeStreamOperation<T> batchSize(Integer batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        return this.wrapped.getMaxAwaitTime(timeUnit);
    }

    public ChangeStreamOperation<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    public Collation getCollation() {
        return this.wrapped.getCollation();
    }

    public ChangeStreamOperation<T> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    public ChangeStreamOperation<T> startAtOperationTime(BsonTimestamp startAtOperationTime) {
        this.startAtOperationTime = startAtOperationTime;
        return this;
    }

    public BsonTimestamp getStartAtOperationTime() {
        return this.startAtOperationTime;
    }

    public ChangeStreamOperation<T> retryReads(boolean retryReads) {
        this.wrapped.retryReads(retryReads);
        return this;
    }

    public boolean getRetryReads() {
        return this.wrapped.getRetryReads();
    }

    public BsonValue getComment() {
        return this.wrapped.getComment();
    }

    public ChangeStreamOperation<T> comment(BsonValue comment) {
        this.wrapped.comment(comment);
        return this;
    }

    public boolean getShowExpandedEvents() {
        return this.showExpandedEvents;
    }

    public ChangeStreamOperation<T> showExpandedEvents(boolean showExpandedEvents) {
        this.showExpandedEvents = showExpandedEvents;
        return this;
    }

    @Override
    public BatchCursor<T> execute(final ReadBinding binding) {
        return (BatchCursor)OperationHelper.withReadConnectionSource(binding, new OperationHelper.CallableWithSource<BatchCursor<T>>(){

            @Override
            public BatchCursor<T> call(ConnectionSource source) {
                AggregateResponseBatchCursor cursor = (AggregateResponseBatchCursor)ChangeStreamOperation.this.wrapped.execute(binding);
                return new ChangeStreamBatchCursor(ChangeStreamOperation.this, cursor, binding, ChangeStreamOperation.this.setChangeStreamOptions(cursor.getPostBatchResumeToken(), cursor.getOperationTime(), cursor.getMaxWireVersion(), cursor.isFirstBatchEmpty()), cursor.getMaxWireVersion());
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.wrapped.executeAsync(binding, new SingleResultCallback<AsyncBatchCursor<RawBsonDocument>>(){

            @Override
            public void onResult(AsyncBatchCursor<RawBsonDocument> result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    final AsyncAggregateResponseBatchCursor cursor = (AsyncAggregateResponseBatchCursor)result;
                    OperationHelper.withAsyncReadConnection(binding, new OperationHelper.AsyncCallableWithSource(){

                        @Override
                        public void call(AsyncConnectionSource source, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                callback.onResult(new AsyncChangeStreamBatchCursor(ChangeStreamOperation.this, cursor, binding, ChangeStreamOperation.this.setChangeStreamOptions(cursor.getPostBatchResumeToken(), cursor.getOperationTime(), cursor.getMaxWireVersion(), cursor.isFirstBatchEmpty()), cursor.getMaxWireVersion()), null);
                            }
                            source.release();
                        }
                    });
                }
            }
        });
    }

    private BsonDocument setChangeStreamOptions(BsonDocument postBatchResumeToken, BsonTimestamp operationTime, int maxWireVersion, boolean firstBatchEmpty) {
        BsonDocument resumeToken = null;
        if (this.startAfter != null) {
            resumeToken = this.startAfter;
        } else if (this.resumeAfter != null) {
            resumeToken = this.resumeAfter;
        } else if (this.startAtOperationTime == null && postBatchResumeToken == null && firstBatchEmpty && maxWireVersion >= 7) {
            this.startAtOperationTime = operationTime;
        }
        return resumeToken;
    }

    public void setChangeStreamOptionsForResume(BsonDocument resumeToken, int maxWireVersion) {
        this.startAfter = null;
        if (resumeToken != null) {
            this.startAtOperationTime = null;
            this.resumeAfter = resumeToken;
        } else if (this.startAtOperationTime != null && maxWireVersion >= 7) {
            this.resumeAfter = null;
        } else {
            this.resumeAfter = null;
            this.startAtOperationTime = null;
        }
    }

    private AggregateOperationImpl.AggregateTarget getAggregateTarget() {
        return new AggregateOperationImpl.AggregateTarget(){

            @Override
            public BsonValue create() {
                return ChangeStreamOperation.this.changeStreamLevel == ChangeStreamLevel.COLLECTION ? new BsonString(ChangeStreamOperation.this.getNamespace().getCollectionName()) : new BsonInt32(1);
            }
        };
    }

    private AggregateOperationImpl.PipelineCreator getPipelineCreator() {
        return new AggregateOperationImpl.PipelineCreator(){

            @Override
            public BsonArray create() {
                ArrayList<BsonDocument> changeStreamPipeline = new ArrayList<BsonDocument>();
                BsonDocument changeStream = new BsonDocument();
                if (ChangeStreamOperation.this.fullDocument != FullDocument.DEFAULT) {
                    changeStream.append("fullDocument", (BsonValue)new BsonString(ChangeStreamOperation.this.fullDocument.getValue()));
                }
                if (ChangeStreamOperation.this.fullDocumentBeforeChange != FullDocumentBeforeChange.DEFAULT) {
                    changeStream.append("fullDocumentBeforeChange", (BsonValue)new BsonString(ChangeStreamOperation.this.fullDocumentBeforeChange.getValue()));
                }
                if (ChangeStreamOperation.this.changeStreamLevel == ChangeStreamLevel.CLIENT) {
                    changeStream.append("allChangesForCluster", (BsonValue)BsonBoolean.TRUE);
                }
                if (ChangeStreamOperation.this.showExpandedEvents) {
                    changeStream.append("showExpandedEvents", (BsonValue)BsonBoolean.TRUE);
                }
                if (ChangeStreamOperation.this.resumeAfter != null) {
                    changeStream.append("resumeAfter", (BsonValue)ChangeStreamOperation.this.resumeAfter);
                }
                if (ChangeStreamOperation.this.startAfter != null) {
                    changeStream.append("startAfter", (BsonValue)ChangeStreamOperation.this.startAfter);
                }
                if (ChangeStreamOperation.this.startAtOperationTime != null) {
                    changeStream.append("startAtOperationTime", (BsonValue)ChangeStreamOperation.this.startAtOperationTime);
                }
                changeStreamPipeline.add(new BsonDocument("$changeStream", (BsonValue)changeStream));
                changeStreamPipeline.addAll(ChangeStreamOperation.this.getPipeline());
                return new BsonArray(changeStreamPipeline);
            }
        };
    }
}

