/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model;

import com.mongodb.internal.client.model.AbstractConstructibleBson;
import java.util.Objects;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public abstract class AbstractConstructibleBsonElement<S extends AbstractConstructibleBsonElement<S>>
implements Bson {
    private static final BsonDocument EMPTY_VALUE = new BsonDocument();
    private final String name;
    private final AbstractConstructibleBson<?> value;

    protected AbstractConstructibleBsonElement(String name) {
        this(name, (Bson)EMPTY_VALUE);
    }

    protected AbstractConstructibleBsonElement(String name, Bson value) {
        this.name = name;
        this.value = AbstractConstructibleBson.of(value);
    }

    protected abstract S newSelf(String var1, Bson var2);

    protected final S newWithAppendedValue(String name, Object value) {
        return this.newWithMutatedValue(doc -> doc.append(name, value));
    }

    protected final S newWithMutatedValue(Consumer<Document> mutator) {
        return this.newSelf(this.name, (Bson)this.value.newMutated(mutator));
    }

    public final <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
        return new BsonDocument(this.name, (BsonValue)this.value.toBsonDocument(documentClass, codecRegistry));
    }

    public static AbstractConstructibleBsonElement<?> of(String name, Bson value) {
        return new ConstructibleBsonElement(name, value);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConstructibleBsonElement that = (AbstractConstructibleBsonElement)o;
        return this.name.equals(that.name) && this.value.equals(that.value);
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return "{\"" + this.name + "\": " + this.value + '}';
    }

    private static final class ConstructibleBsonElement
    extends AbstractConstructibleBsonElement<ConstructibleBsonElement> {
        private ConstructibleBsonElement(String name, Bson value) {
            super(name, value);
        }

        @Override
        protected ConstructibleBsonElement newSelf(String name, Bson value) {
            return new ConstructibleBsonElement(name, value);
        }
    }
}

