/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public abstract class AbstractConstructibleBson<S extends AbstractConstructibleBson<S>>
implements Bson {
    private static final Document EMPTY_APPENDED = new Document();
    private final Bson base;
    private final Document appended;

    protected AbstractConstructibleBson(Bson base) {
        this(base, EMPTY_APPENDED);
    }

    protected AbstractConstructibleBson(Bson base, Document appended) {
        this.base = base;
        this.appended = appended;
    }

    protected abstract S newSelf(Bson var1, Document var2);

    public final <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
        BsonDocument baseDoc = this.base.toBsonDocument(documentClass, codecRegistry);
        return baseDoc.isEmpty() && this.appended.isEmpty() ? new BsonDocument() : (this.appended.isEmpty() ? baseDoc : AbstractConstructibleBson.newMerged(baseDoc, this.appended.toBsonDocument(documentClass, codecRegistry)));
    }

    protected final S newAppended(String name, Object value) {
        return this.newMutated(doc -> doc.append(name, value));
    }

    protected final S newMutated(Consumer<Document> mutator) {
        Document newAppended = new Document((Map)this.appended);
        mutator.accept(newAppended);
        return this.newSelf(this.base, newAppended);
    }

    public static AbstractConstructibleBson<?> of(Bson doc) {
        return doc instanceof AbstractConstructibleBson ? (AbstractConstructibleBson)doc : new ConstructibleBson(doc);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConstructibleBson that = (AbstractConstructibleBson)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.appended, that.appended);
    }

    public final int hashCode() {
        return Objects.hash(this.base, this.appended);
    }

    public String toString() {
        return "{base=" + this.base + ", appended=" + this.appended + '}';
    }

    private static BsonDocument newMerged(BsonDocument base, BsonDocument appended) {
        BsonDocument result = base.clone();
        result.putAll((Map)appended);
        return result;
    }

    private static final class ConstructibleBson
    extends AbstractConstructibleBson<ConstructibleBson> {
        private ConstructibleBson(Bson base) {
            super(base);
        }

        private ConstructibleBson(Bson base, Document appended) {
            super(base, appended);
        }

        @Override
        protected ConstructibleBson newSelf(Bson base, Document appended) {
            return new ConstructibleBson(base, appended);
        }
    }
}

