/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.vault;

import com.mongodb.annotations.Beta;
import com.mongodb.lang.Nullable;
import org.bson.BsonBinary;

public class EncryptOptions {
    private BsonBinary keyId;
    private String keyAltName;
    private final String algorithm;
    private Long contentionFactor;
    private QueryType queryType;

    public EncryptOptions(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Nullable
    public BsonBinary getKeyId() {
        return this.keyId;
    }

    @Nullable
    public String getKeyAltName() {
        return this.keyAltName;
    }

    public EncryptOptions keyId(BsonBinary keyId) {
        this.keyId = keyId;
        return this;
    }

    public EncryptOptions keyAltName(String keyAltName) {
        this.keyAltName = keyAltName;
        return this;
    }

    @Beta(value={Beta.Reason.SERVER})
    public EncryptOptions contentionFactor(@Nullable Long contentionFactor) {
        this.contentionFactor = contentionFactor;
        return this;
    }

    @Nullable
    @Beta(value={Beta.Reason.SERVER})
    public Long getContentionFactor() {
        return this.contentionFactor;
    }

    @Beta(value={Beta.Reason.SERVER})
    public EncryptOptions queryType(@Nullable QueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    @Nullable
    @Beta(value={Beta.Reason.SERVER})
    public QueryType getQueryType() {
        return this.queryType;
    }

    public String toString() {
        return "EncryptOptions{keyId=" + this.keyId + ", keyAltName='" + this.keyAltName + '\'' + ", algorithm='" + this.algorithm + '\'' + ", contentionFactor=" + this.contentionFactor + ", queryType=" + (Object)((Object)this.queryType) + '}';
    }

    @Beta(value={Beta.Reason.SERVER})
    public static enum QueryType {
        EQUALITY;

    }
}

