/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Evolving;
import com.mongodb.client.model.search.AddSearchScoreExpression;
import com.mongodb.client.model.search.ConstantSearchScoreExpression;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.GaussSearchScoreExpression;
import com.mongodb.client.model.search.Log1pSearchScoreExpression;
import com.mongodb.client.model.search.LogSearchScoreExpression;
import com.mongodb.client.model.search.MultiplySearchScoreExpression;
import com.mongodb.client.model.search.PathSearchScoreExpression;
import com.mongodb.client.model.search.RelevanceSearchScoreExpression;
import com.mongodb.client.model.search.SearchConstructibleBson;
import com.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.mongodb.internal.client.model.Util;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchScoreExpression
extends Bson {
    public static RelevanceSearchScoreExpression relevanceExpression() {
        return new SearchConstructibleBson((Bson)new BsonDocument("score", (BsonValue)new BsonString("relevance")));
    }

    public static PathSearchScoreExpression pathExpression(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("path", (Bson)new Document("value", (Object)((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)).toValue()));
    }

    public static ConstantSearchScoreExpression constantExpression(float value) {
        return new SearchConstructibleBson((Bson)new BsonDocument("constant", (BsonValue)new BsonDouble((double)value)));
    }

    public static GaussSearchScoreExpression gaussExpression(final double origin, final PathSearchScoreExpression path, final double scale) {
        Assertions.notNull((String)"path", (Object)path);
        com.mongodb.assertions.Assertions.isTrueArgument("scale must not be 0", scale != 0.0);
        Bson value = new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocument pathDoc = path.toBsonDocument(documentClass, codecRegistry);
                com.mongodb.assertions.Assertions.assertTrue(pathDoc.size() == 1);
                return new BsonDocument("origin", (BsonValue)new BsonDouble(origin)).append("path", (BsonValue)pathDoc.values().iterator().next()).append("scale", (BsonValue)new BsonDouble(scale));
            }

            public String toString() {
                return "{\"origin\": " + origin + ", \"path\": " + path + ", \"scale\": " + scale + '}';
            }
        };
        return new SearchConstructibleBsonElement("gauss", value);
    }

    public static LogSearchScoreExpression logExpression(SearchScoreExpression expression) {
        return new SearchConstructibleBson((Bson)new Document("log", Assertions.notNull((String)"expression", (Object)expression)));
    }

    public static Log1pSearchScoreExpression log1pExpression(SearchScoreExpression expression) {
        return new SearchConstructibleBson((Bson)new Document("log1p", Assertions.notNull((String)"expression", (Object)expression)));
    }

    public static AddSearchScoreExpression addExpression(Iterable<? extends SearchScoreExpression> expressions) {
        Assertions.notNull((String)"expressions", expressions);
        com.mongodb.assertions.Assertions.isTrueArgument("expressions must contain at least 2 elements", Util.sizeAtLeast(expressions, 2));
        return new SearchConstructibleBson((Bson)new Document("add", expressions));
    }

    public static MultiplySearchScoreExpression multiplyExpression(Iterable<? extends SearchScoreExpression> expressions) {
        Assertions.notNull((String)"expressions", expressions);
        com.mongodb.assertions.Assertions.isTrueArgument("expressions must contain at least 2 elements", Util.sizeAtLeast(expressions, 2));
        return new SearchConstructibleBson((Bson)new Document("multiply", expressions));
    }

    public static SearchScoreExpression of(Bson expression) {
        return new SearchConstructibleBson((Bson)Assertions.notNull((String)"expression", (Object)expression));
    }
}

