/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Evolving;
import com.mongodb.client.model.search.ConstantSearchScore;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.FunctionSearchScore;
import com.mongodb.client.model.search.PathBoostSearchScore;
import com.mongodb.client.model.search.SearchConstructibleBson;
import com.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.mongodb.client.model.search.SearchScoreExpression;
import com.mongodb.client.model.search.ValueBoostSearchScore;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.assertions.Assertions;
import org.bson.conversions.Bson;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchScore
extends Bson {
    public static ValueBoostSearchScore boost(float value) {
        com.mongodb.assertions.Assertions.isTrueArgument("value must be positive", value > 0.0f);
        return new SearchConstructibleBsonElement("boost", (Bson)new BsonDocument("value", (BsonValue)new BsonDouble((double)value)));
    }

    public static PathBoostSearchScore boost(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("boost", (Bson)new Document("path", (Object)((FieldSearchPath)Assertions.notNull((String)"value", (Object)path)).toValue()));
    }

    public static ConstantSearchScore constant(float value) {
        com.mongodb.assertions.Assertions.isTrueArgument("value must be positive", value > 0.0f);
        return new SearchConstructibleBsonElement("constant", (Bson)new BsonDocument("value", (BsonValue)new BsonDouble((double)value)));
    }

    public static FunctionSearchScore function(SearchScoreExpression expression) {
        return new SearchConstructibleBsonElement("function", (Bson)Assertions.notNull((String)"expression", (Object)expression));
    }

    public static SearchScore of(Bson score) {
        return new SearchConstructibleBson((Bson)Assertions.notNull((String)"score", (Object)score));
    }
}

