/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Evolving;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.search.AutocompleteSearchOperator;
import com.mongodb.client.model.search.CompoundSearchOperatorBase;
import com.mongodb.client.model.search.DateNearSearchOperator;
import com.mongodb.client.model.search.DateRangeConstructibleBsonElement;
import com.mongodb.client.model.search.DateRangeSearchOperatorBase;
import com.mongodb.client.model.search.ExistsSearchOperator;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.GeoNearSearchOperator;
import com.mongodb.client.model.search.NumberNearSearchOperator;
import com.mongodb.client.model.search.NumberRangeConstructibleBsonElement;
import com.mongodb.client.model.search.NumberRangeSearchOperatorBase;
import com.mongodb.client.model.search.SearchConstructibleBson;
import com.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.mongodb.client.model.search.SearchPath;
import com.mongodb.client.model.search.SearchScore;
import com.mongodb.client.model.search.TextSearchOperator;
import com.mongodb.internal.client.model.Util;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import org.bson.Document;
import org.bson.assertions.Assertions;
import org.bson.conversions.Bson;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchOperator
extends Bson {
    public SearchOperator score(SearchScore var1);

    public static CompoundSearchOperatorBase compound() {
        return new SearchConstructibleBsonElement("compound");
    }

    public static ExistsSearchOperator exists(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("exists", (Bson)new Document("path", (Object)((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)).toValue()));
    }

    public static TextSearchOperator text(String query, SearchPath path) {
        return SearchOperator.text(Collections.singleton((String)Assertions.notNull((String)"query", (Object)query)), Collections.singleton((SearchPath)Assertions.notNull((String)"path", (Object)path)));
    }

    public static TextSearchOperator text(Iterable<String> queries, Iterable<? extends SearchPath> paths) {
        Iterator queryIterator = ((Iterable)Assertions.notNull((String)"queries", queries)).iterator();
        com.mongodb.assertions.Assertions.isTrueArgument("queries must not be empty", queryIterator.hasNext());
        String firstQuery = (String)queryIterator.next();
        Iterator pathIterator = ((Iterable)Assertions.notNull((String)"paths", paths)).iterator();
        com.mongodb.assertions.Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBsonElement("text", (Bson)new Document("query", queryIterator.hasNext() ? queries : firstQuery).append("path", (Object)Util.combineToBsonValue(pathIterator, false)));
    }

    public static AutocompleteSearchOperator autocomplete(String query, FieldSearchPath path) {
        return SearchOperator.autocomplete(Collections.singleton((String)Assertions.notNull((String)"query", (Object)query)), path);
    }

    public static AutocompleteSearchOperator autocomplete(Iterable<String> queries, FieldSearchPath path) {
        Iterator queryIterator = ((Iterable)Assertions.notNull((String)"queries", queries)).iterator();
        com.mongodb.assertions.Assertions.isTrueArgument("queries must not be empty", queryIterator.hasNext());
        String firstQuery = (String)queryIterator.next();
        return new SearchConstructibleBsonElement("autocomplete", (Bson)new Document("query", queryIterator.hasNext() ? queries : firstQuery).append("path", (Object)((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)).toValue()));
    }

    public static NumberRangeSearchOperatorBase numberRange(FieldSearchPath path) {
        return SearchOperator.numberRange(Collections.singleton((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)));
    }

    public static NumberRangeSearchOperatorBase numberRange(Iterable<? extends FieldSearchPath> paths) {
        Iterator pathIterator = ((Iterable)Assertions.notNull((String)"paths", paths)).iterator();
        com.mongodb.assertions.Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new NumberRangeConstructibleBsonElement("range", (Bson)new Document("path", (Object)Util.combineToBsonValue(pathIterator, true)));
    }

    public static DateRangeSearchOperatorBase dateRange(FieldSearchPath path) {
        return SearchOperator.dateRange(Collections.singleton((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)));
    }

    public static DateRangeSearchOperatorBase dateRange(Iterable<? extends FieldSearchPath> paths) {
        Iterator pathIterator = ((Iterable)Assertions.notNull((String)"paths", paths)).iterator();
        com.mongodb.assertions.Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new DateRangeConstructibleBsonElement("range", (Bson)new Document("path", (Object)Util.combineToBsonValue(pathIterator, true)));
    }

    public static NumberNearSearchOperator near(Number origin, Number pivot, FieldSearchPath path) {
        return SearchOperator.near(origin, pivot, Collections.singleton((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)));
    }

    public static NumberNearSearchOperator near(Number origin, Number pivot, Iterable<? extends FieldSearchPath> paths) {
        Iterator pathIterator = ((Iterable)Assertions.notNull((String)"paths", paths)).iterator();
        com.mongodb.assertions.Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull((String)"origin", (Object)origin)).append("path", (Object)Util.combineToBsonValue(pathIterator, true)).append("pivot", Assertions.notNull((String)"pivot", (Object)pivot)));
    }

    public static DateNearSearchOperator near(Instant origin, Duration pivot, FieldSearchPath path) {
        return SearchOperator.near(origin, pivot, Collections.singleton((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)));
    }

    public static DateNearSearchOperator near(Instant origin, Duration pivot, Iterable<? extends FieldSearchPath> paths) {
        Iterator pathIterator = ((Iterable)Assertions.notNull((String)"paths", paths)).iterator();
        com.mongodb.assertions.Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        Assertions.notNull((String)"pivot", (Object)pivot);
        com.mongodb.assertions.Assertions.isTrueArgument("pivot must be positive", !pivot.isZero());
        com.mongodb.assertions.Assertions.isTrueArgument("pivot must be positive", !pivot.isNegative());
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull((String)"origin", (Object)origin)).append("path", (Object)Util.combineToBsonValue(pathIterator, true)).append("pivot", (Object)pivot.toMillis()));
    }

    public static GeoNearSearchOperator near(Point origin, Number pivot, FieldSearchPath path) {
        return SearchOperator.near(origin, pivot, Collections.singleton((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)));
    }

    public static GeoNearSearchOperator near(Point origin, Number pivot, Iterable<? extends FieldSearchPath> paths) {
        Iterator pathIterator = ((Iterable)Assertions.notNull((String)"paths", paths)).iterator();
        com.mongodb.assertions.Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull((String)"origin", (Object)origin)).append("path", (Object)Util.combineToBsonValue(pathIterator, true)).append("pivot", Assertions.notNull((String)"pivot", (Object)pivot)));
    }

    public static SearchOperator of(Bson operator) {
        return new SearchConstructibleBson((Bson)Assertions.notNull((String)"operator", (Object)operator));
    }
}

