/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Evolving;
import com.mongodb.client.model.search.DateSearchFacet;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.NumberSearchFacet;
import com.mongodb.client.model.search.SearchConstructibleBson;
import com.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.mongodb.client.model.search.StringSearchFacet;
import com.mongodb.internal.client.model.Util;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@Evolving
@Beta(value={Beta.Reason.CLIENT, Beta.Reason.SERVER})
public interface SearchFacet
extends Bson {
    public static StringSearchFacet stringFacet(String name, FieldSearchPath path) {
        return new SearchConstructibleBsonElement((String)Assertions.notNull((String)"name", (Object)name), (Bson)new Document("type", (Object)"string").append("path", (Object)((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)).toValue()));
    }

    public static NumberSearchFacet numberFacet(String name, FieldSearchPath path, Iterable<? extends Number> boundaries) {
        com.mongodb.assertions.Assertions.isTrueArgument("boundaries must contain at least 2 elements", Util.sizeAtLeast(boundaries, 2));
        return new SearchConstructibleBsonElement((String)Assertions.notNull((String)"name", (Object)name), (Bson)new Document("type", (Object)"number").append("path", (Object)((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)).toValue()).append("boundaries", Assertions.notNull((String)"boundaries", boundaries)));
    }

    public static DateSearchFacet dateFacet(String name, FieldSearchPath path, Iterable<Instant> boundaries) {
        com.mongodb.assertions.Assertions.isTrueArgument("boundaries must contain at least 2 elements", Util.sizeAtLeast(boundaries, 2));
        return new SearchConstructibleBsonElement((String)Assertions.notNull((String)"name", (Object)name), (Bson)new Document("type", (Object)"date").append("path", (Object)((FieldSearchPath)Assertions.notNull((String)"path", (Object)path)).toValue()).append("boundaries", Assertions.notNull((String)"boundaries", boundaries)));
    }

    public static SearchFacet of(Bson facet) {
        return new SearchConstructibleBson((Bson)Assertions.notNull((String)"facet", (Object)facet));
    }

    public static Bson combineToBson(final Iterable<? extends SearchFacet> facets) {
        Assertions.notNull((String)"facets", facets);
        com.mongodb.assertions.Assertions.isTrueArgument("facets must not be empty", Util.sizeAtLeast(facets, 1));
        return new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                HashSet<String> names = new HashSet<String>();
                BsonDocument result = new BsonDocument();
                for (SearchFacet facet : facets) {
                    BsonDocument doc = facet.toBsonDocument(documentClass, codecRegistry);
                    com.mongodb.assertions.Assertions.assertTrue(doc.size() == 1);
                    Map.Entry entry = (Map.Entry)doc.entrySet().iterator().next();
                    String name = (String)entry.getKey();
                    com.mongodb.assertions.Assertions.isTrue(String.format("facet names must be unique. '%s' is used at least twice in %s", names, facets), names.add(name));
                    result.append((String)entry.getKey(), (BsonValue)entry.getValue());
                }
                return result;
            }

            public String toString() {
                return facets.toString();
            }
        };
    }
}

