/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.client.model.search.AutocompleteSearchOperator;
import com.mongodb.client.model.search.CompoundSearchOperator;
import com.mongodb.client.model.search.CompoundSearchOperatorBase;
import com.mongodb.client.model.search.ConstantSearchScore;
import com.mongodb.client.model.search.DateNearSearchOperator;
import com.mongodb.client.model.search.DateSearchFacet;
import com.mongodb.client.model.search.ExistsSearchOperator;
import com.mongodb.client.model.search.FacetSearchCollector;
import com.mongodb.client.model.search.FilterCompoundSearchOperator;
import com.mongodb.client.model.search.FunctionSearchScore;
import com.mongodb.client.model.search.GaussSearchScoreExpression;
import com.mongodb.client.model.search.GeoNearSearchOperator;
import com.mongodb.client.model.search.MustCompoundSearchOperator;
import com.mongodb.client.model.search.MustNotCompoundSearchOperator;
import com.mongodb.client.model.search.NumberNearSearchOperator;
import com.mongodb.client.model.search.NumberSearchFacet;
import com.mongodb.client.model.search.PathBoostSearchScore;
import com.mongodb.client.model.search.PathSearchScoreExpression;
import com.mongodb.client.model.search.SearchFuzzy;
import com.mongodb.client.model.search.SearchOperator;
import com.mongodb.client.model.search.SearchScore;
import com.mongodb.client.model.search.ShouldCompoundSearchOperator;
import com.mongodb.client.model.search.StringSearchFacet;
import com.mongodb.client.model.search.TextSearchOperator;
import com.mongodb.client.model.search.ValueBoostSearchScore;
import com.mongodb.internal.client.model.AbstractConstructibleBsonElement;
import com.mongodb.internal.client.model.Util;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.BsonInt32;
import org.bson.assertions.Assertions;
import org.bson.conversions.Bson;

final class SearchConstructibleBsonElement
extends AbstractConstructibleBsonElement<SearchConstructibleBsonElement>
implements CompoundSearchOperatorBase,
CompoundSearchOperator,
MustCompoundSearchOperator,
MustNotCompoundSearchOperator,
ShouldCompoundSearchOperator,
FilterCompoundSearchOperator,
ExistsSearchOperator,
TextSearchOperator,
AutocompleteSearchOperator,
NumberNearSearchOperator,
DateNearSearchOperator,
GeoNearSearchOperator,
ValueBoostSearchScore,
PathBoostSearchScore,
ConstantSearchScore,
FunctionSearchScore,
GaussSearchScoreExpression,
PathSearchScoreExpression,
FacetSearchCollector,
StringSearchFacet,
NumberSearchFacet,
DateSearchFacet {
    SearchConstructibleBsonElement(String name) {
        super(name);
    }

    SearchConstructibleBsonElement(String name, Bson value) {
        super(name, value);
    }

    @Override
    protected SearchConstructibleBsonElement newSelf(String name, Bson value) {
        return new SearchConstructibleBsonElement(name, value);
    }

    @Override
    public StringSearchFacet numBuckets(int max) {
        return (StringSearchFacet)this.newWithAppendedValue("numBuckets", max);
    }

    @Override
    public SearchConstructibleBsonElement defaultBucket(String name) {
        return (SearchConstructibleBsonElement)this.newWithAppendedValue("default", Assertions.notNull((String)"name", (Object)name));
    }

    @Override
    public SearchConstructibleBsonElement fuzzy(SearchFuzzy option) {
        return (SearchConstructibleBsonElement)this.newWithMutatedValue(doc -> {
            doc.remove((Object)"synonyms");
            doc.append("fuzzy", Assertions.notNull((String)"option", (Object)option));
        });
    }

    @Override
    public TextSearchOperator synonyms(String name) {
        return (TextSearchOperator)this.newWithMutatedValue(doc -> {
            doc.remove((Object)"fuzzy");
            doc.append("synonyms", Assertions.notNull((String)"name", (Object)name));
        });
    }

    @Override
    public AutocompleteSearchOperator anyTokenOrder() {
        return (AutocompleteSearchOperator)this.newWithAppendedValue("tokenOrder", "any");
    }

    @Override
    public AutocompleteSearchOperator sequentialTokenOrder() {
        return (AutocompleteSearchOperator)this.newWithAppendedValue("tokenOrder", "sequential");
    }

    @Override
    public MustCompoundSearchOperator must(Iterable<? extends SearchOperator> clauses) {
        return this.newCombined("must", clauses);
    }

    @Override
    public MustNotCompoundSearchOperator mustNot(Iterable<? extends SearchOperator> clauses) {
        return this.newCombined("mustNot", clauses);
    }

    @Override
    public ShouldCompoundSearchOperator should(Iterable<? extends SearchOperator> clauses) {
        return this.newCombined("should", clauses);
    }

    @Override
    public FilterCompoundSearchOperator filter(Iterable<? extends SearchOperator> clauses) {
        return this.newCombined("filter", clauses);
    }

    private SearchConstructibleBsonElement newCombined(String ruleName, Iterable<? extends SearchOperator> clauses) {
        Assertions.notNull((String)"clauses", clauses);
        com.mongodb.assertions.Assertions.isTrueArgument("clauses must not be empty", Util.sizeAtLeast(clauses, 1));
        return (SearchConstructibleBsonElement)this.newWithMutatedValue(doc -> {
            Iterable existingClauses = (Iterable)doc.get((Object)ruleName, Iterable.class);
            Iterable newClauses = existingClauses == null ? clauses : (Iterable)Stream.concat(StreamSupport.stream(existingClauses.spliterator(), false), StreamSupport.stream(clauses.spliterator(), false)).collect(Collectors.toList());
            doc.append(ruleName, (Object)newClauses);
        });
    }

    @Override
    public ShouldCompoundSearchOperator minimumShouldMatch(int minimumShouldMatch) {
        return (ShouldCompoundSearchOperator)this.newWithAppendedValue("minimumShouldMatch", new BsonInt32(minimumShouldMatch));
    }

    @Override
    public SearchConstructibleBsonElement score(SearchScore modifier) {
        return (SearchConstructibleBsonElement)this.newWithAppendedValue("score", Assertions.notNull((String)"modifier", (Object)modifier));
    }

    @Override
    public SearchConstructibleBsonElement undefined(float fallback) {
        return (SearchConstructibleBsonElement)this.newWithAppendedValue("undefined", Float.valueOf(fallback));
    }

    @Override
    public GaussSearchScoreExpression offset(double offset) {
        return (GaussSearchScoreExpression)this.newWithAppendedValue("offset", offset);
    }

    @Override
    public GaussSearchScoreExpression decay(double decay) {
        com.mongodb.assertions.Assertions.isTrueArgument("decay must be greater than 0", decay > 0.0);
        com.mongodb.assertions.Assertions.isTrueArgument("decay must be less than 1", decay < 1.0);
        return (GaussSearchScoreExpression)this.newWithAppendedValue("decay", decay);
    }
}

