/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.AddSearchScoreExpression;
import com.mongodb.client.model.search.ConstantSearchScoreExpression;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.Log1pSearchScoreExpression;
import com.mongodb.client.model.search.LogSearchScoreExpression;
import com.mongodb.client.model.search.LowerBoundSearchCount;
import com.mongodb.client.model.search.MultiplySearchScoreExpression;
import com.mongodb.client.model.search.RelevanceSearchScoreExpression;
import com.mongodb.client.model.search.SearchCollector;
import com.mongodb.client.model.search.SearchCount;
import com.mongodb.client.model.search.SearchFacet;
import com.mongodb.client.model.search.SearchFuzzy;
import com.mongodb.client.model.search.SearchHighlight;
import com.mongodb.client.model.search.SearchOperator;
import com.mongodb.client.model.search.SearchOptions;
import com.mongodb.client.model.search.SearchScore;
import com.mongodb.client.model.search.TotalSearchCount;
import com.mongodb.client.model.search.WildcardSearchPath;
import com.mongodb.internal.client.model.AbstractConstructibleBson;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.Document;
import org.bson.conversions.Bson;

final class SearchConstructibleBson
extends AbstractConstructibleBson<SearchConstructibleBson>
implements SearchOperator,
SearchScore,
RelevanceSearchScoreExpression,
ConstantSearchScoreExpression,
LogSearchScoreExpression,
Log1pSearchScoreExpression,
AddSearchScoreExpression,
MultiplySearchScoreExpression,
SearchCollector,
SearchOptions,
SearchHighlight,
TotalSearchCount,
LowerBoundSearchCount,
SearchFuzzy,
FieldSearchPath,
WildcardSearchPath,
SearchFacet {
    static final SearchConstructibleBson EMPTY = new SearchConstructibleBson((Bson)new BsonDocument());

    SearchConstructibleBson(Bson base) {
        super(base);
    }

    private SearchConstructibleBson(Bson base, Document appended) {
        super(base, appended);
    }

    @Override
    protected SearchConstructibleBson newSelf(Bson base, Document appended) {
        return new SearchConstructibleBson(base, appended);
    }

    @Override
    public SearchOptions index(String name) {
        return (SearchOptions)this.newAppended("index", new BsonString(Assertions.notNull("name", name)));
    }

    @Override
    public SearchOptions highlight(SearchHighlight option) {
        return (SearchOptions)this.newAppended("highlight", Assertions.notNull("option", option));
    }

    @Override
    public SearchOptions count(SearchCount option) {
        return (SearchOptions)this.newAppended("count", Assertions.notNull("option", option));
    }

    @Override
    public SearchOptions returnStoredSource(boolean returnStoredSource) {
        return (SearchOptions)this.newAppended("returnStoredSource", new BsonBoolean(returnStoredSource));
    }

    @Override
    public SearchOptions option(String name, Object value) {
        return (SearchOptions)this.newAppended(Assertions.notNull("name", name), Assertions.notNull("value", value));
    }

    @Override
    public SearchHighlight maxCharsToExamine(int maxCharsToExamine) {
        return (SearchHighlight)this.newAppended("maxCharsToExamine", new BsonInt32(maxCharsToExamine));
    }

    @Override
    public SearchHighlight maxNumPassages(int maxNumPassages) {
        return (SearchHighlight)this.newAppended("maxNumPassages", new BsonInt32(maxNumPassages));
    }

    @Override
    public LowerBoundSearchCount threshold(int threshold) {
        return (LowerBoundSearchCount)this.newAppended("threshold", new BsonInt32(threshold));
    }

    @Override
    public SearchFuzzy maxEdits(int maxEdits) {
        return (SearchFuzzy)this.newAppended("maxEdits", maxEdits);
    }

    @Override
    public SearchFuzzy prefixLength(int prefixLength) {
        return (SearchFuzzy)this.newAppended("prefixLength", prefixLength);
    }

    @Override
    public SearchFuzzy maxExpansions(int maxExpansions) {
        return (SearchFuzzy)this.newAppended("maxExpansions", maxExpansions);
    }

    @Override
    public FieldSearchPath multi(String analyzerName) {
        return (FieldSearchPath)this.newAppended("multi", new BsonString(Assertions.notNull("analyzerName", analyzerName)));
    }

    @Override
    public SearchOperator score(SearchScore modifier) {
        return (SearchOperator)this.newAppended("score", Assertions.notNull("modifier", modifier));
    }
}

