/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoServerUnavailableException;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.RequestContext;
import com.mongodb.ServerApi;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ServerClosedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerOpeningEvent;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.bulk.DeleteRequest;
import com.mongodb.internal.bulk.InsertRequest;
import com.mongodb.internal.bulk.UpdateRequest;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.CommandProtocol;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.ConnectionFactory;
import com.mongodb.internal.connection.ConnectionPool;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.LegacyProtocol;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.ProtocolExecutor;
import com.mongodb.internal.connection.QueryResult;
import com.mongodb.internal.connection.SdamServerDescriptionManager;
import com.mongodb.internal.connection.ServerDescriptionHelper;
import com.mongodb.internal.connection.ServerMonitor;
import com.mongodb.internal.connection.SplittablePayload;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

class DefaultServer
implements ClusterableServer {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final ServerId serverId;
    private final ConnectionPool connectionPool;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ConnectionFactory connectionFactory;
    private final ServerMonitor serverMonitor;
    private final SdamServerDescriptionManager sdam;
    private final ServerListener serverListener;
    private final CommandListener commandListener;
    private final ClusterClock clusterClock;
    @Nullable
    private final AtomicInteger operationCount;
    private volatile boolean isClosed;

    DefaultServer(ServerId serverId, ClusterConnectionMode clusterConnectionMode, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerMonitor serverMonitor, SdamServerDescriptionManager sdam, ServerListener serverListener, CommandListener commandListener, ClusterClock clusterClock, boolean trackOperationCount) {
        this.sdam = Assertions.assertNotNull(sdam);
        this.serverListener = Assertions.notNull("serverListener", serverListener);
        this.commandListener = commandListener;
        this.clusterClock = Assertions.notNull("clusterClock", clusterClock);
        Assertions.notNull("serverAddress", serverId);
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.connectionFactory = Assertions.notNull("connectionFactory", connectionFactory);
        this.connectionPool = Assertions.notNull("connectionPool", connectionPool);
        this.serverId = serverId;
        serverListener.serverOpening(new ServerOpeningEvent(this.serverId));
        this.serverMonitor = serverMonitor;
        this.operationCount = trackOperationCount ? new AtomicInteger() : null;
    }

    @Override
    public Connection getConnection() {
        if (this.isClosed) {
            throw new MongoServerUnavailableException(String.format("The server at %s is no longer available", this.serverId.getAddress()));
        }
        SdamServerDescriptionManager.SdamIssue.Context exceptionContext = this.sdam.context();
        this.operationBegin();
        try {
            return OperationCountTrackingConnection.decorate(this, this.connectionFactory.create(this.connectionPool.get(), new DefaultServerProtocolExecutor(), this.clusterConnectionMode));
        }
        catch (Throwable e) {
            this.operationEnd();
            if (e instanceof MongoException) {
                this.sdam.handleExceptionBeforeHandshake(SdamServerDescriptionManager.SdamIssue.specific(e, exceptionContext));
            }
            throw e;
        }
    }

    @Override
    public void getConnectionAsync(final SingleResultCallback<AsyncConnection> callback) {
        if (this.isClosed) {
            callback.onResult(null, new MongoServerUnavailableException(String.format("The server at %s is no longer available", this.serverId.getAddress())));
            return;
        }
        final SdamServerDescriptionManager.SdamIssue.Context exceptionContext = this.sdam.context();
        this.operationBegin();
        this.connectionPool.getAsync(new SingleResultCallback<InternalConnection>(){

            @Override
            public void onResult(InternalConnection result, Throwable t) {
                if (t != null) {
                    try {
                        DefaultServer.this.operationEnd();
                        DefaultServer.this.sdam.handleExceptionBeforeHandshake(SdamServerDescriptionManager.SdamIssue.specific(t, exceptionContext));
                    }
                    finally {
                        callback.onResult(null, t);
                    }
                } else {
                    callback.onResult(AsyncOperationCountTrackingConnection.decorate(DefaultServer.this, DefaultServer.this.connectionFactory.createAsync(result, new DefaultServerProtocolExecutor(), DefaultServer.this.clusterConnectionMode)), null);
                }
            }
        });
    }

    @Override
    public int operationCount() {
        return this.operationCount == null ? -1 : this.operationCount.get();
    }

    private void operationBegin() {
        if (this.operationCount != null) {
            this.operationCount.incrementAndGet();
        }
    }

    private void operationEnd() {
        if (this.operationCount != null) {
            Assertions.assertTrue(this.operationCount.decrementAndGet() >= 0);
        }
    }

    @Override
    public void resetToConnecting() {
        this.sdam.update(ServerDescriptionHelper.unknownConnectingServerDescription(this.serverId, null));
    }

    @Override
    public void invalidate() {
        if (!this.isClosed()) {
            this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.unspecified(this.sdam.context()));
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.connectionPool.close();
            this.serverMonitor.close();
            this.isClosed = true;
            this.serverListener.serverClosed(new ServerClosedEvent(this.serverId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void connect() {
        this.serverMonitor.connect();
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    SdamServerDescriptionManager sdamServerDescriptionManager() {
        return this.sdam;
    }

    ServerId serverId() {
        return this.serverId;
    }

    private class DefaultServerProtocolExecutor
    implements ProtocolExecutor {
        private DefaultServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(LegacyProtocol<T> protocol, InternalConnection connection) {
            try {
                protocol.setCommandListener(DefaultServer.this.commandListener);
                return protocol.execute(connection);
            }
            catch (MongoException e) {
                DefaultServer.this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.specific(e, DefaultServer.this.sdam.context(connection)));
                throw e;
            }
        }

        @Override
        public <T> void executeAsync(LegacyProtocol<T> protocol, final InternalConnection connection, final SingleResultCallback<T> callback) {
            protocol.setCommandListener(DefaultServer.this.commandListener);
            protocol.executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback(new SingleResultCallback<T>(){

                @Override
                public void onResult(T result, Throwable t) {
                    try {
                        if (t != null) {
                            DefaultServer.this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.specific(t, DefaultServer.this.sdam.context(connection)));
                        }
                    }
                    finally {
                        callback.onResult(result, t);
                    }
                }
            }, LOGGER));
        }

        @Override
        public <T> T execute(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext) {
            try {
                protocol.sessionContext(new ClusterClockAdvancingSessionContext(sessionContext, DefaultServer.this.clusterClock));
                return protocol.execute(connection);
            }
            catch (MongoException e) {
                DefaultServer.this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.specific(e, DefaultServer.this.sdam.context(connection)));
                if (e instanceof MongoWriteConcernWithResponseException) {
                    return (T)((MongoWriteConcernWithResponseException)e).getResponse();
                }
                if (e instanceof MongoSocketException && sessionContext.hasSession()) {
                    sessionContext.markSessionDirty();
                }
                throw e;
            }
        }

        @Override
        public <T> void executeAsync(CommandProtocol<T> protocol, final InternalConnection connection, final SessionContext sessionContext, final SingleResultCallback<T> callback) {
            protocol.sessionContext(new ClusterClockAdvancingSessionContext(sessionContext, DefaultServer.this.clusterClock));
            protocol.executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback(new SingleResultCallback<T>(){

                @Override
                public void onResult(T result, Throwable t) {
                    if (t != null) {
                        try {
                            DefaultServer.this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.specific(t, DefaultServer.this.sdam.context(connection)));
                        }
                        finally {
                            if (t instanceof MongoWriteConcernWithResponseException) {
                                callback.onResult(((MongoWriteConcernWithResponseException)t).getResponse(), null);
                            } else {
                                if (t instanceof MongoSocketException && sessionContext.hasSession()) {
                                    sessionContext.markSessionDirty();
                                }
                                callback.onResult(null, t);
                            }
                        }
                    } else {
                        callback.onResult(result, null);
                    }
                }
            }, LOGGER));
        }
    }

    private static final class OperationCountTrackingConnection
    implements Connection {
        private final DefaultServer server;
        private final Connection wrapped;

        static Connection decorate(DefaultServer server, Connection connection) {
            return server.operationCount() < 0 ? connection : new OperationCountTrackingConnection(server, connection);
        }

        private OperationCountTrackingConnection(DefaultServer server, Connection connection) {
            this.server = server;
            this.wrapped = connection;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public void release() {
            this.wrapped.release();
            if (this.getCount() == 0) {
                this.server.operationEnd();
            }
        }

        @Override
        public Connection retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public ConnectionDescription getDescription() {
            return this.wrapped.getDescription();
        }

        @Override
        public WriteConcernResult insert(MongoNamespace namespace, boolean ordered, InsertRequest insertRequest, RequestContext requestContext) {
            return this.wrapped.insert(namespace, ordered, insertRequest, requestContext);
        }

        @Override
        public WriteConcernResult update(MongoNamespace namespace, boolean ordered, UpdateRequest updateRequest, RequestContext requestContext) {
            return this.wrapped.update(namespace, ordered, updateRequest, requestContext);
        }

        @Override
        public WriteConcernResult delete(MongoNamespace namespace, boolean ordered, DeleteRequest deleteRequest, RequestContext requestContext) {
            return this.wrapped.delete(namespace, ordered, deleteRequest, requestContext);
        }

        @Override
        public <T> T command(String database, BsonDocument command, FieldNameValidator fieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, ServerApi serverApi, RequestContext requestContext) {
            return this.wrapped.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, sessionContext, serverApi, requestContext);
        }

        @Override
        public <T> T command(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, ServerApi serverApi, RequestContext requestContext, boolean responseExpected, SplittablePayload payload, FieldNameValidator payloadFieldNameValidator) {
            return this.wrapped.command(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, sessionContext, serverApi, requestContext, responseExpected, payload, payloadFieldNameValidator);
        }

        @Override
        public <T> QueryResult<T> query(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int skip, int limit, int batchSize, boolean secondaryOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder, RequestContext requestContext) {
            return this.wrapped.query(namespace, queryDocument, fields, skip, limit, batchSize, secondaryOk, tailableCursor, awaitData, noCursorTimeout, partial, oplogReplay, resultDecoder, requestContext);
        }

        @Override
        public <T> QueryResult<T> getMore(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder, RequestContext requestContext) {
            return this.wrapped.getMore(namespace, cursorId, numberToReturn, resultDecoder, requestContext);
        }

        @Override
        public void killCursor(MongoNamespace namespace, List<Long> cursors, RequestContext requestContext) {
            this.wrapped.killCursor(namespace, cursors, requestContext);
        }

        @Override
        public void markAsPinned(Connection.PinningMode pinningMode) {
            this.wrapped.markAsPinned(pinningMode);
        }
    }

    private static final class AsyncOperationCountTrackingConnection
    implements AsyncConnection {
        private final DefaultServer server;
        private final AsyncConnection wrapped;

        static AsyncConnection decorate(DefaultServer server, AsyncConnection connection) {
            return server.operationCount() < 0 ? connection : new AsyncOperationCountTrackingConnection(server, connection);
        }

        AsyncOperationCountTrackingConnection(DefaultServer server, AsyncConnection connection) {
            this.server = server;
            this.wrapped = connection;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public void release() {
            this.wrapped.release();
            if (this.getCount() == 0) {
                this.server.operationEnd();
            }
        }

        @Override
        public AsyncConnection retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public ConnectionDescription getDescription() {
            return this.wrapped.getDescription();
        }

        @Override
        public void insertAsync(MongoNamespace namespace, boolean ordered, InsertRequest insertRequest, RequestContext requestContext, SingleResultCallback<WriteConcernResult> callback) {
            this.wrapped.insertAsync(namespace, ordered, insertRequest, requestContext, callback);
        }

        @Override
        public void updateAsync(MongoNamespace namespace, boolean ordered, UpdateRequest updateRequest, RequestContext requestContext, SingleResultCallback<WriteConcernResult> callback) {
            this.wrapped.updateAsync(namespace, ordered, updateRequest, requestContext, callback);
        }

        @Override
        public void deleteAsync(MongoNamespace namespace, boolean ordered, DeleteRequest deleteRequest, RequestContext requestContext, SingleResultCallback<WriteConcernResult> callback) {
            this.wrapped.deleteAsync(namespace, ordered, deleteRequest, requestContext, callback);
        }

        @Override
        public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator fieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, ServerApi serverApi, RequestContext requestContext, SingleResultCallback<T> callback) {
            this.wrapped.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, sessionContext, serverApi, requestContext, callback);
        }

        @Override
        public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, ServerApi serverApi, RequestContext requestContext, boolean responseExpected, SplittablePayload payload, FieldNameValidator payloadFieldNameValidator, SingleResultCallback<T> callback) {
            this.wrapped.commandAsync(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, sessionContext, serverApi, requestContext, responseExpected, payload, payloadFieldNameValidator, callback);
        }

        @Override
        public <T> void queryAsync(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int skip, int limit, int batchSize, boolean secondaryOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder, RequestContext requestContext, SingleResultCallback<QueryResult<T>> callback) {
            this.wrapped.queryAsync(namespace, queryDocument, fields, skip, limit, batchSize, secondaryOk, tailableCursor, awaitData, noCursorTimeout, partial, oplogReplay, resultDecoder, requestContext, callback);
        }

        @Override
        public <T> void getMoreAsync(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder, RequestContext requestContext, SingleResultCallback<QueryResult<T>> callback) {
            this.wrapped.getMoreAsync(namespace, cursorId, numberToReturn, resultDecoder, requestContext, callback);
        }

        @Override
        public void killCursorAsync(MongoNamespace namespace, List<Long> cursors, RequestContext requestContext, SingleResultCallback<Void> callback) {
            this.wrapped.killCursorAsync(namespace, cursors, requestContext, callback);
        }

        @Override
        public void markAsPinned(Connection.PinningMode pinningMode) {
            this.wrapped.markAsPinned(pinningMode);
        }
    }
}

