/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.selector;

import com.mongodb.ReadPreference;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.selector.ServerSelector;
import java.util.List;

public class ReadPreferenceWithFallbackServerSelector
implements ServerSelector {
    private final ReadPreference preferredReadPreference;
    private final int minWireVersion;
    private final ReadPreference fallbackReadPreference;
    private ReadPreference appliedReadPreference;

    public ReadPreferenceWithFallbackServerSelector(ReadPreference preferredReadPreference, int minWireVersion, ReadPreference fallbackReadPreference) {
        this.preferredReadPreference = preferredReadPreference;
        this.minWireVersion = minWireVersion;
        this.fallbackReadPreference = fallbackReadPreference;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (this.maxWireVersion(clusterDescription) >= this.minWireVersion) {
            this.appliedReadPreference = this.preferredReadPreference;
            return new ReadPreferenceServerSelector(this.preferredReadPreference).select(clusterDescription);
        }
        this.appliedReadPreference = this.fallbackReadPreference;
        return new ReadPreferenceServerSelector(this.fallbackReadPreference).select(clusterDescription);
    }

    public ReadPreference getAppliedReadPreference() {
        return this.appliedReadPreference;
    }

    private int maxWireVersion(ClusterDescription clusterDescription) {
        return clusterDescription.getServerDescriptions().stream().map(ServerDescription::getMaxWireVersion).max(Integer::compareTo).orElse(0);
    }
}

