/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.QueryResult;
import com.mongodb.internal.operation.AsyncQueryBatchCursor;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.QueryBatchCursor;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.ServerVersionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;

public class ListCollectionsOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final String databaseName;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private int batchSize;
    private long maxTimeMS;
    private boolean nameOnly;

    public ListCollectionsOperation(String databaseName, Decoder<T> decoder) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }

    public ListCollectionsOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public ListCollectionsOperation<T> nameOnly(boolean nameOnly) {
        this.nameOnly = nameOnly;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public ListCollectionsOperation<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public ListCollectionsOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public ListCollectionsOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads);
        Supplier<BatchCursor> read = CommandOperationHelper.decorateReadWithRetries(retryState, () -> {
            CommandOperationHelper.logRetryExecute(retryState);
            return OperationHelper.withSourceAndConnection(binding::getReadConnectionSource, false, (source, connection) -> {
                retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), connection.getDescription(), binding.getSessionContext()));
                if (ServerVersionHelper.serverIsAtLeastVersionThreeDotZero(connection.getDescription())) {
                    try {
                        return CommandOperationHelper.createReadCommandAndExecute(retryState, binding, source, this.databaseName, this.getCommandCreator(), this.createCommandDecoder(), this.commandTransformer(), connection);
                    }
                    catch (MongoCommandException e) {
                        return CommandOperationHelper.rethrowIfNotNamespaceError(e, OperationHelper.createEmptyBatchCursor(this.createNamespace(), this.decoder, source.getServerDescription().getAddress(), this.batchSize));
                    }
                }
                retryState.markAsLastAttempt();
                return new ProjectingBatchCursor(new QueryBatchCursor(connection.query(this.getNamespace(), this.asQueryDocument(connection.getDescription(), binding.getReadPreference()), (BsonDocument)null, 0, 0, this.batchSize, binding.getReadPreference().isSecondaryOk(), false, false, false, false, false, new BsonDocumentCodec(), binding.getRequestContext()), 0, this.batchSize, new BsonDocumentCodec(), (ConnectionSource)source));
            });
        });
        return read.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads);
        binding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncRead = CommandOperationHelper.decorateReadWithRetries(retryState, funcCallback -> {
            CommandOperationHelper.logRetryExecute(retryState);
            OperationHelper.withAsyncSourceAndConnection(binding::getReadConnectionSource, false, funcCallback, (source, connection, releasingCallback) -> {
                if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), connection.getDescription(), binding.getSessionContext()), releasingCallback)) {
                    return;
                }
                if (ServerVersionHelper.serverIsAtLeastVersionThreeDotZero(connection.getDescription())) {
                    CommandOperationHelper.createReadCommandAndExecuteAsync(retryState, binding, source, this.databaseName, this.getCommandCreator(), this.createCommandDecoder(), this.asyncTransformer(), connection, (result, t) -> {
                        if (t != null && !CommandOperationHelper.isNamespaceError(t)) {
                            releasingCallback.onResult(null, t);
                        } else {
                            releasingCallback.onResult(result != null ? result : this.emptyAsyncCursor((AsyncConnectionSource)source), null);
                        }
                    });
                } else {
                    retryState.markAsLastAttempt();
                    connection.queryAsync(this.getNamespace(), this.asQueryDocument(connection.getDescription(), binding.getReadPreference()), (BsonDocument)null, 0, 0, this.batchSize, binding.getReadPreference().isSecondaryOk(), false, false, false, false, false, new BsonDocumentCodec(), binding.getRequestContext(), new SingleResultCallback<QueryResult<BsonDocument>>(){

                        @Override
                        public void onResult(QueryResult<BsonDocument> result, Throwable t) {
                            if (t != null) {
                                releasingCallback.onResult(null, t);
                            } else {
                                releasingCallback.onResult(new ProjectingAsyncBatchCursor(new AsyncQueryBatchCursor<BsonDocument>(result, 0, ListCollectionsOperation.this.batchSize, 0L, (Decoder<BsonDocument>)new BsonDocumentCodec(), source, connection)), null);
                            }
                        }
                    });
                }
            });
        }).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private AsyncBatchCursor<T> emptyAsyncCursor(AsyncConnectionSource source) {
        return OperationHelper.createEmptyAsyncBatchCursor(this.createNamespace(), source.getServerDescription().getAddress());
    }

    private MongoNamespace createNamespace() {
        return new MongoNamespace(this.databaseName, "$cmd.listCollections");
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return new CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result, AsyncConnectionSource source, AsyncConnection connection) {
                return OperationHelper.cursorDocumentToAsyncBatchCursor(result.getDocument((Object)"cursor"), ListCollectionsOperation.this.decoder, source, connection, ListCollectionsOperation.this.batchSize);
            }
        };
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> commandTransformer() {
        return new CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>>(){

            @Override
            public BatchCursor<T> apply(BsonDocument result, ConnectionSource source, Connection connection) {
                return OperationHelper.cursorDocumentToBatchCursor(result.getDocument((Object)"cursor"), ListCollectionsOperation.this.decoder, source, connection, ListCollectionsOperation.this.batchSize);
            }
        };
    }

    private MongoNamespace getNamespace() {
        return new MongoNamespace(this.databaseName, "system.namespaces");
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                return ListCollectionsOperation.this.getCommand();
            }
        };
    }

    private BsonDocument getCommand() {
        BsonDocument command = new BsonDocument("listCollections", (BsonValue)new BsonInt32(1)).append("cursor", (BsonValue)CursorHelper.getCursorDocumentFromBatchSize(this.batchSize == 0 ? null : Integer.valueOf(this.batchSize)));
        if (this.filter != null) {
            command.append("filter", (BsonValue)this.filter);
        }
        if (this.nameOnly) {
            command.append("nameOnly", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.maxTimeMS > 0L) {
            command.put("maxTimeMS", (BsonValue)new BsonInt64(this.maxTimeMS));
        }
        return command;
    }

    private BsonDocument asQueryDocument(ConnectionDescription connectionDescription, ReadPreference readPreference) {
        BsonDocument document = new BsonDocument();
        BsonDocument transformedFilter = null;
        if (this.filter != null) {
            if (this.filter.containsKey((Object)"name")) {
                if (!this.filter.isString((Object)"name")) {
                    throw new IllegalArgumentException("When filtering collections on MongoDB versions < 3.0 the name field must be a string");
                }
                transformedFilter = new BsonDocument();
                transformedFilter.putAll((Map)this.filter);
                transformedFilter.put("name", (BsonValue)new BsonString(String.format("%s.%s", this.databaseName, this.filter.getString((Object)"name").getValue())));
            } else {
                transformedFilter = this.filter;
            }
        }
        BsonDocument indexExcludingRegex = new BsonDocument("name", (BsonValue)new BsonRegularExpression("^[^$]*$"));
        BsonDocument query = transformedFilter == null ? indexExcludingRegex : new BsonDocument("$and", (BsonValue)new BsonArray(Arrays.asList(indexExcludingRegex, transformedFilter)));
        document.put("$query", (BsonValue)query);
        if (connectionDescription.getServerType() == ServerType.SHARD_ROUTER && !readPreference.equals(ReadPreference.primary())) {
            document.put("$readPreference", (BsonValue)readPreference.toDocument());
        }
        if (this.maxTimeMS > 0L) {
            document.put("$maxTimeMS", (BsonValue)new BsonInt64(this.maxTimeMS));
        }
        return document;
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, "firstBatch");
    }

    private List<T> projectFromFullNamespaceToCollectionName(List<BsonDocument> unstripped) {
        if (unstripped == null) {
            return null;
        }
        ArrayList<Object> stripped = new ArrayList<Object>(unstripped.size());
        String prefix = this.databaseName + ".";
        for (BsonDocument cur : unstripped) {
            String name = cur.getString((Object)"name").getValue();
            String collectionName = name.substring(prefix.length());
            cur.put("name", (BsonValue)new BsonString(collectionName));
            stripped.add(this.decoder.decode((BsonReader)new BsonDocumentReader(cur), DecoderContext.builder().build()));
        }
        return stripped;
    }

    private final class ProjectingAsyncBatchCursor
    implements AsyncBatchCursor<T> {
        private final AsyncBatchCursor<BsonDocument> delegate;

        private ProjectingAsyncBatchCursor(AsyncBatchCursor<BsonDocument> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void next(final SingleResultCallback<List<T>> callback) {
            this.delegate.next(new SingleResultCallback<List<BsonDocument>>(){

                @Override
                public void onResult(List<BsonDocument> result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult(ListCollectionsOperation.this.projectFromFullNamespaceToCollectionName(result), null);
                    }
                }
            });
        }

        @Override
        public void setBatchSize(int batchSize) {
            this.delegate.setBatchSize(batchSize);
        }

        @Override
        public int getBatchSize() {
            return this.delegate.getBatchSize();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }

    private final class ProjectingBatchCursor
    implements BatchCursor<T> {
        private final BatchCursor<BsonDocument> delegate;

        private ProjectingBatchCursor(BatchCursor<BsonDocument> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public List<T> next() {
            return ListCollectionsOperation.this.projectFromFullNamespaceToCollectionName((List)this.delegate.next());
        }

        @Override
        public void setBatchSize(int batchSize) {
            this.delegate.setBatchSize(batchSize);
        }

        @Override
        public int getBatchSize() {
            return this.delegate.getBatchSize();
        }

        @Override
        public List<T> tryNext() {
            return ListCollectionsOperation.this.projectFromFullNamespaceToCollectionName(this.delegate.tryNext());
        }

        @Override
        public ServerCursor getServerCursor() {
            return this.delegate.getServerCursor();
        }

        @Override
        public ServerAddress getServerAddress() {
            return this.delegate.getServerAddress();
        }
    }
}

