/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.StreamFactory;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ServerListener;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.ClusterableServerFactory;
import com.mongodb.internal.connection.DefaultConnectionFactory;
import com.mongodb.internal.connection.DefaultConnectionPool;
import com.mongodb.internal.connection.DefaultSdamServerDescriptionManager;
import com.mongodb.internal.connection.DefaultServer;
import com.mongodb.internal.connection.DefaultServerMonitor;
import com.mongodb.internal.connection.InternalStreamConnectionFactory;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.SdamServerDescriptionManager;
import com.mongodb.internal.connection.ServerDescriptionChangedListener;
import com.mongodb.internal.inject.SameObjectProvider;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ClusterId clusterId;
    private final ClusterSettings clusterSettings;
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final StreamFactory heartbeatStreamFactory;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    @Nullable
    private final ServerApi serverApi;

    public DefaultClusterableServerFactory(ClusterId clusterId, ClusterSettings clusterSettings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, MongoCredential credential, CommandListener commandListener, String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi) {
        this.clusterId = clusterId;
        this.clusterSettings = clusterSettings;
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.heartbeatStreamFactory = heartbeatStreamFactory;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
    }

    @Override
    public ClusterableServer create(ServerAddress serverAddress, ServerDescriptionChangedListener serverDescriptionChangedListener, ServerListener serverListener, ClusterClock clusterClock) {
        ServerId serverId = new ServerId(this.clusterId, serverAddress);
        SameObjectProvider<SdamServerDescriptionManager> sdamProvider = SameObjectProvider.uninitialized();
        DefaultServerMonitor serverMonitor = new DefaultServerMonitor(serverId, this.serverSettings, clusterClock, new InternalStreamConnectionFactory(this.clusterSettings.getMode(), this.heartbeatStreamFactory, null, this.applicationName, this.mongoDriverInformation, Collections.emptyList(), null, this.serverApi), this.serverApi, sdamProvider);
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(serverId, new InternalStreamConnectionFactory(this.clusterSettings.getMode(), this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.commandListener, this.serverApi), this.connectionPoolSettings, sdamProvider);
        DefaultSdamServerDescriptionManager sdam = new DefaultSdamServerDescriptionManager(serverId, serverDescriptionChangedListener, serverListener, serverMonitor, connectionPool, this.clusterSettings.getMode());
        sdamProvider.initialize(sdam);
        serverMonitor.start();
        return new DefaultServer(serverId, this.clusterSettings.getMode(), connectionPool, new DefaultConnectionFactory(), serverMonitor, sdam, serverListener, this.commandListener, clusterClock, true);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

