/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection.netty;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.NettyTransportSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.netty.NettyStreamFactory;
import com.mongodb.lang.Nullable;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import io.netty.handler.ssl.SslContext;
import java.util.Objects;

@Deprecated
public final class NettyStreamFactoryFactory
implements StreamFactoryFactory {
    private final EventLoopGroup eventLoopGroup;
    private final Class<? extends SocketChannel> socketChannelClass;
    private final ByteBufAllocator allocator;
    @Nullable
    private final SslContext sslContext;

    public static Builder builder() {
        return new Builder();
    }

    EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    Class<? extends SocketChannel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    ByteBufAllocator getAllocator() {
        return this.allocator;
    }

    @Nullable
    SslContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public StreamFactory create(SocketSettings socketSettings, SslSettings sslSettings) {
        return new NettyStreamFactory(socketSettings, sslSettings, this.eventLoopGroup, this.socketChannelClass, this.allocator, this.sslContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NettyStreamFactoryFactory that = (NettyStreamFactoryFactory)o;
        return Objects.equals(this.eventLoopGroup, that.eventLoopGroup) && Objects.equals(this.socketChannelClass, that.socketChannelClass) && Objects.equals(this.allocator, that.allocator) && Objects.equals(this.sslContext, that.sslContext);
    }

    public int hashCode() {
        return Objects.hash(this.eventLoopGroup, this.socketChannelClass, this.allocator, this.sslContext);
    }

    public String toString() {
        return "NettyStreamFactoryFactory{eventLoopGroup=" + this.eventLoopGroup + ", socketChannelClass=" + this.socketChannelClass + ", allocator=" + this.allocator + ", sslContext=" + this.sslContext + '}';
    }

    private NettyStreamFactoryFactory(Builder builder) {
        this.allocator = builder.allocator == null ? ByteBufAllocator.DEFAULT : builder.allocator;
        this.socketChannelClass = builder.socketChannelClass == null ? NioSocketChannel.class : builder.socketChannelClass;
        this.eventLoopGroup = builder.eventLoopGroup == null ? new NioEventLoopGroup() : builder.eventLoopGroup;
        this.sslContext = builder.sslContext;
    }

    public static final class Builder {
        private ByteBufAllocator allocator;
        private Class<? extends SocketChannel> socketChannelClass;
        private EventLoopGroup eventLoopGroup;
        @Nullable
        private SslContext sslContext;

        private Builder() {
        }

        public Builder applySettings(NettyTransportSettings settings) {
            this.allocator = settings.getAllocator();
            this.eventLoopGroup = settings.getEventLoopGroup();
            this.sslContext = settings.getSslContext();
            this.socketChannelClass = settings.getSocketChannelClass();
            return this;
        }

        public Builder allocator(ByteBufAllocator allocator) {
            this.allocator = Assertions.notNull("allocator", allocator);
            return this;
        }

        public Builder socketChannelClass(Class<? extends SocketChannel> socketChannelClass) {
            this.socketChannelClass = Assertions.notNull("socketChannelClass", socketChannelClass);
            return this;
        }

        public Builder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = Assertions.notNull("eventLoopGroup", eventLoopGroup);
            return this;
        }

        public Builder sslContext(SslContext sslContext) {
            this.sslContext = Assertions.notNull("sslContext", sslContext);
            Assertions.isTrueArgument("sslContext must be client-side", sslContext.isClient());
            Assertions.isTrueArgument("sslContext must use either SslProvider.JDK or SslProvider.OPENSSL TLS/SSL protocol provider", !(sslContext instanceof ReferenceCountedOpenSslClientContext));
            return this;
        }

        public NettyStreamFactoryFactory build() {
            return new NettyStreamFactoryFactory(this);
        }
    }
}

