/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.CompositeByteBuf;
import com.mongodb.lang.Nullable;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.ByteBuf;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BsonInput;
import org.bson.io.ByteBufferBsonInput;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

final class ByteBufBsonDocument
extends BsonDocument {
    private static final long serialVersionUID = 2L;
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()});
    private final transient ByteBuf byteBuf;

    static List<ByteBufBsonDocument> createList(ByteBufferBsonOutput bsonOutput, int startPosition) {
        List<ByteBuf> duplicateByteBuffers = bsonOutput.getByteBuffers();
        CompositeByteBuf outputByteBuf = new CompositeByteBuf(duplicateByteBuffers);
        outputByteBuf.position(startPosition);
        ArrayList<ByteBufBsonDocument> documents = new ArrayList<ByteBufBsonDocument>();
        int curDocumentStartPosition = startPosition;
        while (outputByteBuf.hasRemaining()) {
            int documentSizeInBytes = outputByteBuf.getInt();
            ByteBuf slice = outputByteBuf.duplicate();
            slice.position(curDocumentStartPosition);
            slice.limit(curDocumentStartPosition + documentSizeInBytes);
            documents.add(new ByteBufBsonDocument(slice));
            curDocumentStartPosition += documentSizeInBytes;
            outputByteBuf.position(outputByteBuf.position() + documentSizeInBytes - 4);
        }
        for (ByteBuf byteBuffer : duplicateByteBuffers) {
            byteBuffer.release();
        }
        return documents;
    }

    static ByteBufBsonDocument createOne(ByteBufferBsonOutput bsonOutput, int startPosition) {
        List<ByteBuf> duplicateByteBuffers = bsonOutput.getByteBuffers();
        CompositeByteBuf outputByteBuf = new CompositeByteBuf(duplicateByteBuffers);
        outputByteBuf.position(startPosition);
        int documentSizeInBytes = outputByteBuf.getInt();
        ByteBuf slice = outputByteBuf.duplicate();
        slice.position(startPosition);
        slice.limit(startPosition + documentSizeInBytes);
        for (ByteBuf byteBuffer : duplicateByteBuffers) {
            byteBuffer.release();
        }
        return new ByteBufBsonDocument(slice);
    }

    public String toJson() {
        return this.toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build());
    }

    public String toJson(JsonWriterSettings settings) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter, settings);
        ByteBuf duplicate = this.byteBuf.duplicate();
        try {
            String string;
            try (BsonBinaryReader reader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(duplicate));){
                jsonWriter.pipe((BsonReader)reader);
                string = stringWriter.toString();
            }
            return string;
        }
        finally {
            duplicate.release();
        }
    }

    public BsonReader asBsonReader() {
        return new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(this.byteBuf.duplicate()));
    }

    public BsonDocument clone() {
        byte[] clonedBytes = new byte[this.byteBuf.remaining()];
        this.byteBuf.get(this.byteBuf.position(), clonedBytes);
        return new RawBsonDocument(clonedBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    <T> T findInDocument(Finder<T> finder) {
        ByteBuf duplicateByteBuf = this.byteBuf.duplicate();
        try (BsonBinaryReader bsonReader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(this.byteBuf.duplicate()));){
            bsonReader.readStartDocument();
            while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                T found = finder.find((BsonReader)bsonReader);
                if (found == null) continue;
                T t = found;
                return t;
            }
            bsonReader.readEndDocument();
            return finder.notFound();
        }
        finally {
            duplicateByteBuf.release();
        }
    }

    int getSizeInBytes() {
        return this.byteBuf.getInt(this.byteBuf.position());
    }

    BsonDocument toBaseBsonDocument() {
        ByteBuf duplicateByteBuf = this.byteBuf.duplicate();
        try {
            BsonDocument bsonDocument;
            try (BsonBinaryReader bsonReader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(duplicateByteBuf));){
                bsonDocument = new BsonDocumentCodec().decode((BsonReader)bsonReader, DecoderContext.builder().build());
            }
            return bsonDocument;
        }
        finally {
            duplicateByteBuf.release();
        }
    }

    ByteBufBsonDocument(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    public void clear() {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    public BsonValue put(String key, BsonValue value) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    public BsonDocument append(String key, BsonValue value) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    public void putAll(Map<? extends String, ? extends BsonValue> m) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    public BsonValue remove(Object key) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    public boolean isEmpty() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(BsonReader bsonReader) {
                return false;
            }

            @Override
            public Boolean notFound() {
                return true;
            }
        }));
    }

    public int size() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<Integer>(){
            private int size;

            @Override
            @Nullable
            public Integer find(BsonReader bsonReader) {
                ++this.size;
                bsonReader.readName();
                bsonReader.skipValue();
                return null;
            }

            @Override
            public Integer notFound() {
                return this.size;
            }
        }));
    }

    public Set<Map.Entry<String, BsonValue>> entrySet() {
        return this.toBaseBsonDocument().entrySet();
    }

    public Collection<BsonValue> values() {
        return this.toBaseBsonDocument().values();
    }

    public Set<String> keySet() {
        return this.toBaseBsonDocument().keySet();
    }

    public boolean containsKey(final Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        Boolean containsKey = this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(BsonReader bsonReader) {
                if (bsonReader.readName().equals(key)) {
                    return true;
                }
                bsonReader.skipValue();
                return null;
            }

            @Override
            public Boolean notFound() {
                return false;
            }
        });
        return containsKey != null ? containsKey : false;
    }

    public boolean containsValue(final Object value) {
        Boolean containsValue = this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(BsonReader bsonReader) {
                bsonReader.skipName();
                if (ByteBufBsonDocument.this.deserializeBsonValue(bsonReader).equals(value)) {
                    return true;
                }
                return null;
            }

            @Override
            public Boolean notFound() {
                return false;
            }
        });
        return containsValue != null ? containsValue : false;
    }

    @Nullable
    public BsonValue get(final Object key) {
        Assertions.notNull("key", key);
        return this.findInDocument(new Finder<BsonValue>(){

            @Override
            public BsonValue find(BsonReader bsonReader) {
                if (bsonReader.readName().equals(key)) {
                    return ByteBufBsonDocument.this.deserializeBsonValue(bsonReader);
                }
                bsonReader.skipValue();
                return null;
            }

            @Override
            @Nullable
            public BsonValue notFound() {
                return null;
            }
        });
    }

    public String getFirstKey() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<String>(){

            @Override
            public String find(BsonReader bsonReader) {
                return bsonReader.readName();
            }

            @Override
            public String notFound() {
                throw new NoSuchElementException();
            }
        }));
    }

    private BsonValue deserializeBsonValue(BsonReader bsonReader) {
        return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType((BsonType)bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
    }

    private Object writeReplace() {
        return this.toBaseBsonDocument();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static interface Finder<T> {
        @Nullable
        public T find(BsonReader var1);

        @Nullable
        public T notFound();
    }
}

