/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoQueryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncCryptBinding;
import com.mongodb.internal.async.client.AsyncMongoClientImpl;
import com.mongodb.internal.async.client.ClientSessionBinding;
import com.mongodb.internal.async.client.ClientSessionHelper;
import com.mongodb.internal.async.client.Crypt;
import com.mongodb.internal.async.client.OperationExecutor;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncClusterBinding;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.lang.Nullable;

class OperationExecutorImpl
implements OperationExecutor {
    private static final Logger LOGGER = Loggers.getLogger("client");
    private final AsyncMongoClientImpl mongoClient;
    private final ClientSessionHelper clientSessionHelper;

    OperationExecutorImpl(AsyncMongoClientImpl mongoClient, ClientSessionHelper clientSessionHelper) {
        this.mongoClient = mongoClient;
        this.clientSessionHelper = clientSessionHelper;
    }

    @Override
    public <T> void execute(AsyncReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern, SingleResultCallback<T> callback) {
        this.execute(operation, readPreference, readConcern, null, callback);
    }

    @Override
    public <T> void execute(final AsyncReadOperation<T> operation, final ReadPreference readPreference, final ReadConcern readConcern, final @Nullable AsyncClientSession session, SingleResultCallback<T> callback) {
        Assertions.notNull("operation", operation);
        Assertions.notNull("readPreference", readPreference);
        Assertions.notNull("callback", callback);
        final SingleResultCallback<T> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        this.clientSessionHelper.withClientSession(session, this, new SingleResultCallback<AsyncClientSession>(){

            @Override
            public void onResult(AsyncClientSession clientSession, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    OperationExecutorImpl.this.getReadWriteBinding(readPreference, readConcern, clientSession, session == null && clientSession != null, new SingleResultCallback<AsyncReadWriteBinding>(){

                        @Override
                        public void onResult(final AsyncReadWriteBinding binding, Throwable t) {
                            if (t != null) {
                                errHandlingCallback.onResult(null, t);
                            } else if (session != null && session.hasActiveTransaction() && !binding.getReadPreference().equals(ReadPreference.primary())) {
                                binding.release();
                                errHandlingCallback.onResult(null, new MongoClientException("Read preference in a transaction must be primary"));
                            } else {
                                operation.executeAsync(binding, new SingleResultCallback<T>(){

                                    @Override
                                    public void onResult(T result, Throwable t) {
                                        try {
                                            OperationExecutorImpl.this.labelException(t, session);
                                            OperationExecutorImpl.this.unpinServerAddressOnTransientTransactionError(session, t);
                                            errHandlingCallback.onResult(result, t);
                                        }
                                        finally {
                                            binding.release();
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public <T> void execute(AsyncWriteOperation<T> operation, ReadConcern readConcern, SingleResultCallback<T> callback) {
        this.execute(operation, readConcern, null, callback);
    }

    @Override
    public <T> void execute(final AsyncWriteOperation<T> operation, final ReadConcern readConcern, final @Nullable AsyncClientSession session, SingleResultCallback<T> callback) {
        Assertions.notNull("operation", operation);
        Assertions.notNull("callback", callback);
        final SingleResultCallback<T> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        this.clientSessionHelper.withClientSession(session, this, new SingleResultCallback<AsyncClientSession>(){

            @Override
            public void onResult(AsyncClientSession clientSession, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    OperationExecutorImpl.this.getReadWriteBinding(ReadPreference.primary(), readConcern, clientSession, session == null && clientSession != null, new SingleResultCallback<AsyncReadWriteBinding>(){

                        @Override
                        public void onResult(final AsyncReadWriteBinding binding, Throwable t) {
                            if (t != null) {
                                errHandlingCallback.onResult(null, t);
                            } else {
                                operation.executeAsync(binding, new SingleResultCallback<T>(){

                                    @Override
                                    public void onResult(T result, Throwable t) {
                                        try {
                                            OperationExecutorImpl.this.labelException(t, session);
                                            OperationExecutorImpl.this.unpinServerAddressOnTransientTransactionError(session, t);
                                            errHandlingCallback.onResult(result, t);
                                        }
                                        finally {
                                            binding.release();
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    private void labelException(Throwable t, AsyncClientSession session) {
        if (session != null && session.hasActiveTransaction() && (t instanceof MongoSocketException || t instanceof MongoTimeoutException || t instanceof MongoQueryException && ((MongoQueryException)t).getErrorCode() == 91) && !((MongoException)t).hasErrorLabel("UnknownTransactionCommitResult")) {
            ((MongoException)t).addLabel("TransientTransactionError");
        }
    }

    private void unpinServerAddressOnTransientTransactionError(@Nullable AsyncClientSession session, Throwable throwable) {
        if (session != null && throwable != null && throwable instanceof MongoException && ((MongoException)throwable).hasErrorLabel("TransientTransactionError")) {
            session.setPinnedServerAddress(null);
        }
    }

    private void getReadWriteBinding(ReadPreference readPreference, ReadConcern readConcern, @Nullable AsyncClientSession session, boolean ownsSession, SingleResultCallback<AsyncReadWriteBinding> callback) {
        Assertions.notNull("readPreference", readPreference);
        AsyncClusterAwareReadWriteBinding readWriteBinding = new AsyncClusterBinding(this.mongoClient.getCluster(), this.getReadPreferenceForBinding(readPreference, session), readConcern);
        Crypt crypt = this.mongoClient.getCrypt();
        if (crypt != null) {
            readWriteBinding = new AsyncCryptBinding(readWriteBinding, crypt);
        }
        if (session != null) {
            callback.onResult(new ClientSessionBinding(session, ownsSession, readWriteBinding), null);
        } else {
            callback.onResult(readWriteBinding, null);
        }
    }

    private ReadPreference getReadPreferenceForBinding(ReadPreference readPreference, @Nullable AsyncClientSession session) {
        if (session == null) {
            return readPreference;
        }
        if (session.hasActiveTransaction()) {
            ReadPreference readPreferenceForBinding = session.getTransactionOptions().getReadPreference();
            if (readPreferenceForBinding == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read preference can not be null");
            }
            return readPreferenceForBinding;
        }
        return readPreference;
    }
}

