/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerSettings;
import com.mongodb.internal.connection.ClusterDescriptionHelper;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.selector.WritableServerSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Immutable
public class ClusterDescription {
    private final ClusterConnectionMode connectionMode;
    private final ClusterType type;
    private final List<ServerDescription> serverDescriptions;
    private final ClusterSettings clusterSettings;
    private final ServerSettings serverSettings;
    private final MongoException srvResolutionException;

    public ClusterDescription(ClusterConnectionMode connectionMode, ClusterType type, List<ServerDescription> serverDescriptions) {
        this(connectionMode, type, serverDescriptions, null, null);
    }

    public ClusterDescription(ClusterConnectionMode connectionMode, ClusterType type, List<ServerDescription> serverDescriptions, ClusterSettings clusterSettings, ServerSettings serverSettings) {
        this(connectionMode, type, null, serverDescriptions, clusterSettings, serverSettings);
    }

    public ClusterDescription(ClusterConnectionMode connectionMode, ClusterType type, MongoException srvResolutionException, List<ServerDescription> serverDescriptions, ClusterSettings clusterSettings, ServerSettings serverSettings) {
        Assertions.notNull("all", serverDescriptions);
        this.connectionMode = Assertions.notNull("connectionMode", connectionMode);
        this.type = Assertions.notNull("type", type);
        this.srvResolutionException = srvResolutionException;
        this.serverDescriptions = new ArrayList<ServerDescription>(serverDescriptions);
        this.clusterSettings = clusterSettings;
        this.serverSettings = serverSettings;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public boolean isCompatibleWithDriver() {
        for (ServerDescription cur : this.serverDescriptions) {
            if (cur.isCompatibleWithDriver()) continue;
            return false;
        }
        return true;
    }

    public ServerDescription findServerIncompatiblyOlderThanDriver() {
        for (ServerDescription cur : this.serverDescriptions) {
            if (!cur.isIncompatiblyOlderThanDriver()) continue;
            return cur;
        }
        return null;
    }

    public ServerDescription findServerIncompatiblyNewerThanDriver() {
        for (ServerDescription cur : this.serverDescriptions) {
            if (!cur.isIncompatiblyNewerThanDriver()) continue;
            return cur;
        }
        return null;
    }

    public boolean hasReadableServer(ReadPreference readPreference) {
        Assertions.notNull("readPreference", readPreference);
        return !new ReadPreferenceServerSelector(readPreference).select(this).isEmpty();
    }

    public boolean hasWritableServer() {
        return !new WritableServerSelector().select(this).isEmpty();
    }

    public ClusterConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public ClusterType getType() {
        return this.type;
    }

    public MongoException getSrvResolutionException() {
        return this.srvResolutionException;
    }

    public List<ServerDescription> getServerDescriptions() {
        return Collections.unmodifiableList(this.serverDescriptions);
    }

    public Integer getLogicalSessionTimeoutMinutes() {
        Integer retVal = null;
        for (ServerDescription cur : ClusterDescriptionHelper.getServersByPredicate(this, serverDescription -> serverDescription.isPrimary() || serverDescription.isSecondary())) {
            if (cur.getLogicalSessionTimeoutMinutes() == null) {
                return null;
            }
            if (retVal == null) {
                retVal = cur.getLogicalSessionTimeoutMinutes();
                continue;
            }
            retVal = Math.min(retVal, cur.getLogicalSessionTimeoutMinutes());
        }
        return retVal;
    }

    public boolean equals(Object o) {
        String thatExceptionMessage;
        Class<?> thatExceptionClass;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterDescription that = (ClusterDescription)o;
        if (this.connectionMode != that.connectionMode) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.serverDescriptions.size() != that.serverDescriptions.size()) {
            return false;
        }
        if (!this.serverDescriptions.containsAll(that.serverDescriptions)) {
            return false;
        }
        Class<?> thisExceptionClass = this.srvResolutionException != null ? this.srvResolutionException.getClass() : null;
        Class<?> clazz = thatExceptionClass = that.srvResolutionException != null ? that.srvResolutionException.getClass() : null;
        if (thisExceptionClass != null ? !thisExceptionClass.equals(thatExceptionClass) : thatExceptionClass != null) {
            return false;
        }
        String thisExceptionMessage = this.srvResolutionException != null ? this.srvResolutionException.getMessage() : null;
        String string = thatExceptionMessage = that.srvResolutionException != null ? that.srvResolutionException.getMessage() : null;
        return !(thisExceptionMessage != null ? !thisExceptionMessage.equals(thatExceptionMessage) : thatExceptionMessage != null);
    }

    public int hashCode() {
        int result = this.connectionMode.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.srvResolutionException == null ? 0 : this.srvResolutionException.hashCode());
        result = 31 * result + this.serverDescriptions.hashCode();
        return result;
    }

    public String toString() {
        return "ClusterDescription{type=" + (Object)((Object)this.getType()) + (this.srvResolutionException == null ? "" : ", srvResolutionException=" + this.srvResolutionException) + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", serverDescriptions=" + this.serverDescriptions + '}';
    }

    public String getShortDescription() {
        StringBuilder serverDescriptions = new StringBuilder();
        String delimiter = "";
        for (ServerDescription cur : this.serverDescriptions) {
            serverDescriptions.append(delimiter).append(cur.getShortDescription());
            delimiter = ", ";
        }
        if (this.srvResolutionException == null) {
            return String.format("{type=%s, servers=[%s]", new Object[]{this.type, serverDescriptions});
        }
        return String.format("{type=%s, srvResolutionException=%s, servers=[%s]", new Object[]{this.type, this.srvResolutionException, serverDescriptions});
    }
}

