/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ReadBinding;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AsyncChangeStreamBatchCursor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.ChangeStreamBatchCursor;
import com.mongodb.operation.ReadOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.Decoder;
import org.bson.codecs.RawBsonDocumentCodec;

public class ChangeStreamOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final RawBsonDocumentCodec RAW_BSON_DOCUMENT_CODEC = new RawBsonDocumentCodec();
    private final MongoNamespace namespace;
    private final FullDocument fullDocument;
    private final List<BsonDocument> pipeline;
    private final Decoder<T> decoder;
    private BsonDocument resumeToken;
    private Integer batchSize;
    private Collation collation;
    private long maxAwaitTimeMS;

    public ChangeStreamOperation(MongoNamespace namespace, FullDocument fullDocument, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public FullDocument getFullDocument() {
        return this.fullDocument;
    }

    public BsonDocument getResumeToken() {
        return this.resumeToken;
    }

    public ChangeStreamOperation<T> resumeAfter(BsonDocument resumeToken) {
        this.resumeToken = resumeToken;
        return this;
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public ChangeStreamOperation<T> batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public ChangeStreamOperation<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxAwaitTime >= 0", maxAwaitTime >= 0L);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public ChangeStreamOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return new ChangeStreamBatchCursor(this, (BatchCursor<RawBsonDocument>)this.createAggregateOperation().execute(binding), binding);
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.createAggregateOperation().executeAsync(binding, new SingleResultCallback<AsyncBatchCursor<RawBsonDocument>>(){

            @Override
            public void onResult(AsyncBatchCursor<RawBsonDocument> result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new AsyncChangeStreamBatchCursor(ChangeStreamOperation.this, result, binding), null);
                }
            }
        });
    }

    private AggregateOperation<RawBsonDocument> createAggregateOperation() {
        ArrayList<BsonDocument> changeStreamPipeline = new ArrayList<BsonDocument>();
        BsonDocument changeStream = new BsonDocument("fullDocument", (BsonValue)new BsonString(this.fullDocument.getValue()));
        if (this.resumeToken != null) {
            changeStream.append("resumeAfter", (BsonValue)this.resumeToken);
        }
        changeStreamPipeline.add(new BsonDocument("$changeStream", (BsonValue)changeStream));
        changeStreamPipeline.addAll(this.pipeline);
        return new AggregateOperation(this.namespace, (List<BsonDocument>)changeStreamPipeline, RAW_BSON_DOCUMENT_CODEC).maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS).batchSize(this.batchSize).collation(this.collation);
    }
}

