/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.assertions.Assertions;
import com.mongodb.session.SessionContext;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

final class ReadConcernHelper {
    static void appendReadConcernToCommand(ReadConcern readConcern, SessionContext sessionContext, BsonDocument commandDocument) {
        Assertions.notNull("readConcern", readConcern);
        Assertions.notNull("sessionContext", sessionContext);
        Assertions.notNull("commandDocument", commandDocument);
        BsonDocument readConcernDocument = new BsonDocument();
        ReadConcernLevel level = ReadConcernHelper.getReadConcernLevel(readConcern, sessionContext);
        if (level != null) {
            readConcernDocument.append("level", (BsonValue)new BsonString(level.getValue()));
        }
        if (ReadConcernHelper.shouldAddAfterClusterTime(sessionContext)) {
            readConcernDocument.append("afterClusterTime", (BsonValue)sessionContext.getOperationTime());
        }
        if (!readConcernDocument.isEmpty()) {
            commandDocument.append("readConcern", (BsonValue)readConcernDocument);
        }
    }

    private static ReadConcernLevel getReadConcernLevel(ReadConcern readConcern, SessionContext sessionContext) {
        if (readConcern.getLevel() == null && ReadConcernHelper.shouldAddAfterClusterTime(sessionContext)) {
            return ReadConcernLevel.LOCAL;
        }
        return readConcern.getLevel();
    }

    private static boolean shouldAddAfterClusterTime(SessionContext sessionContext) {
        return sessionContext.isCausallyConsistent() && sessionContext.getOperationTime() != null;
    }

    private ReadConcernHelper() {
    }
}

