/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.CommandProtocol;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.SessionContext;
import com.mongodb.connection.SimpleCommandMessage;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

class SimpleCommandProtocol<T>
implements CommandProtocol<T> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.command");
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final Decoder<T> commandResultDecoder;
    private final FieldNameValidator fieldNameValidator;
    private SessionContext sessionContext;
    private ReadPreference readPreference;

    SimpleCommandProtocol(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder) {
        Assertions.notNull("database", database);
        this.namespace = new MongoNamespace(database, "$cmd");
        this.command = Assertions.notNull("command", command);
        this.commandResultDecoder = Assertions.notNull("commandResultDecoder", commandResultDecoder);
        this.fieldNameValidator = Assertions.notNull("fieldNameValidator", fieldNameValidator);
    }

    public SimpleCommandProtocol<T> readPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    @Override
    public T execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Sending command {%s : %s} to database %s on connection [%s] to server %s", this.getCommandName(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        SimpleCommandMessage commandMessage = new SimpleCommandMessage(this.namespace.getFullName(), this.command, this.readPreference, this.fieldNameValidator, ProtocolHelper.getMessageSettings(connection.getDescription()));
        T retval = connection.sendAndReceive(commandMessage, this.commandResultDecoder, this.sessionContext);
        LOGGER.debug("Command execution completed");
        return retval;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<T> callback) {
        SimpleCommandMessage message = new SimpleCommandMessage(this.namespace.getFullName(), this.command, this.readPreference, this.fieldNameValidator, ProtocolHelper.getMessageSettings(connection.getDescription()));
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously sending command {%s : %s} to database %s on connection [%s] to server %s", this.getCommandName(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            connection.sendAndReceiveAsync(message, this.commandResultDecoder, this.sessionContext, new SingleResultCallback<T>(){

                @Override
                public void onResult(T result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    public SimpleCommandProtocol<T> sessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        return this;
    }

    private String getCommandName() {
        return (String)this.command.keySet().iterator().next();
    }
}

