/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.connection.CommandMessage;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import com.mongodb.connection.SessionContext;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBinaryWriterSettings;
import org.bson.BsonDocument;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.io.BsonOutput;

abstract class BaseWriteCommandMessage
extends CommandMessage {
    private static final int HEADROOM = 16384;
    private final MongoNamespace writeNamespace;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private final Boolean bypassDocumentValidation;

    BaseWriteCommandMessage(MongoNamespace writeNamespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, MessageSettings settings) {
        super(new MongoNamespace(writeNamespace.getDatabaseName(), "$cmd").getFullName(), BaseWriteCommandMessage.getOpCode(settings), settings);
        this.writeNamespace = writeNamespace;
        this.ordered = ordered;
        this.writeConcern = writeConcern;
        this.bypassDocumentValidation = bypassDocumentValidation;
    }

    public MongoNamespace getWriteNamespace() {
        return this.writeNamespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public abstract int getItemCount();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput outputStream, SessionContext sessionContext) {
        BaseWriteCommandMessage nextMessage;
        this.writeCommandHeader(outputStream);
        int commandStartPosition = outputStream.getPosition();
        int firstDocumentStartPosition = outputStream.getPosition();
        BsonBinaryWriter writer = new BsonBinaryWriter(new BsonWriterSettings(), new BsonBinaryWriterSettings(this.getSettings().getMaxDocumentSize() + 16384), outputStream, this.getFieldNameValidator());
        try {
            writer.writeStartDocument();
            this.writeCommandPrologue(writer);
            nextMessage = this.writeTheWrites(outputStream, commandStartPosition, writer);
            if (this.useOpMsg()) {
                writer.writeString("$db", this.getWriteNamespace().getDatabaseName());
                if (sessionContext.hasSession()) {
                    if (sessionContext.getClusterTime() != null) {
                        writer.writeName("$clusterTime");
                        new BsonDocumentCodec().encode((BsonWriter)writer, sessionContext.getClusterTime(), EncoderContext.builder().build());
                    }
                    writer.writeName("lsid");
                    new BsonDocumentCodec().encode((BsonWriter)writer, sessionContext.getSessionId(), EncoderContext.builder().build());
                }
            }
            writer.writeEndDocument();
        }
        finally {
            writer.close();
        }
        return new RequestMessage.EncodingMetadata(nextMessage, firstDocumentStartPosition);
    }

    @Override
    boolean isResponseExpected() {
        return !this.useOpMsg() || this.writeConcern.isAcknowledged();
    }

    protected abstract FieldNameValidator getFieldNameValidator();

    private void writeCommandHeader(BsonOutput outputStream) {
        if (this.useOpMsg()) {
            outputStream.writeInt32(this.getFlagBits());
            outputStream.writeByte(0);
        } else {
            outputStream.writeInt32(0);
            outputStream.writeCString(this.getCollectionName());
            outputStream.writeInt32(0);
            outputStream.writeInt32(-1);
        }
    }

    protected abstract String getCommandName();

    protected abstract BaseWriteCommandMessage writeTheWrites(BsonOutput var1, int var2, BsonBinaryWriter var3);

    boolean exceedsLimits(int batchLength, int batchItemCount) {
        return this.exceedsBatchLengthLimit(batchLength, batchItemCount) || this.exceedsBatchItemCountLimit(batchItemCount);
    }

    private boolean exceedsBatchLengthLimit(int batchLength, int batchItemCount) {
        return batchLength > this.getSettings().getMaxDocumentSize() && batchItemCount > 1;
    }

    private boolean exceedsBatchItemCountLimit(int batchItemCount) {
        return batchItemCount > this.getSettings().getMaxBatchCount();
    }

    private void writeCommandPrologue(BsonBinaryWriter writer) {
        writer.writeString(this.getCommandName(), this.getWriteNamespace().getCollectionName());
        writer.writeBoolean("ordered", this.ordered);
        if (!this.getWriteConcern().isServerDefault()) {
            writer.writeName("writeConcern");
            BsonDocument document = this.getWriteConcern().asDocument();
            this.getCodec(document).encode((BsonWriter)writer, (Object)document, EncoderContext.builder().build());
        }
        if (this.getBypassDocumentValidation() != null) {
            writer.writeBoolean("bypassDocumentValidation", this.getBypassDocumentValidation().booleanValue());
        }
    }

    private int getFlagBits() {
        if (this.writeConcern.isAcknowledged()) {
            return 0;
        }
        return 2;
    }
}

