/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.changestream;

import com.mongodb.MongoNamespace;
import com.mongodb.client.model.changestream.ChangeStreamDocumentCodec;
import com.mongodb.client.model.changestream.OperationType;
import com.mongodb.client.model.changestream.UpdateDescription;
import org.bson.BsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonProperty;

public final class ChangeStreamDocument<TDocument> {
    @BsonId
    private final BsonDocument resumeToken;
    @BsonProperty(value="ns")
    private final MongoNamespace namespace;
    private final TDocument fullDocument;
    private final OperationType operationType;
    private final UpdateDescription updateDescription;

    @BsonCreator
    public ChangeStreamDocument(@BsonProperty(value="resumeToken") BsonDocument resumeToken, @BsonProperty(value="namespace") MongoNamespace namespace, @BsonProperty(value="fullDocument") TDocument fullDocument, @BsonProperty(value="operationType") OperationType operationType, @BsonProperty(value="updateDescription") UpdateDescription updateDescription) {
        this.resumeToken = resumeToken;
        this.namespace = namespace;
        this.fullDocument = fullDocument;
        this.operationType = operationType;
        this.updateDescription = updateDescription;
    }

    public BsonDocument getResumeToken() {
        return this.resumeToken;
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public TDocument getFullDocument() {
        return this.fullDocument;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public UpdateDescription getUpdateDescription() {
        return this.updateDescription;
    }

    public static <TFullDocument> Codec<ChangeStreamDocument<TFullDocument>> createCodec(Class<TFullDocument> fullDocumentClass, CodecRegistry codecRegistry) {
        return new ChangeStreamDocumentCodec<TFullDocument>(fullDocumentClass, codecRegistry);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeStreamDocument that = (ChangeStreamDocument)o;
        if (!this.getResumeToken().equals((Object)that.getResumeToken())) {
            return false;
        }
        if (!this.getNamespace().equals(that.getNamespace())) {
            return false;
        }
        if (!this.getFullDocument().equals(that.getFullDocument())) {
            return false;
        }
        if (this.getOperationType() != that.getOperationType()) {
            return false;
        }
        return !(this.getUpdateDescription() != null ? !this.getUpdateDescription().equals(that.getUpdateDescription()) : that.getUpdateDescription() != null);
    }

    public int hashCode() {
        int result = this.getResumeToken().hashCode();
        result = 31 * result + this.getNamespace().hashCode();
        result = 31 * result + this.getFullDocument().hashCode();
        result = 31 * result + this.getOperationType().hashCode();
        result = 31 * result + (this.getUpdateDescription() != null ? this.getUpdateDescription().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ChangeStreamOutput{resumeToken=" + this.resumeToken + ", namespace=" + this.namespace + ", fullDocument=" + this.fullDocument + ", operationType=" + (Object)((Object)this.operationType) + ", updateDescription=" + this.updateDescription + "}";
    }
}

