/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.MongoServerException;
import com.mongodb.ReadPreference;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.SimpleCommandMessage;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;

final class CommandHelper {
    static BsonDocument executeCommand(String database, BsonDocument command, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, internalConnection);
    }

    static BsonDocument executeCommandWithoutCheckingForFailure(String database, BsonDocument command, InternalConnection internalConnection) {
        try {
            return CommandHelper.sendAndReceive(database, command, internalConnection);
        }
        catch (MongoServerException e) {
            return new BsonDocument();
        }
    }

    static void executeCommandAsync(String database, BsonDocument command, InternalConnection internalConnection, final SingleResultCallback<BsonDocument> callback) {
        SimpleCommandMessage message = new SimpleCommandMessage(new MongoNamespace(database, "$cmd").getFullName(), command, ReadPreference.primary(), MessageSettings.builder().serverVersion(internalConnection.getDescription().getServerVersion()).build());
        internalConnection.sendAndReceiveAsync(message, new BsonDocumentCodec(), new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(result, null);
                }
            }
        });
    }

    static boolean isCommandOk(BsonDocument response) {
        if (!response.containsKey((Object)"ok")) {
            return false;
        }
        BsonValue okValue = response.get((Object)"ok");
        if (okValue.isBoolean()) {
            return okValue.asBoolean().getValue();
        }
        if (okValue.isNumber()) {
            return okValue.asNumber().intValue() == 1;
        }
        return false;
    }

    private static BsonDocument sendAndReceive(String database, BsonDocument command, InternalConnection internalConnection) {
        SimpleCommandMessage message = new SimpleCommandMessage(new MongoNamespace(database, "$cmd").getFullName(), command, ReadPreference.primary(), MessageSettings.builder().serverVersion(internalConnection.getDescription().getServerVersion()).build());
        return (BsonDocument)internalConnection.sendAndReceive(message, new BsonDocumentCodec());
    }

    private CommandHelper() {
    }
}

